/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletException;
import org.apache.juneau.BeanContext;
import org.apache.juneau.ConfigException;
import org.apache.juneau.DefaultFilteringObjectMap;
import org.apache.juneau.InvalidDataConversionException;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.annotation.ConfigurableContext;
import org.apache.juneau.encoders.Encoder;
import org.apache.juneau.encoders.EncoderGroup;
import org.apache.juneau.encoders.IdentityEncoder;
import org.apache.juneau.http.MediaType;
import org.apache.juneau.http.annotation.FormData;
import org.apache.juneau.http.annotation.Header;
import org.apache.juneau.http.annotation.Query;
import org.apache.juneau.http.annotation.ResponseBody;
import org.apache.juneau.http.annotation.ResponseHeader;
import org.apache.juneau.http.exception.BadRequest;
import org.apache.juneau.http.exception.InternalServerError;
import org.apache.juneau.httppart.HttpPartParser;
import org.apache.juneau.httppart.HttpPartSchema;
import org.apache.juneau.httppart.HttpPartSerializer;
import org.apache.juneau.httppart.HttpPartType;
import org.apache.juneau.httppart.bean.ResponseBeanMeta;
import org.apache.juneau.internal.ClassUtils;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.HttpUtils;
import org.apache.juneau.internal.ObjectUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.jsonschema.JsonSchemaGenerator;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.parser.Parser;
import org.apache.juneau.parser.ParserGroup;
import org.apache.juneau.reflect.MethodInfo;
import org.apache.juneau.rest.ClientVersionMatcher;
import org.apache.juneau.rest.Enablement;
import org.apache.juneau.rest.HttpRuntimeException;
import org.apache.juneau.rest.RequestPath;
import org.apache.juneau.rest.RequestProperties;
import org.apache.juneau.rest.ResponsePartMeta;
import org.apache.juneau.rest.RestCall;
import org.apache.juneau.rest.RestCallLoggerConfig;
import org.apache.juneau.rest.RestContext;
import org.apache.juneau.rest.RestConverter;
import org.apache.juneau.rest.RestGuard;
import org.apache.juneau.rest.RestMatcher;
import org.apache.juneau.rest.RestMethodContextBuilder;
import org.apache.juneau.rest.RestMethodParam;
import org.apache.juneau.rest.RestMethodProperties;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.rest.RestResourceResolver;
import org.apache.juneau.rest.RestResponse;
import org.apache.juneau.rest.guards.RoleBasedRestGuard;
import org.apache.juneau.rest.util.RestUtils;
import org.apache.juneau.rest.util.UrlPathInfo;
import org.apache.juneau.rest.util.UrlPathPattern;
import org.apache.juneau.rest.util.UrlPathPatternMatch;
import org.apache.juneau.rest.widget.Widget;
import org.apache.juneau.serializer.SerializerGroup;
import org.apache.juneau.svl.VarResolver;

@ConfigurableContext(nocache=true)
public class RestMethodContext
extends BeanContext
implements Comparable<RestMethodContext> {
    static final String PREFIX = "RestMethodContext";
    public static final String RESTMETHOD_attrs = "RestMethodContext.attrs.smo";
    public static final String RESTMETHOD_clientVersion = "RestMethodContext.clientVersion.s";
    public static final String RESTMETHOD_debug = "RestMethodContext.debug.s";
    public static final String RESTMETHOD_defaultFormData = "RestMethodContext.defaultFormData.omo";
    public static final String RESTMETHOD_defaultQuery = "RestMethodContext.defaultQuery.omo";
    public static final String RESTMETHOD_defaultRequestHeaders = "RestMethodContext.defaultRequestHeaders.smo";
    public static final String RESTMETHOD_httpMethod = "RestMethodContext.httpMethod.s";
    public static final String RESTMETHOD_callLoggerConfig = "RestMethodContext.callLoggerConfig.o";
    public static final String RESTMETHOD_matchers = "RestMethodContext.matchers.lo";
    public static final String RESTMETHOD_path = "RestMethodContext.path.s";
    public static final String RESTMETHOD_priority = "RestMethodContext.priority.i";
    private final String httpMethod;
    private final UrlPathPattern pathPattern;
    final RestMethodParam[] methodParams;
    private final RestGuard[] guards;
    private final RestMatcher[] optionalMatchers;
    private final RestMatcher[] requiredMatchers;
    private final RestConverter[] converters;
    private final RestMethodProperties properties;
    private final Integer priority;
    private final RestContext context;
    final Method method;
    final MethodInfo mi;
    final SerializerGroup serializers;
    final ParserGroup parsers;
    final EncoderGroup encoders;
    final HttpPartSerializer partSerializer;
    final HttpPartParser partParser;
    final JsonSchemaGenerator jsonSchemaGenerator;
    final Map<String, Object> defaultRequestHeaders;
    final Map<String, Object> defaultQuery;
    final Map<String, Object> defaultFormData;
    final ObjectMap defaultRequestAttributes;
    final String defaultCharset;
    final long maxInput;
    final Map<String, Widget> widgets;
    final List<MediaType> supportedAcceptTypes;
    final List<MediaType> supportedContentTypes;
    final RestCallLoggerConfig callLoggerConfig;
    final Map<Class<?>, ResponseBeanMeta> responseBeanMetas = new ConcurrentHashMap();
    final Map<Class<?>, ResponsePartMeta> headerPartMetas = new ConcurrentHashMap();
    final Map<Class<?>, ResponsePartMeta> bodyPartMetas = new ConcurrentHashMap();
    final ResponseBeanMeta responseMeta;
    final Enablement debug;

    RestMethodContext(RestMethodContextBuilder b) throws ServletException {
        super(b.getPropertyStore());
        Object clc;
        this.context = b.context;
        this.method = b.method;
        this.mi = MethodInfo.of((Method)this.method);
        this.mi.setAccessible();
        PropertyStore ps = this.getPropertyStore();
        RestResourceResolver rr = this.context.getResourceResolver();
        Object r = this.context.getResource();
        String _httpMethod = (String)this.getProperty(RESTMETHOD_httpMethod, String.class, null);
        if (_httpMethod == null) {
            _httpMethod = HttpUtils.detectHttpMethod((Method)this.method, (boolean)true, (String)"GET");
        }
        if ("METHOD".equals(_httpMethod)) {
            _httpMethod = "*";
        }
        this.httpMethod = _httpMethod.toUpperCase(Locale.ENGLISH);
        this.defaultCharset = (String)this.getProperty("RestContext.defaultCharset.s", String.class, "utf-8");
        this.maxInput = StringUtils.parseLongWithSuffix((String)((String)this.getProperty("RestContext.maxInput.s", String.class, "100M")));
        this.serializers = SerializerGroup.create().append(this.getArrayProperty("RestContext.serializers.lo", Object.class)).apply(ps).build();
        this.parsers = ParserGroup.create().append(this.getArrayProperty("RestContext.parsers.lo", Object.class)).apply(ps).build();
        HttpPartParser hpp = this.context.getPartParser();
        if (hpp instanceof Parser) {
            Parser pp = (Parser)hpp;
            hpp = (HttpPartParser)pp.builder().apply(ps).build();
        }
        this.partParser = hpp;
        this.partSerializer = this.context.getPartSerializer();
        this.responseMeta = ResponseBeanMeta.create((MethodInfo)this.mi, (PropertyStore)ps);
        this.pathPattern = new UrlPathPattern((String)this.getProperty(RESTMETHOD_path, String.class, HttpUtils.detectHttpPath((Method)this.method, (boolean)true)));
        this.methodParams = this.context.findParams(this.mi, false, this.pathPattern);
        this.converters = (RestConverter[])this.getInstanceArrayProperty("RestContext.converters.lo", RestConverter.class, new RestConverter[0], rr, new Object[]{r, this});
        ArrayList<Object> _guards = new ArrayList<Object>();
        _guards.addAll(Arrays.asList(this.getInstanceArrayProperty("RestContext.guards.lo", RestGuard.class, new RestGuard[0], rr, new Object[]{r, this})));
        Set rolesDeclared = this.getSetProperty("RestContext.rolesDeclared.ss", String.class, null);
        Set roleGuard = this.getSetProperty("RestContext.roleGuard.ss", String.class, Collections.emptySet());
        for (String rg : roleGuard) {
            try {
                _guards.add(new RoleBasedRestGuard(rolesDeclared, rg));
            }
            catch (java.text.ParseException e1) {
                throw new ServletException((Throwable)e1);
            }
        }
        this.guards = _guards.toArray(new RestGuard[_guards.size()]);
        LinkedList<RestMatcher> optionalMatchers = new LinkedList<RestMatcher>();
        LinkedList<RestMatcher> requiredMatchers = new LinkedList<RestMatcher>();
        for (RestMatcher matcher : (RestMatcher[])this.getInstanceArrayProperty(RESTMETHOD_matchers, RestMatcher.class, new RestMatcher[0], rr, new Object[]{r, this})) {
            if (matcher.mustMatch()) {
                requiredMatchers.add(matcher);
                continue;
            }
            optionalMatchers.add(matcher);
        }
        String clientVersion = (String)this.getProperty(RESTMETHOD_clientVersion, String.class, null);
        if (clientVersion != null) {
            requiredMatchers.add(new ClientVersionMatcher(this.context.getClientVersionHeader(), this.mi));
        }
        this.requiredMatchers = requiredMatchers.toArray(new RestMatcher[requiredMatchers.size()]);
        this.optionalMatchers = optionalMatchers.toArray(new RestMatcher[optionalMatchers.size()]);
        this.encoders = EncoderGroup.create().append(new Encoder[]{IdentityEncoder.INSTANCE}).append((Encoder[])this.getInstanceArrayProperty("RestContext.encoders.lo", Encoder.class, new Encoder[0], rr, new Object[]{r, this})).build();
        this.jsonSchemaGenerator = JsonSchemaGenerator.create().apply(ps).build();
        TreeMap<String, Object> _defaultRequestHeaders = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        _defaultRequestHeaders.putAll(this.getMapProperty(RESTMETHOD_defaultRequestHeaders, Object.class));
        ObjectMap _defaultRequestAttributes = new ObjectMap((Map)this.context.getDefaultRequestAttributes()).appendAll(this.getMapProperty(RESTMETHOD_attrs, Object.class));
        LinkedHashMap<String, Object> _defaultQuery = new LinkedHashMap<String, Object>(this.getMapProperty(RESTMETHOD_defaultQuery, Object.class));
        LinkedHashMap<String, Object> _defaultFormData = new LinkedHashMap<String, Object>(this.getMapProperty(RESTMETHOD_defaultFormData, Object.class));
        Type[] pt = this.method.getGenericParameterTypes();
        Annotation[][] pa = this.method.getParameterAnnotations();
        for (int i = 0; i < pt.length; ++i) {
            for (Annotation a : pa[i]) {
                FormData f;
                if (a instanceof Header) {
                    Header h = (Header)a;
                    if (h._default().length <= 0) continue;
                    try {
                        _defaultRequestHeaders.put(StringUtils.firstNonEmpty((String[])new String[]{h.name(), h.value()}), RestUtils.parseAnything(StringUtils.joinnl((Object[])h._default())));
                        continue;
                    }
                    catch (ParseException e) {
                        throw new ConfigException((Throwable)e, "Malformed @Header annotation", new Object[0]);
                    }
                }
                if (a instanceof Query) {
                    Query q = (Query)a;
                    if (q._default().length <= 0) continue;
                    try {
                        _defaultQuery.put(StringUtils.firstNonEmpty((String[])new String[]{q.name(), q.value()}), RestUtils.parseAnything(StringUtils.joinnl((Object[])q._default())));
                        continue;
                    }
                    catch (ParseException e) {
                        throw new ConfigException((Throwable)e, "Malformed @Query annotation", new Object[0]);
                    }
                }
                if (!(a instanceof FormData) || (f = (FormData)a)._default().length <= 0) continue;
                try {
                    _defaultFormData.put(StringUtils.firstNonEmpty((String[])new String[]{f.name(), f.value()}), RestUtils.parseAnything(StringUtils.joinnl((Object[])f._default())));
                }
                catch (ParseException e) {
                    throw new ConfigException((Throwable)e, "Malformed @FormData annotation", new Object[0]);
                }
            }
        }
        this.defaultRequestHeaders = Collections.unmodifiableMap(_defaultRequestHeaders);
        this.defaultRequestAttributes = _defaultRequestAttributes.unmodifiable();
        this.defaultQuery = Collections.unmodifiableMap(_defaultQuery);
        this.defaultFormData = Collections.unmodifiableMap(_defaultFormData);
        this.priority = this.getIntegerProperty(RESTMETHOD_priority, 0);
        HashMap<String, Object> _widgets = new HashMap<String, Object>();
        for (Widget w : (Widget[])this.getInstanceArrayProperty("RestContext.widgets.lo", Widget.class, new Widget[0])) {
            _widgets.put(w.getName(), w);
        }
        this.widgets = CollectionUtils.unmodifiableMap(_widgets);
        this.properties = b.properties;
        this.supportedAcceptTypes = this.getListProperty("RestContext.produces.ls", MediaType.class, this.serializers.getSupportedMediaTypes());
        this.supportedContentTypes = this.getListProperty("RestContext.consumes.ls", MediaType.class, this.parsers.getSupportedMediaTypes());
        this.debug = (Enablement)((Object)this.getInstanceProperty(RESTMETHOD_debug, Enablement.class, (Object)this.context.getDebug()));
        this.callLoggerConfig = this.debug == Enablement.TRUE ? RestCallLoggerConfig.DEFAULT_DEBUG : ((clc = this.getProperty(RESTMETHOD_callLoggerConfig)) instanceof RestCallLoggerConfig ? (RestCallLoggerConfig)clc : (clc instanceof ObjectMap ? RestCallLoggerConfig.create().parent(this.context.getCallLoggerConfig()).apply((ObjectMap)clc).build() : this.context.getCallLoggerConfig()));
    }

    ResponseBeanMeta getResponseBeanMeta(Object o) {
        if (o == null) {
            return null;
        }
        Class<?> c = o.getClass();
        ResponseBeanMeta rbm = this.responseBeanMetas.get(c);
        if (rbm == null) {
            rbm = ResponseBeanMeta.create(c, (PropertyStore)this.serializers.getPropertyStore());
            if (rbm == null) {
                rbm = ResponseBeanMeta.NULL;
            }
            this.responseBeanMetas.put(c, rbm);
        }
        if (rbm == ResponseBeanMeta.NULL) {
            return null;
        }
        return rbm;
    }

    ResponsePartMeta getResponseHeaderMeta(Object o) {
        if (o == null) {
            return null;
        }
        Class<?> c = o.getClass();
        ResponsePartMeta pm = this.headerPartMetas.get(c);
        if (pm == null) {
            ResponseHeader a = c.getAnnotation(ResponseHeader.class);
            if (a != null) {
                HttpPartSchema schema = HttpPartSchema.create((Annotation)a);
                HttpPartSerializer serializer = RestMethodContext.createPartSerializer(schema.getSerializer(), this.serializers.getPropertyStore(), this.partSerializer);
                pm = new ResponsePartMeta(HttpPartType.HEADER, schema, serializer);
            }
            if (pm == null) {
                pm = ResponsePartMeta.NULL;
            }
            this.headerPartMetas.put(c, pm);
        }
        if (pm == ResponsePartMeta.NULL) {
            return null;
        }
        return pm;
    }

    ResponsePartMeta getResponseBodyMeta(Object o) {
        if (o == null) {
            return null;
        }
        Class<?> c = o.getClass();
        ResponsePartMeta pm = this.bodyPartMetas.get(c);
        if (pm == null) {
            ResponseBody a = c.getAnnotation(ResponseBody.class);
            if (a != null) {
                HttpPartSchema schema = HttpPartSchema.create((Annotation)a);
                HttpPartSerializer serializer = RestMethodContext.createPartSerializer(schema.getSerializer(), this.serializers.getPropertyStore(), this.partSerializer);
                pm = new ResponsePartMeta(HttpPartType.BODY, schema, serializer);
            }
            if (pm == null) {
                pm = ResponsePartMeta.NULL;
            }
            this.bodyPartMetas.put(c, pm);
        }
        if (pm == ResponsePartMeta.NULL) {
            return null;
        }
        return pm;
    }

    boolean hasGuardsOrMatchers() {
        return this.guards.length != 0 || this.requiredMatchers.length != 0 || this.optionalMatchers.length != 0;
    }

    String getHttpMethod() {
        return this.httpMethod;
    }

    String getPathPattern() {
        return this.pathPattern.toString();
    }

    boolean isRequestAllowed(RestRequest req) {
        for (RestGuard guard : this.guards) {
            req.setJavaMethod(this.method);
            if (guard.isRequestAllowed(req)) continue;
            return false;
        }
        return true;
    }

    boolean matches(UrlPathInfo pathInfo) {
        return this.pathPattern.match(pathInfo) != null;
    }

    int invoke(RestCall call) throws Throwable {
        UrlPathPatternMatch pm = this.pathPattern.match(call.getUrlPathInfo());
        if (pm == null) {
            return 404;
        }
        RestRequest req = call.getRestRequest();
        RestResponse res = call.getRestResponse();
        RequestPath rp = req.getPathMatch();
        for (Map.Entry<String, String> entry : pm.getVars().entrySet()) {
            rp.put(entry.getKey(), entry.getValue());
        }
        if (pm.getRemainder() != null) {
            rp.remainder(pm.getRemainder());
        }
        RequestProperties requestProperties = new RequestProperties(req.getVarResolverSession(), this.properties);
        req.init(this, requestProperties);
        res.init(this, requestProperties);
        for (RestMatcher m : this.requiredMatchers) {
            if (m.matches(req)) continue;
            return 412;
        }
        if (this.optionalMatchers.length > 0) {
            int n;
            boolean bl = false;
            for (RestMatcher m : this.optionalMatchers) {
                n |= m.matches(req);
            }
            if (n == 0) {
                return 412;
            }
        }
        this.context.preCall(req, res);
        call.debug(req.isDebug()).loggerConfig(req.getCallLoggerConfig());
        Object[] objectArray = new Object[this.methodParams.length];
        for (int i = 0; i < this.methodParams.length; ++i) {
            try {
                objectArray[i] = this.methodParams[i].resolve(req, res);
                continue;
            }
            catch (Exception e) {
                throw HttpRuntimeException.toHttpException(e, BadRequest.class, "Invalid data conversion.  Could not convert {0} ''{1}'' to type ''{2}'' on method ''{3}.{4}''.", this.methodParams[i].getParamType().name(), this.methodParams[i].getName(), this.methodParams[i].getType(), this.mi.getDeclaringClass().getFullName(), this.mi.getSimpleName());
            }
        }
        try {
            for (RestGuard guard : this.guards) {
                if (guard.guard(req, res)) continue;
                return 200;
            }
            try {
                Object output = this.method.invoke(this.context.getResource(), objectArray);
                if (res.getStatus() == 0) {
                    res.setStatus(200);
                }
                if (!(this.method.getReturnType().equals(Void.TYPE) || output == null && res.getOutputStreamCalled())) {
                    res.setOutput(output);
                }
            }
            catch (InvocationTargetException e) {
                Throwable e2 = e.getTargetException();
                res.setStatus(500);
                ResponsePartMeta rpm = this.getResponseBodyMeta(e2);
                ResponseBeanMeta rbm = this.getResponseBeanMeta(e2);
                if (rpm != null || rbm != null) {
                    res.setOutput(e2);
                    res.setResponseMeta(rbm);
                }
                throw e;
            }
            this.context.postCall(req, res);
            if (res.hasOutput()) {
                for (RestConverter converter : this.converters) {
                    res.setOutput(converter.convert(req, res.getOutput()));
                }
            }
        }
        catch (IllegalArgumentException e) {
            throw new BadRequest((Throwable)e, "Invalid argument type passed to the following method: ''{0}''.\n\tArgument types: {1}", new Object[]{this.mi.toString(), this.mi.getFullName()});
        }
        catch (InvocationTargetException e) {
            Throwable e2 = e.getTargetException();
            if (e2 instanceof ParseException || e2 instanceof InvalidDataConversionException) {
                throw new BadRequest(e2);
            }
            throw HttpRuntimeException.toHttpException(e, InternalServerError.class);
        }
        return 200;
    }

    @Override
    public int compareTo(RestMethodContext o) {
        int c = this.priority.compareTo(o.priority);
        if (c != 0) {
            return c;
        }
        c = this.pathPattern.compareTo(o.pathPattern);
        if (c != 0) {
            return c;
        }
        c = ObjectUtils.compare((int)o.requiredMatchers.length, (int)this.requiredMatchers.length);
        if (c != 0) {
            return c;
        }
        c = ObjectUtils.compare((int)o.optionalMatchers.length, (int)this.optionalMatchers.length);
        if (c != 0) {
            return c;
        }
        c = ObjectUtils.compare((int)o.guards.length, (int)this.guards.length);
        if (c != 0) {
            return c;
        }
        return 0;
    }

    public SerializerGroup getSerializers() {
        return this.serializers;
    }

    public ParserGroup getParsers() {
        return this.parsers;
    }

    public HttpPartSerializer getPartSerializer() {
        return this.partSerializer;
    }

    public HttpPartParser getPartParser() {
        return this.partParser;
    }

    public JsonSchemaGenerator getJsonSchemaGenerator() {
        return this.jsonSchemaGenerator;
    }

    protected Enablement getDebug() {
        return this.debug;
    }

    protected RestCallLoggerConfig getCallLoggerConfig() {
        return this.callLoggerConfig;
    }

    public boolean equals(Object o) {
        if (!(o instanceof RestMethodContext)) {
            return false;
        }
        return this.compareTo((RestMethodContext)o) == 0;
    }

    public int hashCode() {
        return this.method.hashCode();
    }

    static String[] resolveVars(VarResolver vr, String[] in) {
        String[] out = new String[in.length];
        for (int i = 0; i < in.length; ++i) {
            out[i] = vr.resolve(in[i]);
        }
        return out;
    }

    static HttpPartSerializer createPartSerializer(Class<? extends HttpPartSerializer> c, PropertyStore ps, HttpPartSerializer _default) {
        HttpPartSerializer hps = (HttpPartSerializer)ClassUtils.castOrCreate(HttpPartSerializer.class, c, (boolean)true, (Object[])new Object[]{ps});
        return hps == null ? _default : hps;
    }

    public ObjectMap toMap() {
        return super.toMap().append(PREFIX, (Object)new DefaultFilteringObjectMap().append("defaultFormData", this.defaultFormData).append("defaultQuery", this.defaultQuery).append("defaultRequestHeaders", this.defaultRequestHeaders).append("httpMethod", (Object)this.httpMethod).append("priority", (Object)this.priority));
    }
}

