/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.juneau.http.StreamResource;
import org.apache.juneau.http.annotation.Response;
import org.apache.juneau.http.exception.HttpException;
import org.apache.juneau.http.exception.MethodNotAllowed;
import org.apache.juneau.http.exception.NotFound;
import org.apache.juneau.http.exception.NotImplemented;
import org.apache.juneau.http.exception.PreconditionFailed;
import org.apache.juneau.http.exception.Unauthorized;
import org.apache.juneau.internal.IOUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.reflect.ClassInfo;
import org.apache.juneau.rest.Enablement;
import org.apache.juneau.rest.HttpRuntimeException;
import org.apache.juneau.rest.OverrideableHttpServletRequest;
import org.apache.juneau.rest.RequestPath;
import org.apache.juneau.rest.ResponseHandler;
import org.apache.juneau.rest.RestCall;
import org.apache.juneau.rest.RestCallHandler;
import org.apache.juneau.rest.RestCallRouter;
import org.apache.juneau.rest.RestContext;
import org.apache.juneau.rest.RestException;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.rest.RestResponse;
import org.apache.juneau.rest.util.RestUtils;
import org.apache.juneau.rest.util.UrlPathInfo;
import org.apache.juneau.rest.util.UrlPathPattern;
import org.apache.juneau.rest.util.UrlPathPatternMatch;

public class BasicRestCallHandler
implements RestCallHandler {
    private final RestContext context;
    private final Map<String, RestCallRouter> restCallRouters;

    public BasicRestCallHandler(RestContext context) {
        this.context = context;
        this.restCallRouters = context.getCallRouters();
    }

    @Override
    public RestCall createCall(HttpServletRequest req, HttpServletResponse res) {
        return new RestCall(req, res).logger(this.context.getCallLogger()).loggerConfig(this.context.getCallLoggerConfig());
    }

    @Override
    public RestRequest createRequest(RestCall call) throws ServletException {
        return new RestRequest(this.context, call.getRequest());
    }

    @Override
    public RestResponse createResponse(RestCall call) throws ServletException {
        return new RestResponse(this.context, call.getRestRequest(), call.getResponse());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void service(HttpServletRequest r1, HttpServletResponse r2) throws ServletException, IOException {
        RestCall call = this.createCall(r1, r2);
        try {
            this.context.checkForInitException();
            if (this.context.pathPattern.hasVars() && this.context.getParentContext() == null) {
                String sp = call.getServletPath();
                String pi = call.getPathInfoUndecoded();
                UrlPathInfo upi2 = new UrlPathInfo(pi == null ? sp : sp + (String)pi);
                UrlPathPatternMatch uppm = this.context.pathPattern.match(upi2);
                if (uppm != null && !uppm.hasEmptyVars()) {
                    RequestPath.addPathVars(call.getRequest(), uppm.getVars());
                    call.request((HttpServletRequest)new OverrideableHttpServletRequest(call.getRequest()).pathInfo(StringUtils.nullIfEmpty((String)StringUtils.urlDecode((String)uppm.getSuffix()))).servletPath(uppm.getPrefix()));
                } else {
                    call.debug(this.isDebug(call)).status(404).finish();
                    return;
                }
            }
            String pi = call.getPathInfoUndecoded();
            if (this.context.hasChildResources() && pi != null && !pi.equals("/")) {
                for (RestContext rc : this.context.getChildResources().values()) {
                    UrlPathPattern upp = rc.pathPattern;
                    UrlPathPatternMatch uppm = upp.match(call.getUrlPathInfo());
                    if (uppm == null) continue;
                    if (!uppm.hasEmptyVars()) {
                        RequestPath.addPathVars(call.getRequest(), uppm.getVars());
                        OverrideableHttpServletRequest childRequest = new OverrideableHttpServletRequest(call.getRequest()).pathInfo(StringUtils.nullIfEmpty((String)StringUtils.urlDecode((String)uppm.getSuffix()))).servletPath(call.getServletPath() + uppm.getPrefix());
                        rc.getCallHandler().service((HttpServletRequest)childRequest, call.getResponse());
                    } else {
                        call.debug(this.isDebug(call)).status(404).finish();
                    }
                    return;
                }
            }
            call.debug(this.isDebug(call));
            this.context.startCall(call);
            call.restRequest(this.createRequest(call));
            call.restResponse(this.createResponse(call));
            this.context.setRequest(call.getRestRequest());
            this.context.setResponse(call.getRestResponse());
            StreamResource r = null;
            if (call.getPathInfoUndecoded() != null) {
                String p = call.getPathInfoUndecoded().substring(1);
                if (this.context.isStaticFile(p)) {
                    RestContext.StaticFile sf = this.context.resolveStaticFile(p);
                    r = sf.resource;
                    call.responseMeta(sf.meta);
                } else if (p.equals("favicon.ico")) {
                    call.output(null);
                }
            }
            if (r != null) {
                call.status(200);
                call.output(r);
            } else {
                int rc = 0;
                String m = call.getMethod();
                if (this.restCallRouters.containsKey(m)) {
                    rc = this.restCallRouters.get(m).invoke(call);
                } else if (this.restCallRouters.containsKey("*")) {
                    rc = this.restCallRouters.get("*").invoke(call);
                }
                if (rc == 0) {
                    for (RestCallRouter rcc : this.restCallRouters.values()) {
                        if (!rcc.matches(call)) continue;
                        rc = 405;
                    }
                }
                if (rc == 0) {
                    rc = 404;
                }
                if (rc != 200) {
                    this.handleNotFound(call.status(rc));
                }
                if (call.getStatus() == 0) {
                    call.status(rc);
                }
            }
            if (call.hasOutput()) {
                this.handleResponse(call);
            }
        }
        catch (Throwable e) {
            this.handleError(call, this.convertThrowable(e));
        }
        finally {
            this.context.clearState();
        }
        call.finish();
        this.context.finishCall(call);
    }

    private boolean isDebug(RestCall call) {
        Enablement e = this.context.getDebug();
        if (e == Enablement.TRUE) {
            return true;
        }
        if (e == Enablement.FALSE) {
            return false;
        }
        return "true".equalsIgnoreCase(call.getRequest().getHeader("X-Debug"));
    }

    @Override
    public void handleResponse(RestCall call) throws IOException, HttpException, NotImplemented {
        RestRequest req = call.getRestRequest();
        RestResponse res = call.getRestResponse();
        for (ResponseHandler h : this.context.getResponseHandlers()) {
            if (!h.handle(req, res)) continue;
            return;
        }
        Object output = res.getOutput();
        throw new NotImplemented("No response handlers found to process output of type '" + (output == null ? null : output.getClass().getName()) + "'");
    }

    @Override
    public Throwable convertThrowable(Throwable t) {
        ClassInfo ci = ClassInfo.ofc((Object)t);
        if (ci.is(HttpRuntimeException.class)) {
            t = ((HttpRuntimeException)t).getInner();
        }
        if (ci.isChildOf(RestException.class) || ci.hasAnnotation(Response.class)) {
            return t;
        }
        String n = t.getClass().getName();
        if (n.contains("AccessDenied")) {
            return new Unauthorized(t);
        }
        if (n.contains("Empty") || n.contains("NotFound")) {
            return new NotFound(t);
        }
        return t;
    }

    @Override
    public void handleNotFound(RestCall call) throws Exception {
        String onPath;
        String pathInfo = call.getPathInfo();
        String methodUC = call.getMethod();
        int rc = call.getStatus();
        String string = onPath = pathInfo == null ? " on no pathInfo" : String.format(" on path '%s'", pathInfo);
        if (rc == 404) {
            throw new NotFound("Method ''{0}'' not found on resource with matching pattern{1}.", new Object[]{methodUC, onPath});
        }
        if (rc == 412) {
            throw new PreconditionFailed("Method ''{0}'' not found on resource{1} with matching matcher.", new Object[]{methodUC, onPath});
        }
        if (rc == 405) {
            throw new MethodNotAllowed("Method ''{0}'' not found on resource.", new Object[]{methodUC});
        }
        throw new ServletException("Invalid method response: " + rc);
    }

    @Override
    public synchronized void handleError(RestCall call, Throwable e) throws IOException {
        call.exception(e);
        int occurrence = this.context == null ? 0 : this.context.getStackTraceOccurrence(e);
        int code = 500;
        ClassInfo ci = ClassInfo.ofc((Object)e);
        Response r = (Response)ci.getAnnotation(Response.class);
        if (r != null && r.code().length > 0) {
            code = r.code()[0];
        }
        RestException e2 = (e instanceof RestException ? (RestException)e : new RestException(e, code)).setOccurrence(occurrence);
        HttpServletRequest req = call.getRequest();
        HttpServletResponse res = call.getResponse();
        Throwable t = null;
        if (e instanceof HttpRuntimeException) {
            t = ((HttpRuntimeException)e).getInner();
        }
        if (t == null) {
            t = e2.getRootCause();
        }
        if (t != null) {
            res.setHeader("Exception-Name", StringUtils.stripInvalidHttpHeaderChars((String)t.getClass().getName()));
            res.setHeader("Exception-Message", StringUtils.stripInvalidHttpHeaderChars((String)t.getMessage()));
        }
        try {
            res.setContentType("text/plain");
            res.setHeader("Content-Encoding", "identity");
            res.setStatus(e2.getStatus());
            PrintWriter w = null;
            try {
                w = res.getWriter();
            }
            catch (IllegalStateException x) {
                w = new PrintWriter(new OutputStreamWriter((OutputStream)res.getOutputStream(), IOUtils.UTF8));
            }
            try (PrintWriter w2 = w;){
                String httpMessage = RestUtils.getHttpResponseText(e2.getStatus());
                if (httpMessage != null) {
                    w2.append("HTTP ").append(String.valueOf(e2.getStatus())).append(": ").append(httpMessage).append("\n\n");
                }
                if (this.context != null && this.context.isRenderResponseStackTraces()) {
                    e.printStackTrace(w2);
                } else {
                    w2.append(e2.getFullStackMessage(true));
                }
            }
        }
        catch (Exception e1) {
            req.setAttribute("Exception", (Object)e1);
        }
    }

    @Override
    public Map<String, Object> getSessionObjects(RestRequest req, RestResponse res) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("req", (Object)req);
        m.put("res", (Object)res);
        return m;
    }
}

