/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.jena;

import java.util.Map;
import java.util.TreeMap;
import org.apache.juneau.DefaultFilteringObjectMap;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.annotation.ConfigurableContext;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.jena.RdfCollectionFormat;
import org.apache.juneau.jena.RdfCommon;
import org.apache.juneau.jena.RdfSerializerBuilder;
import org.apache.juneau.jena.RdfSerializerSession;
import org.apache.juneau.serializer.SerializerSessionArgs;
import org.apache.juneau.serializer.WriterSerializer;
import org.apache.juneau.xml.Namespace;

@ConfigurableContext(prefixes={"RdfCommon", "RdfSerializer"})
public class RdfSerializer
extends WriterSerializer
implements RdfCommon {
    private static final Namespace DEFAULT_JUNEAU_NS = Namespace.create((String)"j", (String)"http://www.apache.org/juneau/");
    private static final Namespace DEFAULT_JUNEAUBP_NS = Namespace.create((String)"jp", (String)"http://www.apache.org/juneaubp/");
    static final String PREFIX = "RdfSerializer";
    public static final String RDF_addBeanTypes = "RdfSerializer.addBeanTypes.b";
    public static final String RDF_addLiteralTypes = "RdfSerializer.addLiteralTypes.b";
    public static final String RDF_addRootProperty = "RdfSerializer.addRootProperty.b";
    public static final String RDF_autoDetectNamespaces = "RdfSerializer.autoDetectNamespaces.b";
    public static final String RDF_namespaces = "RdfSerializer.namespaces.ls";
    public static final String RDF_useXmlNamespaces = "RdfSerializer.useXmlNamespaces.b";
    private final boolean addLiteralTypes = this.getBooleanProperty("RdfSerializer.addLiteralTypes.b", false);
    private final boolean addRootProperty = this.getBooleanProperty("RdfSerializer.addRootProperty.b", false);
    private final boolean useXmlNamespaces = this.getBooleanProperty("RdfSerializer.useXmlNamespaces.b", true);
    private final boolean looseCollections = this.getBooleanProperty("RdfCommon.looseCollections.b", false);
    private final boolean autoDetectNamespaces = this.getBooleanProperty("RdfSerializer.autoDetectNamespaces.b", true);
    private final boolean addBeanTypes;
    private final String rdfLanguage = this.getStringProperty("RdfCommon.language.s", "RDF/XML-ABBREV");
    private final Namespace juneauNs = (Namespace)this.getProperty("RdfCommon.juneauNs.s", Namespace.class, DEFAULT_JUNEAU_NS);
    private final Namespace juneauBpNs = (Namespace)this.getProperty("RdfCommon.juneauBpNs.s", Namespace.class, DEFAULT_JUNEAUBP_NS);
    private final RdfCollectionFormat collectionFormat = (RdfCollectionFormat)((Object)this.getProperty("RdfCommon.collectionFormat.s", RdfCollectionFormat.class, (Object)RdfCollectionFormat.DEFAULT));
    final Map<String, Object> jenaProperties;
    final Namespace[] namespaces = (Namespace[])this.getProperty("RdfSerializer.namespaces.ls", Namespace[].class, new Namespace[0]);

    public RdfSerializer(PropertyStore ps, String produces, String accept) {
        super(ps, produces, accept);
        this.addBeanTypes = this.getBooleanProperty(RDF_addBeanTypes, this.getBooleanProperty("Serializer.addBeanTypes.b", false));
        TreeMap<String, Object> m = new TreeMap<String, Object>();
        for (String k : this.getPropertyKeys("RdfCommon")) {
            if (!k.startsWith("jena.")) continue;
            m.put(k.substring(5), this.getProperty("RdfCommon." + k));
        }
        this.jenaProperties = CollectionUtils.unmodifiableMap(m);
    }

    public RdfSerializer(PropertyStore ps) {
        this(ps, "text/xml+rdf", null);
    }

    public RdfSerializerBuilder builder() {
        return new RdfSerializerBuilder(this.getPropertyStore());
    }

    public static RdfSerializerBuilder create() {
        return new RdfSerializerBuilder();
    }

    public RdfSerializerSession createSession() {
        return this.createSession(this.createDefaultSessionArgs());
    }

    public RdfSerializerSession createSession(SerializerSessionArgs args) {
        return new RdfSerializerSession(this, args);
    }

    protected final RdfCollectionFormat getCollectionFormat() {
        return this.collectionFormat;
    }

    protected final Namespace getJuneauBpNs() {
        return this.juneauBpNs;
    }

    protected final Namespace getJuneauNs() {
        return this.juneauNs;
    }

    protected final String getLanguage() {
        return this.rdfLanguage;
    }

    protected final boolean isLooseCollections() {
        return this.looseCollections;
    }

    protected final Map<String, Object> getJenaProperties() {
        return this.jenaProperties;
    }

    protected final boolean isAddBeanTypes() {
        return this.addBeanTypes;
    }

    protected final boolean isAddLiteralTypes() {
        return this.addLiteralTypes;
    }

    protected final boolean isAddRootProp() {
        return this.addRootProperty;
    }

    protected final boolean isAutoDetectNamespaces() {
        return this.autoDetectNamespaces;
    }

    public Namespace[] getNamespaces() {
        return this.namespaces;
    }

    protected final boolean isUseXmlNamespaces() {
        return this.useXmlNamespaces;
    }

    public ObjectMap toMap() {
        return super.toMap().append(PREFIX, (Object)new DefaultFilteringObjectMap().append("addLiteralTypes", (Object)this.addLiteralTypes).append("addRootProperty", (Object)this.addRootProperty).append("useXmlNamespaces", (Object)this.useXmlNamespaces).append("looseCollections", (Object)this.looseCollections).append("autoDetectNamespaces", (Object)this.autoDetectNamespaces).append("rdfLanguage", (Object)this.rdfLanguage).append("juneauNs", (Object)this.juneauNs).append("juneauBpNs", (Object)this.juneauBpNs).append("collectionFormat", (Object)this.collectionFormat).append("namespaces", (Object)this.namespaces).append("addBeanTypes", (Object)this.addBeanTypes));
    }
}

