/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.utils;

import java.util.concurrent.atomic.AtomicInteger;

public class StackTraceInfo {
    AtomicInteger count;
    long timeout;
    String hash;

    StackTraceInfo(long timeout, int hash) {
        this.count = new AtomicInteger(1);
        this.timeout = System.currentTimeMillis() + timeout;
        this.hash = Integer.toHexString(hash);
    }

    private StackTraceInfo(int count, long timeout, String hash) {
        this.count = new AtomicInteger(count);
        this.timeout = timeout;
        this.hash = hash;
    }

    public StackTraceInfo clone() {
        return new StackTraceInfo(this.count.intValue(), this.timeout, this.hash);
    }

    public int getCount() {
        return this.count.intValue();
    }

    public String getHash() {
        return this.hash;
    }

    StackTraceInfo incrementAndClone() {
        return new StackTraceInfo(this.count.incrementAndGet(), this.timeout, this.hash);
    }
}

