/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.utils;

import java.util.concurrent.ConcurrentHashMap;
import org.apache.juneau.utils.StackTraceInfo;

public class StackTraceDatabase {
    private final ConcurrentHashMap<Integer, StackTraceInfo> db = new ConcurrentHashMap();
    private final String stopClass;

    public StackTraceDatabase() {
        this.stopClass = null;
    }

    public StackTraceDatabase(Class<?> stopClass) {
        this.stopClass = stopClass == null ? "" : stopClass.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StackTraceInfo getStackTraceInfo(Throwable e, int timeout) {
        int hash = this.hash(e);
        StackTraceInfo stc = this.db.get(hash);
        if (stc != null && stc.timeout > System.currentTimeMillis()) {
            stc.incrementAndClone();
            return stc.clone();
        }
        ConcurrentHashMap<Integer, StackTraceInfo> concurrentHashMap = this.db;
        synchronized (concurrentHashMap) {
            stc = new StackTraceInfo(timeout, hash);
            this.db.put(hash, stc);
            return stc.clone();
        }
    }

    private int hash(Throwable t) {
        int i = 0;
        while (t != null) {
            for (StackTraceElement e : t.getStackTrace()) {
                if (e.getClassName().equals(this.stopClass)) break;
                if (e.getClassName().indexOf(36) != -1) continue;
                i ^= e.hashCode();
            }
            t = t.getCause();
        }
        return i;
    }

    public void reset() {
        this.db.clear();
    }
}

