/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.uon;

import org.apache.juneau.DefaultFilteringObjectMap;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.annotation.ConfigurableContext;
import org.apache.juneau.httppart.HttpPartSchema;
import org.apache.juneau.httppart.HttpPartSerializer;
import org.apache.juneau.httppart.HttpPartType;
import org.apache.juneau.httppart.SchemaValidationException;
import org.apache.juneau.serializer.SerializeException;
import org.apache.juneau.serializer.SerializerSessionArgs;
import org.apache.juneau.serializer.WriterSerializer;
import org.apache.juneau.uon.ParamFormat;
import org.apache.juneau.uon.UonSerializerBuilder;
import org.apache.juneau.uon.UonSerializerSession;

@ConfigurableContext
public class UonSerializer
extends WriterSerializer
implements HttpPartSerializer {
    static final String PREFIX = "UonSerializer";
    public static final String UON_addBeanTypes = "UonSerializer.addBeanTypes.b";
    public static final String UON_encoding = "UonSerializer.encoding.b";
    public static final String UON_paramFormat = "UonSerializer.paramFormat.s";
    public static final UonSerializer DEFAULT = new UonSerializer(PropertyStore.DEFAULT);
    public static final UonSerializer DEFAULT_READABLE = new Readable(PropertyStore.DEFAULT);
    public static final UonSerializer DEFAULT_ENCODING = new Encoding(PropertyStore.DEFAULT);
    private final boolean encoding = this.getBooleanProperty("UonSerializer.encoding.b", false);
    private final boolean addBeanTypes = this.getBooleanProperty("UonSerializer.addBeanTypes.b", this.getBooleanProperty("Serializer.addBeanTypes.b", false));
    private final ParamFormat paramFormat = this.getProperty("UonSerializer.paramFormat.s", ParamFormat.class, ParamFormat.UON);

    public UonSerializer(PropertyStore ps) {
        this(ps, "text/uon", null);
    }

    public UonSerializer(PropertyStore ps, String produces, String accept) {
        super(ps, produces, accept);
    }

    @Override
    public UonSerializerBuilder builder() {
        return new UonSerializerBuilder(this.getPropertyStore());
    }

    public static UonSerializerBuilder create() {
        return new UonSerializerBuilder();
    }

    @Override
    public UonSerializerSession createSession() {
        return this.createSession(this.createDefaultSessionArgs());
    }

    @Override
    public UonSerializerSession createSession(SerializerSessionArgs args) {
        return new UonSerializerSession(this, null, args);
    }

    @Override
    public UonSerializerSession createPartSession(SerializerSessionArgs args) {
        return new UonSerializerSession(this, null, args);
    }

    @Override
    public UonSerializerSession createPartSession() {
        return this.createPartSession(null);
    }

    @Override
    public String serialize(HttpPartType partType, HttpPartSchema schema, Object value) throws SchemaValidationException, SerializeException {
        return this.createPartSession().serialize(partType, schema, value);
    }

    @Override
    public String serialize(HttpPartSchema schema, Object value) throws SchemaValidationException, SerializeException {
        return this.createPartSession().serialize(null, schema, value);
    }

    @Override
    protected final boolean isAddBeanTypes() {
        return this.addBeanTypes;
    }

    protected final boolean isEncoding() {
        return this.encoding;
    }

    protected final ParamFormat getParamFormat() {
        return this.paramFormat;
    }

    @Override
    public ObjectMap toMap() {
        return super.toMap().append(PREFIX, new DefaultFilteringObjectMap().append("encoding", this.encoding).append("addBeanTypes", this.addBeanTypes).append("paramFormat", (Object)this.paramFormat));
    }

    public static class Encoding
    extends UonSerializer {
        public Encoding(PropertyStore ps) {
            super(ps.builder().set(UonSerializer.UON_encoding, true).build());
        }
    }

    public static class Readable
    extends UonSerializer {
        public Readable(PropertyStore ps) {
            super(ps.builder().set("WriterSerializer.useWhitespace.b", true).build());
        }
    }
}

