/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest;

import java.util.Enumeration;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.juneau.internal.IOUtils;
import org.apache.juneau.internal.ObjectUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.rest.RestCallLogger;
import org.apache.juneau.rest.RestCallLoggerConfig;
import org.apache.juneau.rest.RestCallLoggerRule;
import org.apache.juneau.rest.RestCallLoggingDetail;
import org.apache.juneau.rest.RestContext;
import org.apache.juneau.rest.RestMethodContext;
import org.apache.juneau.rest.util.CachingHttpServletRequest;
import org.apache.juneau.rest.util.CachingHttpServletResponse;
import org.apache.juneau.utils.StackTraceDatabase;
import org.apache.juneau.utils.StackTraceInfo;

public class BasicRestCallLogger
implements RestCallLogger {
    private final StackTraceDatabase stackTraceDb = new StackTraceDatabase(RestMethodContext.class);
    private final Logger logger;
    private final RestContext context;

    public BasicRestCallLogger(RestContext context) {
        this.context = context;
        this.logger = Logger.getLogger(this.getLoggerName());
    }

    public BasicRestCallLogger(RestContext context, Logger logger) {
        this.context = context;
        this.logger = logger;
    }

    protected String getLoggerName() {
        return this.context == null ? this.getClass().getName() : this.context.getResource().getClass().getName();
    }

    protected Logger getLogger() {
        return this.logger;
    }

    public BasicRestCallLogger resetStackTraces() {
        this.stackTraceDb.reset();
        return this;
    }

    @Override
    public void log(RestCallLoggerConfig config, HttpServletRequest req, HttpServletResponse res) {
        if (config.isDisabled(req)) {
            return;
        }
        RestCallLoggerRule rule = config.getRule(req, res);
        if (rule == null) {
            return;
        }
        Level level = rule.getLevel();
        if (level == null) {
            level = config.getLevel();
        }
        if (level == Level.OFF) {
            return;
        }
        Throwable e = ObjectUtils.castOrNull(req.getAttribute("Exception"), Throwable.class);
        Long execTime = ObjectUtils.castOrNull(req.getAttribute("ExecTime"), Long.class);
        RestCallLoggingDetail reqd = rule.getReqDetail();
        RestCallLoggingDetail resd = rule.getResDetail();
        String method = req.getMethod();
        int status = res.getStatus();
        String uri = req.getRequestURI();
        byte[] reqBody = this.getRequestBody(req);
        byte[] resBody = this.getResponseBody(req, res);
        StringBuilder sb = new StringBuilder();
        if (reqd != RestCallLoggingDetail.SHORT || resd != RestCallLoggingDetail.SHORT) {
            sb.append("\n=== HTTP Request (incoming) ===================================================\n");
        }
        StackTraceInfo sti = this.getStackTraceInfo(config, e);
        sb.append('[').append(status);
        if (sti != null) {
            int count = sti.getCount();
            sb.append(',').append(sti.getHash()).append('.').append(count);
            if (count > 1) {
                e = null;
            }
        }
        sb.append("] ");
        sb.append("HTTP ").append(method).append(' ').append(uri);
        if (reqd != RestCallLoggingDetail.SHORT || resd != RestCallLoggingDetail.SHORT) {
            Enumeration hh;
            String qs;
            if (reqd.isOneOf(RestCallLoggingDetail.MEDIUM, RestCallLoggingDetail.LONG) && (qs = req.getQueryString()) != null) {
                sb.append('?').append(qs);
            }
            if (reqBody != null && reqd.isOneOf(RestCallLoggingDetail.MEDIUM, RestCallLoggingDetail.LONG)) {
                sb.append("\n\tRequest length: ").append(reqBody.length).append(" bytes");
            }
            if (resd.isOneOf(RestCallLoggingDetail.MEDIUM, RestCallLoggingDetail.LONG)) {
                sb.append("\n\tResponse code: ").append(status);
            }
            if (resBody != null && resd.isOneOf(RestCallLoggingDetail.MEDIUM, RestCallLoggingDetail.LONG)) {
                sb.append("\n\tResponse length: ").append(resBody.length).append(" bytes");
            }
            if (execTime != null && resd.isOneOf(RestCallLoggingDetail.MEDIUM, RestCallLoggingDetail.LONG)) {
                sb.append("\n\tExec time: ").append(execTime).append("ms");
            }
            if (reqd.isOneOf(RestCallLoggingDetail.MEDIUM, RestCallLoggingDetail.LONG) && (hh = req.getHeaderNames()).hasMoreElements()) {
                sb.append("\n---Request Headers---");
                while (hh.hasMoreElements()) {
                    String h = (String)hh.nextElement();
                    sb.append("\n\t").append(h).append(": ").append(req.getHeader(h));
                }
            }
            if (this.context != null && reqd.isOneOf(RestCallLoggingDetail.MEDIUM, RestCallLoggingDetail.LONG) && !(hh = this.context.getDefaultRequestHeaders()).isEmpty()) {
                sb.append("\n---Default Servlet Headers---");
                for (Map.Entry entry : hh.entrySet()) {
                    sb.append("\n\t").append((String)entry.getKey()).append(": ").append(entry.getValue());
                }
            }
            if (resd.isOneOf(RestCallLoggingDetail.MEDIUM, RestCallLoggingDetail.LONG) && (hh = res.getHeaderNames()).size() > 0) {
                sb.append("\n---Response Headers---");
                for (String string : hh) {
                    sb.append("\n\t").append(string).append(": ").append(res.getHeader(string));
                }
            }
            if (reqBody != null && reqBody.length > 0 && reqd == RestCallLoggingDetail.LONG) {
                try {
                    sb.append("\n---Request Body UTF-8---");
                    sb.append("\n").append(new String(reqBody, IOUtils.UTF8));
                    sb.append("\n---Request Body Hex---");
                    sb.append("\n").append(StringUtils.toSpacedHex(reqBody));
                }
                catch (Exception e1) {
                    sb.append("\n").append(e1.getLocalizedMessage());
                }
            }
            if (resBody != null && resBody.length > 0 && resd == RestCallLoggingDetail.LONG) {
                try {
                    sb.append("\n---Response Body UTF-8---");
                    sb.append("\n").append(new String(resBody, IOUtils.UTF8));
                    sb.append("\n---Response Body Hex---");
                    sb.append("\n").append(StringUtils.toSpacedHex(resBody));
                }
                catch (Exception e1) {
                    sb.append(e1.getLocalizedMessage());
                }
            }
            sb.append("\n=== END ===================================================================");
        }
        this.getLogger().log(level, sb.toString(), e);
    }

    private byte[] getRequestBody(HttpServletRequest req) {
        if (req instanceof CachingHttpServletRequest) {
            return ((CachingHttpServletRequest)req).getBody();
        }
        return ObjectUtils.castOrNull(req.getAttribute("RequestBody"), byte[].class);
    }

    private byte[] getResponseBody(HttpServletRequest req, HttpServletResponse res) {
        if (res instanceof CachingHttpServletResponse) {
            return ((CachingHttpServletResponse)res).getBody();
        }
        return ObjectUtils.castOrNull(req.getAttribute("ResponseBody"), byte[].class);
    }

    private StackTraceInfo getStackTraceInfo(RestCallLoggerConfig config, Throwable e) {
        if (e == null || !config.isUseStackTraceHashing()) {
            return null;
        }
        return this.stackTraceDb.getStackTraceInfo(e, config.getStackTraceHashingTimeout());
    }
}

