/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.json;

import org.apache.juneau.DefaultFilteringObjectMap;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.annotation.ConfigurableContext;
import org.apache.juneau.json.JsonParserBuilder;
import org.apache.juneau.json.JsonParserSession;
import org.apache.juneau.parser.ParserSessionArgs;
import org.apache.juneau.parser.ReaderParser;

@ConfigurableContext
public class JsonParser
extends ReaderParser {
    static final String PREFIX = "JsonParser";
    public static final String JSON_validateEnd = "JsonParser.validateEnd.b";
    public static final JsonParser DEFAULT = new Simple(PropertyStore.DEFAULT);
    public static final JsonParser DEFAULT_STRICT = new Strict(PropertyStore.DEFAULT);
    private final boolean validateEnd = this.getBooleanProperty("JsonParser.validateEnd.b", false);

    public JsonParser(PropertyStore ps) {
        this(ps, "application/json", "text/json");
    }

    public JsonParser(PropertyStore ps, String ... consumes) {
        super(ps, consumes);
    }

    @Override
    public JsonParserBuilder builder() {
        return new JsonParserBuilder(this.getPropertyStore());
    }

    public static JsonParserBuilder create() {
        return new JsonParserBuilder();
    }

    @Override
    public JsonParserSession createSession() {
        return this.createSession(this.createDefaultSessionArgs());
    }

    @Override
    public JsonParserSession createSession(ParserSessionArgs args) {
        return new JsonParserSession(this, args);
    }

    protected final boolean isValidateEnd() {
        return this.validateEnd;
    }

    @Override
    public ObjectMap toMap() {
        return super.toMap().append(PREFIX, new DefaultFilteringObjectMap());
    }

    public static class Simple
    extends JsonParser {
        public Simple(PropertyStore ps) {
            super(ps, "application/json+simple", "text/json+simple");
        }
    }

    public static class Strict
    extends JsonParser {
        public Strict(PropertyStore ps) {
            super(ps.builder().set("Parser.strict.b", true).set(JsonParser.JSON_validateEnd, true).build());
        }
    }
}

