/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.httppart.bean;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.juneau.BeanContext;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.annotation.InvalidAnnotationException;
import org.apache.juneau.http.annotation.Body;
import org.apache.juneau.http.annotation.FormData;
import org.apache.juneau.http.annotation.Header;
import org.apache.juneau.http.annotation.Path;
import org.apache.juneau.http.annotation.Query;
import org.apache.juneau.http.annotation.Request;
import org.apache.juneau.http.annotation.ResponseBody;
import org.apache.juneau.http.annotation.ResponseHeader;
import org.apache.juneau.http.annotation.ResponseStatus;
import org.apache.juneau.httppart.HttpPartParser;
import org.apache.juneau.httppart.HttpPartSerializer;
import org.apache.juneau.httppart.HttpPartType;
import org.apache.juneau.httppart.bean.RequestBeanPropertyMeta;
import org.apache.juneau.httppart.bean.Utils;
import org.apache.juneau.internal.ClassUtils;
import org.apache.juneau.reflect.ClassInfo;
import org.apache.juneau.reflect.MethodInfo;
import org.apache.juneau.reflect.ParamInfo;

public class RequestBeanMeta {
    private final ClassMeta<?> cm;
    private final Map<String, RequestBeanPropertyMeta> properties;
    private final HttpPartSerializer serializer;
    private final HttpPartParser parser;

    public static RequestBeanMeta create(ParamInfo mpi, PropertyStore ps) {
        if (!mpi.hasAnnotation(Request.class)) {
            return null;
        }
        return new Builder(ps).apply(mpi).build();
    }

    public static RequestBeanMeta create(Class<?> c, PropertyStore ps) {
        ClassInfo ci = ClassInfo.of(c);
        if (!ci.hasAnnotation(Request.class)) {
            return null;
        }
        return new Builder(ps).apply(c).build();
    }

    RequestBeanMeta(Builder b) {
        this.cm = b.cm;
        this.serializer = ClassUtils.castOrCreate(HttpPartSerializer.class, b.serializer, true, b.ps);
        this.parser = ClassUtils.castOrCreate(HttpPartParser.class, b.parser, true, b.ps);
        LinkedHashMap<String, RequestBeanPropertyMeta> properties = new LinkedHashMap<String, RequestBeanPropertyMeta>();
        for (Map.Entry<String, RequestBeanPropertyMeta.Builder> e : b.properties.entrySet()) {
            properties.put(e.getKey(), e.getValue().build(this.serializer, this.parser));
        }
        this.properties = Collections.unmodifiableMap(properties);
    }

    public ClassMeta<?> getClassMeta() {
        return this.cm;
    }

    public RequestBeanPropertyMeta getProperty(String name) {
        return this.properties.get(name);
    }

    public Collection<RequestBeanPropertyMeta> getProperties() {
        return this.properties.values();
    }

    static class Builder {
        ClassMeta<?> cm;
        PropertyStore ps;
        Class<? extends HttpPartSerializer> serializer;
        Class<? extends HttpPartParser> parser;
        Map<String, RequestBeanPropertyMeta.Builder> properties = new LinkedHashMap<String, RequestBeanPropertyMeta.Builder>();

        Builder(PropertyStore ps) {
            this.ps = ps;
        }

        Builder apply(ParamInfo mpi) {
            return this.apply(mpi.getParameterType().inner()).apply(mpi.getAnnotation(Request.class));
        }

        Builder apply(Class<?> c) {
            ClassInfo ci = ClassInfo.of(c);
            this.apply(ci.getAnnotation(Request.class));
            this.cm = BeanContext.DEFAULT.getClassMeta(c);
            for (MethodInfo m : this.cm.getInfo().getAllMethods()) {
                if (!m.isPublic()) continue;
                InvalidAnnotationException.assertNoInvalidAnnotations(m, ResponseHeader.class, ResponseBody.class, ResponseStatus.class);
                String n = m.getSimpleName();
                if (m.hasAnnotation(Body.class)) {
                    Utils.assertNoArgs(m, Body.class);
                    Utils.assertReturnNotVoid(m, Body.class);
                    this.properties.put(n, RequestBeanPropertyMeta.create(HttpPartType.BODY, Body.class, m));
                    continue;
                }
                if (m.hasAnnotation(Header.class)) {
                    Utils.assertNoArgs(m, Header.class);
                    Utils.assertReturnNotVoid(m, Header.class);
                    this.properties.put(n, RequestBeanPropertyMeta.create(HttpPartType.HEADER, Header.class, m));
                    continue;
                }
                if (m.hasAnnotation(Query.class)) {
                    Utils.assertNoArgs(m, Query.class);
                    Utils.assertReturnNotVoid(m, Query.class);
                    this.properties.put(n, RequestBeanPropertyMeta.create(HttpPartType.QUERY, Query.class, m));
                    continue;
                }
                if (m.hasAnnotation(FormData.class)) {
                    Utils.assertNoArgs(m, FormData.class);
                    Utils.assertReturnNotVoid(m, FormData.class);
                    this.properties.put(n, RequestBeanPropertyMeta.create(HttpPartType.FORMDATA, FormData.class, m));
                    continue;
                }
                if (!m.hasAnnotation(Path.class)) continue;
                Utils.assertNoArgs(m, Path.class);
                Utils.assertReturnNotVoid(m, Path.class);
                this.properties.put(n, RequestBeanPropertyMeta.create(HttpPartType.PATH, Path.class, m));
            }
            return this;
        }

        Builder apply(Request a) {
            if (a != null) {
                if (a.partSerializer() != HttpPartSerializer.Null.class) {
                    this.serializer = a.partSerializer();
                }
                if (a.partParser() != HttpPartParser.Null.class) {
                    this.parser = a.partParser();
                }
            }
            return this;
        }

        RequestBeanMeta build() {
            return new RequestBeanMeta(this);
        }
    }
}

