/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.html;

import org.apache.juneau.DefaultFilteringObjectMap;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.annotation.ConfigurableContext;
import org.apache.juneau.html.AnchorText;
import org.apache.juneau.html.HtmlSchemaSerializer;
import org.apache.juneau.html.HtmlSerializerBuilder;
import org.apache.juneau.html.HtmlSerializerSession;
import org.apache.juneau.serializer.SerializerSessionArgs;
import org.apache.juneau.xml.XmlSerializer;

@ConfigurableContext
public class HtmlSerializer
extends XmlSerializer {
    static final String PREFIX = "HtmlSerializer";
    public static final String HTML_addBeanTypes = "HtmlSerializer.addBeanTypes.b";
    public static final String HTML_addKeyValueTableHeaders = "HtmlSerializer.addKeyValueTableHeaders.b";
    public static final String HTML_detectLinksInStrings = "HtmlSerializer.detectLinksInStrings.b";
    public static final String HTML_labelParameter = "HtmlSerializer.labelParameter.s";
    public static final String HTML_detectLabelParameters = "HtmlSerializer.detectLabelParameters.b";
    public static final String HTML_uriAnchorText = "HtmlSerializer.uriAnchorText.s";
    public static final HtmlSerializer DEFAULT = new HtmlSerializer(PropertyStore.DEFAULT);
    public static final HtmlSerializer DEFAULT_SQ = new Sq(PropertyStore.DEFAULT);
    public static final HtmlSerializer DEFAULT_SQ_READABLE = new SqReadable(PropertyStore.DEFAULT);
    private final AnchorText uriAnchorText = this.getProperty("HtmlSerializer.uriAnchorText.s", AnchorText.class, AnchorText.TO_STRING);
    private final boolean detectLabelParameters = this.getBooleanProperty("HtmlSerializer.detectLabelParameters.b", true);
    private final boolean detectLinksInStrings = this.getBooleanProperty("HtmlSerializer.detectLinksInStrings.b", true);
    private final boolean addKeyValueTableHeaders;
    private final boolean addBeanTypes;
    private final String labelParameter = this.getStringProperty("HtmlSerializer.labelParameter.s", "label");
    private volatile HtmlSchemaSerializer schemaSerializer;

    public HtmlSerializer(PropertyStore ps) {
        this(ps, "text/html", null);
    }

    public HtmlSerializer(PropertyStore ps, String produces, String accept) {
        super(ps, produces, accept);
        this.addKeyValueTableHeaders = this.getBooleanProperty(HTML_addKeyValueTableHeaders, false);
        this.addBeanTypes = this.getBooleanProperty(HTML_addBeanTypes, this.getBooleanProperty("Serializer.addBeanTypes.b", false));
    }

    @Override
    public HtmlSerializerBuilder builder() {
        return new HtmlSerializerBuilder(this.getPropertyStore());
    }

    public static HtmlSerializerBuilder create() {
        return new HtmlSerializerBuilder();
    }

    @Override
    public HtmlSerializerSession createSession() {
        return this.createSession(this.createDefaultSessionArgs());
    }

    @Override
    public HtmlSerializerSession createSession(SerializerSessionArgs args) {
        return new HtmlSerializerSession(this, args);
    }

    @Override
    public HtmlSerializer getSchemaSerializer() {
        if (this.schemaSerializer == null) {
            this.schemaSerializer = this.builder().build(HtmlSchemaSerializer.class);
        }
        return this.schemaSerializer;
    }

    @Override
    protected final boolean isAddBeanTypes() {
        return this.addBeanTypes;
    }

    protected final boolean isAddKeyValueTableHeaders() {
        return this.addKeyValueTableHeaders;
    }

    protected final boolean isDetectLabelParameters() {
        return this.detectLabelParameters;
    }

    protected final boolean isDetectLinksInStrings() {
        return this.detectLinksInStrings;
    }

    protected final String getLabelParameter() {
        return this.labelParameter;
    }

    protected final AnchorText getUriAnchorText() {
        return this.uriAnchorText;
    }

    @Override
    public ObjectMap toMap() {
        return super.toMap().append(PREFIX, new DefaultFilteringObjectMap().append("uriAnchorText", (Object)this.uriAnchorText).append("detectLabelParameters", this.detectLabelParameters).append("detectLinksInStrings", this.detectLinksInStrings).append("labelParameter", this.labelParameter).append("addKeyValueTableHeaders", this.addKeyValueTableHeaders).append("addBeanTypes", this.addBeanTypes));
    }

    public static class SqReadable
    extends HtmlSerializer {
        public SqReadable(PropertyStore ps) {
            super(ps.builder().set("WriterSerializer.quoteChar.s", Character.valueOf('\'')).set("WriterSerializer.useWhitespace.b", true).build());
        }
    }

    public static class Sq
    extends HtmlSerializer {
        public Sq(PropertyStore ps) {
            super(ps.builder().set("WriterSerializer.quoteChar.s", Character.valueOf('\'')).build());
        }
    }
}

