/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.client;

import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.juneau.BeanContext;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.ContextCache;
import org.apache.juneau.DefaultFilteringObjectMap;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.ResourceResolver;
import org.apache.juneau.annotation.ConfigurableContext;
import org.apache.juneau.http.remote.RemoteReturn;
import org.apache.juneau.httppart.HttpPartParser;
import org.apache.juneau.httppart.HttpPartSchema;
import org.apache.juneau.httppart.HttpPartSerializer;
import org.apache.juneau.httppart.HttpPartType;
import org.apache.juneau.httppart.bean.RequestBeanMeta;
import org.apache.juneau.httppart.bean.RequestBeanPropertyMeta;
import org.apache.juneau.internal.ArrayUtils;
import org.apache.juneau.internal.ClassUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.json.JsonParser;
import org.apache.juneau.oapi.OpenApiParser;
import org.apache.juneau.oapi.OpenApiSerializer;
import org.apache.juneau.parser.Parser;
import org.apache.juneau.reflect.ClassInfo;
import org.apache.juneau.remote.RemoteInterfaceMeta;
import org.apache.juneau.remote.RemoteInterfaceMethod;
import org.apache.juneau.rest.client.HttpMethod;
import org.apache.juneau.rest.client.NameValuePairs;
import org.apache.juneau.rest.client.RestCall;
import org.apache.juneau.rest.client.RestCallException;
import org.apache.juneau.rest.client.RestCallInterceptor;
import org.apache.juneau.rest.client.RestCallLogger;
import org.apache.juneau.rest.client.RestClientBuilder;
import org.apache.juneau.rest.client.RestRequestEntity;
import org.apache.juneau.rest.client.RetryOn;
import org.apache.juneau.rest.client.remote.RemoteMeta;
import org.apache.juneau.rest.client.remote.RemoteMetadataException;
import org.apache.juneau.rest.client.remote.RemoteMethodArg;
import org.apache.juneau.rest.client.remote.RemoteMethodBeanArg;
import org.apache.juneau.rest.client.remote.RemoteMethodMeta;
import org.apache.juneau.rest.client.remote.RemoteMethodReturn;
import org.apache.juneau.serializer.Serializer;
import org.apache.juneau.serializer.SerializerBuilder;
import org.apache.juneau.urlencoding.UrlEncodingSerializer;
import org.apache.juneau.utils.ASet;

@ConfigurableContext(nocache=true)
public class RestClient
extends BeanContext
implements Closeable {
    private static final String PREFIX = "RestClient.";
    public static final String RESTCLIENT_debug = "RestClient.debug.b";
    public static final String RESTCLIENT_executorService = "RestClient.executorService.o";
    public static final String RESTCLIENT_executorServiceShutdownOnClose = "RestClient.executorServiceShutdownOnClose.b";
    public static final String RESTCLIENT_headers = "RestClient.headers.sms";
    public static final String RESTCLIENT_interceptors = "RestClient.interceptors.lo";
    public static final String RESTCLIENT_interceptors_add = "RestClient.interceptors.lo/add";
    public static final String RESTCLIENT_keepHttpClientOpen = "RestClient.keepHttpClientOpen.b";
    public static final String RESTCLIENT_parser = "RestClient.parser.o";
    public static final String RESTCLIENT_partParser = "RestClient.partParser.o";
    public static final String RESTCLIENT_partSerializer = "RestClient.partSerializer.o";
    public static final String RESTCLIENT_query = "RestClient.query.sms";
    public static final String RESTCLIENT_retries = "RestClient.retries.i";
    public static final String RESTCLIENT_retryInterval = "RestClient.retryInterval.i";
    public static final String RESTCLIENT_retryOn = "RestClient.retryOn.o";
    public static final String RESTCLIENT_rootUri = "RestClient.rootUri.s";
    public static final String RESTCLIENT_serializer = "RestClient.serializer.o";
    private static final Set<String> NO_BODY_METHODS = Collections.unmodifiableSet(ASet.create((Object[])new String[]{"GET", "HEAD", "DELETE", "CONNECT", "OPTIONS", "TRACE"}));
    private static final ConcurrentHashMap<Class, HttpPartSerializer> partSerializerCache = new ConcurrentHashMap();
    private final Map<String, String> headers;
    private final Map<String, String> query;
    private final HttpClientBuilder httpClientBuilder;
    private final CloseableHttpClient httpClient;
    private final boolean keepHttpClientOpen;
    private final boolean debug;
    private final UrlEncodingSerializer urlEncodingSerializer;
    private final HttpPartSerializer partSerializer;
    private final HttpPartParser partParser;
    private final String rootUrl;
    private volatile boolean isClosed = false;
    private final StackTraceElement[] creationStack;
    private StackTraceElement[] closedStack;
    final Serializer serializer;
    final Parser parser;
    final RetryOn retryOn;
    final int retries;
    final long retryInterval;
    final RestCallInterceptor[] interceptors;
    private volatile ExecutorService executorService;
    private final boolean executorServiceShutdownOnClose;
    private Pattern absUrlPattern = Pattern.compile("^\\w+\\:\\/\\/.*");

    public static RestClientBuilder create() {
        return new RestClientBuilder(PropertyStore.DEFAULT, null);
    }

    public static RestClientBuilder create(Serializer s, Parser p) {
        return RestClient.create().serializer(s).parser(p);
    }

    public static RestClientBuilder create(Class<? extends Serializer> s, Class<? extends Parser> p) {
        return RestClient.create().serializer(s).parser(p);
    }

    public RestClientBuilder builder() {
        return new RestClientBuilder(this.getPropertyStore(), this.httpClientBuilder);
    }

    protected RestClient(RestClientBuilder builder) {
        super(builder.getPropertyStore());
        PropertyStore ps = this.getPropertyStore();
        this.httpClientBuilder = builder.getHttpClientBuilder();
        this.httpClient = builder.getHttpClient();
        this.keepHttpClientOpen = this.getBooleanProperty(RESTCLIENT_keepHttpClientOpen, false);
        this.headers = this.getMapProperty(RESTCLIENT_headers, String.class);
        this.query = this.getMapProperty(RESTCLIENT_query, String.class);
        this.retries = this.getIntegerProperty(RESTCLIENT_retries, 1);
        this.retryInterval = this.getIntegerProperty(RESTCLIENT_retryInterval, -1).intValue();
        this.retryOn = (RetryOn)this.getInstanceProperty(RESTCLIENT_retryOn, RetryOn.class, RetryOn.DEFAULT);
        this.debug = this.getBooleanProperty(RESTCLIENT_debug, false);
        this.executorServiceShutdownOnClose = this.getBooleanProperty(RESTCLIENT_executorServiceShutdownOnClose, false);
        this.rootUrl = StringUtils.nullIfEmpty((String)this.getStringProperty(RESTCLIENT_rootUri, "").replaceAll("\\/$", ""));
        Object o = this.getProperty(RESTCLIENT_serializer, Object.class, null);
        this.serializer = o instanceof Serializer ? ((Serializer)o).builder().apply(ps).build() : (o instanceof Class ? (Serializer)ContextCache.INSTANCE.create((Class)o, ps) : null);
        o = this.getProperty(RESTCLIENT_parser, Object.class, null);
        this.parser = o instanceof Parser ? ((Parser)o).builder().apply(ps).build() : (o instanceof Class ? (Parser)ContextCache.INSTANCE.create((Class)o, ps) : null);
        this.urlEncodingSerializer = (UrlEncodingSerializer)new SerializerBuilder(ps).build(UrlEncodingSerializer.class);
        this.partSerializer = (HttpPartSerializer)this.getInstanceProperty(RESTCLIENT_partSerializer, HttpPartSerializer.class, OpenApiSerializer.class, ResourceResolver.FUZZY, new Object[]{ps});
        this.partParser = (HttpPartParser)this.getInstanceProperty(RESTCLIENT_partParser, HttpPartParser.class, OpenApiParser.class, ResourceResolver.FUZZY, new Object[]{ps});
        this.executorService = (ExecutorService)this.getInstanceProperty(RESTCLIENT_executorService, ExecutorService.class, null);
        Object[] rci = (RestCallInterceptor[])this.getInstanceArrayProperty(RESTCLIENT_interceptors, RestCallInterceptor.class, new RestCallInterceptor[0]);
        if (this.debug) {
            rci = (RestCallInterceptor[])ArrayUtils.append((Object[])rci, (Object[])new RestCallInterceptor[]{RestCallLogger.DEFAULT});
        }
        this.interceptors = rci;
        this.creationStack = Boolean.getBoolean("org.apache.juneau.rest.client.RestClient.trackLifecycle") ? Thread.currentThread().getStackTrace() : null;
    }

    protected boolean hasContent(String httpMethod) {
        return !NO_BODY_METHODS.contains(httpMethod);
    }

    @Override
    public void close() throws IOException {
        this.isClosed = true;
        if (this.httpClient != null && !this.keepHttpClientOpen) {
            this.httpClient.close();
        }
        if (this.executorService != null && this.executorServiceShutdownOnClose) {
            this.executorService.shutdown();
        }
        if (this.creationStack != null) {
            this.closedStack = Thread.currentThread().getStackTrace();
        }
    }

    public void closeQuietly() {
        this.isClosed = true;
        try {
            if (this.httpClient != null && !this.keepHttpClientOpen) {
                this.httpClient.close();
            }
            if (this.executorService != null && this.executorServiceShutdownOnClose) {
                this.executorService.shutdown();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this.creationStack != null) {
            this.closedStack = Thread.currentThread().getStackTrace();
        }
    }

    protected HttpResponse execute(HttpRequestBase req) throws ClientProtocolException, IOException {
        return this.httpClient.execute((HttpUriRequest)req);
    }

    protected HttpResponse execute(HttpEntityEnclosingRequestBase req) throws ClientProtocolException, IOException {
        return this.httpClient.execute((HttpUriRequest)req);
    }

    public RestCall doGet(Object url) throws RestCallException {
        return this.doCall("GET", url, false);
    }

    public RestCall doPut(Object url, Object o) throws RestCallException {
        return this.doCall("PUT", url, true).body(o);
    }

    public RestCall doPut(Object url) throws RestCallException {
        return this.doCall("PUT", url, true);
    }

    public RestCall doPost(Object url, Object o) throws RestCallException {
        return this.doCall("POST", url, true).body(o);
    }

    public RestCall doPost(Object url) throws RestCallException {
        return this.doCall("POST", url, true);
    }

    public RestCall doDelete(Object url) throws RestCallException {
        return this.doCall("DELETE", url, false);
    }

    public RestCall doOptions(Object url) throws RestCallException {
        return this.doCall("OPTIONS", url, true);
    }

    public RestCall doFormPost(Object url, Object o) throws RestCallException {
        return this.doCall("POST", url, true).body(o instanceof HttpEntity ? o : new RestRequestEntity(o, (Serializer)this.urlEncodingSerializer, null));
    }

    public RestCall doPatch(Object url, Object o) throws RestCallException {
        return this.doCall("PATCH", url, true).body(o);
    }

    public RestCall doPatch(Object url) throws RestCallException {
        return this.doCall("PATCH", url, true);
    }

    public RestCall doCallback(String callString) throws RestCallException {
        String s = callString;
        try {
            RestCall rc = null;
            String method = null;
            String uri = null;
            String content = null;
            ObjectMap h = null;
            int i = s.indexOf(32);
            if (i != -1) {
                method = s.substring(0, i).trim();
                if ((s = s.substring(i).trim()).length() > 0) {
                    if (s.charAt(0) == '{' && (i = s.indexOf(125)) != -1) {
                        String json = s.substring(0, i + 1);
                        h = (ObjectMap)JsonParser.DEFAULT.parse(json, ObjectMap.class);
                        s = s.substring(i + 1).trim();
                    }
                    if (s.length() > 0) {
                        i = s.indexOf(32);
                        if (i == -1) {
                            uri = s;
                        } else {
                            uri = s.substring(0, i).trim();
                            if ((s = s.substring(i).trim()).length() > 0) {
                                content = s;
                            }
                        }
                    }
                }
            }
            if (method != null && uri != null) {
                rc = this.doCall(method, uri, content != null);
                if (content != null) {
                    rc.body(new StringEntity(content));
                }
                if (h != null) {
                    for (Map.Entry e : h.entrySet()) {
                        rc.header((String)e.getKey(), e.getValue());
                    }
                }
                return rc;
            }
        }
        catch (Exception e) {
            throw new RestCallException(e);
        }
        throw new RestCallException("Invalid format for call string.", new Object[0]);
    }

    public RestCall doCall(HttpMethod method, Object url, Object content) throws RestCallException {
        RestCall rc = this.doCall(method.name(), url, method.hasContent());
        if (method.hasContent()) {
            rc.body(content);
        }
        return rc;
    }

    public RestCall doCall(String method, Object url, boolean hasContent) throws RestCallException {
        if (this.isClosed) {
            Exception e2 = null;
            if (this.closedStack != null) {
                e2 = new Exception("Creation stack:");
                e2.setStackTrace(this.closedStack);
                throw new RestCallException(e2, "RestClient.close() has already been called.  This client cannot be reused.", new Object[0]);
            }
            throw new RestCallException("RestClient.close() has already been called.  This client cannot be reused.  Closed location stack trace can be displayed by setting the system property 'org.apache.juneau.rest.client.RestClient.trackCreation' to true.", new Object[0]);
        }
        Object req = null;
        RestCall restCall = null;
        final String methodUC = method.toUpperCase(Locale.ENGLISH);
        try {
            if (hasContent) {
                req = new HttpEntityEnclosingRequestBase(){

                    public String getMethod() {
                        return methodUC;
                    }
                };
                restCall = new RestCall(this, (HttpRequestBase)req, this.toURI(url));
            } else {
                req = new HttpRequestBase(){

                    public String getMethod() {
                        return methodUC;
                    }
                };
                restCall = new RestCall(this, (HttpRequestBase)req, this.toURI(url));
            }
        }
        catch (URISyntaxException e1) {
            throw new RestCallException(e1);
        }
        for (Map.Entry<String, String> e : this.query.entrySet()) {
            restCall.query(e.getKey(), e.getValue());
        }
        for (Map.Entry<String, String> e : this.headers.entrySet()) {
            restCall.header(e.getKey(), e.getValue());
        }
        if (this.parser != null && !req.containsHeader("Accept")) {
            req.setHeader("Accept", this.parser.getPrimaryMediaType().toString());
        }
        return restCall;
    }

    public <T> T getRemote(Class<T> interfaceClass) {
        return this.getRemote(interfaceClass, null);
    }

    public <T> T getRemote(Class<T> interfaceClass, Object restUrl) {
        return this.getRemote(interfaceClass, restUrl, this.serializer, this.parser);
    }

    public <T> T getRemote(final Class<T> interfaceClass, Object restUrl, final Serializer serializer, final Parser parser) {
        if (restUrl == null) {
            restUrl = this.rootUrl;
        }
        final String restUrl2 = StringUtils.trimSlashes((String)StringUtils.emptyIfNull((Object)restUrl));
        try {
            return (T)Proxy.newProxyInstance(interfaceClass.getClassLoader(), new Class[]{interfaceClass}, new InvocationHandler(){
                final RemoteMeta rm;
                {
                    this.rm = new RemoteMeta(interfaceClass);
                }

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    RemoteMethodReturn rmr;
                    Throwable throwable;
                    RestCall rc;
                    RemoteMethodMeta rmm = this.rm.getMethodMeta(method);
                    if (rmm == null) {
                        throw new RuntimeException("Method is not exposed as a remote method.");
                    }
                    String url = rmm.getFullPath();
                    if (url.indexOf("://") == -1) {
                        url = restUrl2 + '/' + url;
                    }
                    if (url.indexOf("://") == -1) {
                        throw new RemoteMetadataException(interfaceClass, "Root URI has not been specified.  Cannot construct absolute path to remote resource.", new Object[0]);
                    }
                    String httpMethod = rmm.getHttpMethod();
                    HttpPartSerializer s = RestClient.this.getPartSerializer();
                    try {
                        rc = RestClient.this.doCall(httpMethod, (Object)url, RestClient.this.hasContent(httpMethod));
                        throwable = null;
                        try {
                            rc.serializer(serializer).parser(parser);
                            for (RemoteMethodArg a : rmm.getPathArgs()) {
                                rc.path(a.getName(), args[a.getIndex()], a.getSerializer(s), a.getSchema());
                            }
                            for (RemoteMethodArg a : rmm.getQueryArgs()) {
                                rc.query(a.getName(), args[a.getIndex()], a.isSkipIfEmpty(), a.getSerializer(s), a.getSchema());
                            }
                            for (RemoteMethodArg a : rmm.getFormDataArgs()) {
                                rc.formData(a.getName(), args[a.getIndex()], a.isSkipIfEmpty(), a.getSerializer(s), a.getSchema());
                            }
                            for (RemoteMethodArg a : rmm.getHeaderArgs()) {
                                rc.header(a.getName(), args[a.getIndex()], a.isSkipIfEmpty(), a.getSerializer(s), a.getSchema());
                            }
                            RemoteMethodArg ba = rmm.getBodyArg();
                            if (ba != null) {
                                rc.requestBodySchema(ba.getSchema()).body(args[ba.getIndex()]);
                            }
                            if (rmm.getRequestArgs().length > 0) {
                                for (RemoteMethodBeanArg rmba : rmm.getRequestArgs()) {
                                    RequestBeanMeta rbm = rmba.getMeta();
                                    Object bean = args[rmba.getIndex()];
                                    if (bean == null) continue;
                                    for (RequestBeanPropertyMeta p : rbm.getProperties()) {
                                        Object val = p.getGetter().invoke(bean, new Object[0]);
                                        HttpPartType pt = p.getPartType();
                                        HttpPartSerializer ps = p.getSerializer(s);
                                        String pn = p.getPartName();
                                        HttpPartSchema schema = p.getSchema();
                                        boolean sie = schema.isSkipIfEmpty();
                                        if (pt == HttpPartType.PATH) {
                                            rc.path(pn, val, p.getSerializer(s), schema);
                                            continue;
                                        }
                                        if (val == null) continue;
                                        if (pt == HttpPartType.QUERY) {
                                            rc.query(pn, val, sie, ps, schema);
                                            continue;
                                        }
                                        if (pt == HttpPartType.FORMDATA) {
                                            rc.formData(pn, val, sie, ps, schema);
                                            continue;
                                        }
                                        if (pt == HttpPartType.HEADER) {
                                            rc.header(pn, val, sie, ps, schema);
                                            continue;
                                        }
                                        if (pt != HttpPartType.BODY) continue;
                                        rc.requestBodySchema(schema).body(val);
                                    }
                                }
                            }
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                    }
                    catch (RestCallException e) {
                        e.throwServerException(interfaceClass.getClassLoader(), rmm.getExceptions());
                        throw new RuntimeException(e);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                    if (rmm.getOtherArgs().length > 0) {
                        Object[] otherArgs = new Object[rmm.getOtherArgs().length];
                        int i = 0;
                        for (RemoteMethodArg a : rmm.getOtherArgs()) {
                            otherArgs[i++] = args[a.getIndex()];
                        }
                        rc.body(otherArgs);
                    }
                    if ((rmr = rmm.getReturns()).getReturnValue() == RemoteReturn.NONE) {
                        rc.run();
                        return null;
                    }
                    if (rmr.getReturnValue() == RemoteReturn.STATUS) {
                        rc.ignoreErrors();
                        int returnCode = rc.run();
                        Class<?> rt = method.getReturnType();
                        if (rt == Integer.class) return returnCode;
                        if (rt == Integer.TYPE) {
                            return returnCode;
                        }
                        if (rt != Boolean.class) {
                            if (rt != Boolean.TYPE) throw new RestCallException("Invalid return type on method annotated with @RemoteMethod(returns=HTTP_STATUS).  Only integer and booleans types are valid.", new Object[0]);
                        }
                        return returnCode < 400;
                    }
                    if (rmr.getReturnValue() == RemoteReturn.BEAN) {
                        return rc.getResponse(rmr.getResponseBeanMeta());
                    }
                    Object v = rc.getResponseBody(rmr.getReturnType(), new Type[0]);
                    if (v != null) return v;
                    if (!method.getReturnType().isPrimitive()) return v;
                    v = ClassInfo.of(method.getReturnType()).getPrimitiveDefault();
                    return v;
                    finally {
                        if (rc != null) {
                            if (throwable != null) {
                                try {
                                    rc.close();
                                }
                                catch (Throwable a) {
                                    throwable.addSuppressed(a);
                                }
                            } else {
                                rc.close();
                            }
                        }
                    }
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    public <T> T getRemoteResource(Class<T> interfaceClass) {
        return this.getRemote(interfaceClass, null);
    }

    @Deprecated
    public <T> T getRemoteResource(Class<T> interfaceClass, Object restUrl) {
        return this.getRemote(interfaceClass, null);
    }

    @Deprecated
    public <T> T getRemoteResource(Class<T> interfaceClass, Object restUrl, Serializer serializer, Parser parser) {
        return this.getRemote(interfaceClass, null);
    }

    public <T> T getRrpcInterface(Class<T> interfaceClass) {
        return this.getRrpcInterface(interfaceClass, null);
    }

    public <T> T getRrpcInterface(Class<T> interfaceClass, Object restUrl) {
        return this.getRrpcInterface(interfaceClass, restUrl, this.serializer, this.parser);
    }

    public <T> T getRrpcInterface(final Class<T> interfaceClass, Object restUrl, final Serializer serializer, final Parser parser) {
        if (restUrl == null) {
            RemoteInterfaceMeta rm = new RemoteInterfaceMeta(interfaceClass, StringUtils.stringify((Object)restUrl));
            String path = rm.getPath();
            if (path.indexOf("://") == -1) {
                if (this.rootUrl == null) {
                    throw new RemoteMetadataException(interfaceClass, "Root URI has not been specified.  Cannot construct absolute path to remote interface.", new Object[0]);
                }
                path = StringUtils.trimSlashes((String)this.rootUrl) + '/' + path;
            }
            restUrl = path;
        }
        final String restUrl2 = StringUtils.stringify((Object)restUrl);
        try {
            return (T)Proxy.newProxyInstance(interfaceClass.getClassLoader(), new Class[]{interfaceClass}, new InvocationHandler(){
                final RemoteInterfaceMeta rm;
                {
                    this.rm = new RemoteInterfaceMeta(interfaceClass, restUrl2);
                }

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    RemoteInterfaceMethod rim = this.rm.getMethodMeta(method);
                    if (rim == null) {
                        throw new RuntimeException("Method is not exposed as a remote method.");
                    }
                    String url = rim.getUrl();
                    try (RestCall rc = RestClient.this.doCall("POST", (Object)url, true);){
                        rc.serializer(serializer).parser(parser).body(args);
                        Object v = rc.getResponse(method.getGenericReturnType(), new Type[0]);
                        if (v == null && method.getReturnType().isPrimitive()) {
                            v = ClassInfo.of(method.getReturnType()).getPrimitiveDefault();
                        }
                        Object t = v;
                        return t;
                    }
                    catch (RestCallException e) {
                        e.throwServerException(interfaceClass.getClassLoader(), method.getExceptionTypes());
                        throw new RuntimeException(e);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static final String getName(String name1, String name2, BeanPropertyMeta pMeta) {
        String n = name1.isEmpty() ? name2 : name1;
        ClassMeta cm = pMeta.getClassMeta();
        if (n.isEmpty() && (cm.isMapOrBean() || cm.isReader() || cm.isInstanceOf(NameValuePairs.class))) {
            n = "*";
        }
        if (n.isEmpty()) {
            n = pMeta.getName();
        }
        return n;
    }

    final HttpPartSerializer getPartSerializer(Class c, HttpPartSerializer c2) {
        if (c2 != null) {
            return c2;
        }
        if (c == HttpPartSerializer.Null.class) {
            return null;
        }
        HttpPartSerializer pf = partSerializerCache.get(c);
        if (pf == null) {
            partSerializerCache.putIfAbsent(c, (HttpPartSerializer)ClassUtils.castOrCreate(HttpPartSerializer.class, (Object)c, (boolean)true, (Object[])new Object[]{this.getPropertyStore()}));
            pf = partSerializerCache.get(c);
        }
        return pf;
    }

    HttpPartSerializer getPartSerializer() {
        return this.partSerializer;
    }

    HttpPartParser getPartParser() {
        return this.partParser;
    }

    URI toURI(Object url) throws URISyntaxException {
        String s;
        if (url instanceof URI) {
            return (URI)url;
        }
        if (url instanceof URL) {
            ((URL)url).toURI();
        }
        if (url instanceof URIBuilder) {
            return ((URIBuilder)url).build();
        }
        String string = s = url == null ? "" : url.toString();
        if (this.rootUrl != null && !this.absUrlPattern.matcher(s).matches()) {
            if (s.isEmpty()) {
                s = this.rootUrl;
            } else {
                StringBuilder sb = new StringBuilder(this.rootUrl);
                if (!s.startsWith("/")) {
                    sb.append('/');
                }
                sb.append(s);
                s = sb.toString();
            }
        }
        if (s.indexOf(123) != -1) {
            s = s.replace("{", "%7B").replace("}", "%7D");
        }
        return new URI(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ExecutorService getExecutorService(boolean create) {
        if (this.executorService != null || !create) {
            return this.executorService;
        }
        RestClient restClient = this;
        synchronized (restClient) {
            if (this.executorService == null) {
                this.executorService = new ThreadPoolExecutor(1, 1, 30L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(10));
            }
            return this.executorService;
        }
    }

    protected void finalize() throws Throwable {
        if (!this.isClosed && !this.keepHttpClientOpen) {
            System.err.println("WARNING:  RestClient garbage collected before it was finalized.");
            if (this.creationStack != null) {
                System.err.println("Creation Stack:");
                for (StackTraceElement e : this.creationStack) {
                    System.err.println(e);
                }
            } else {
                System.err.println("Creation stack traces can be displayed by setting the system property 'org.apache.juneau.rest.client.RestClient.trackLifecycle' to true.");
            }
        }
    }

    public ObjectMap toMap() {
        return super.toMap().append("RestClient", (Object)new DefaultFilteringObjectMap().append("debug", (Object)this.debug).append("executorService", (Object)this.executorService).append("executorServiceShutdownOnClose", (Object)this.executorServiceShutdownOnClose).append("headers", this.headers).append("interceptors", (Object)this.interceptors).append("keepHttpClientOpen", (Object)this.keepHttpClientOpen).append("parser", (Object)this.parser).append("partParser", (Object)this.partParser).append("partSerializer", (Object)this.partSerializer).append("query", this.query).append("retries", (Object)this.retries).append("retryInterval", (Object)this.retryInterval).append("retryOn", (Object)this.retryOn).append("rootUri", (Object)this.rootUrl).append("serializer", (Object)this.serializer));
    }
}

