/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.html;

import org.apache.juneau.ClassMeta;
import org.apache.juneau.ClassMetaExtended;
import org.apache.juneau.html.HtmlRender;
import org.apache.juneau.html.annotation.Html;
import org.apache.juneau.html.annotation.HtmlFormat;
import org.apache.juneau.internal.ClassUtils;

public class HtmlClassMeta
extends ClassMetaExtended {
    private final Html html;
    private final boolean noTables;
    private final boolean noTableHeaders;
    private final HtmlFormat format;
    private final HtmlRender<?> render;

    public HtmlClassMeta(ClassMeta<?> cm) {
        super(cm);
        this.html = cm.getInfo().getAnnotation(Html.class);
        if (this.html != null) {
            this.format = this.html.format();
            this.noTables = this.html.noTables();
            this.noTableHeaders = this.html.noTableHeaders();
            this.render = ClassUtils.castOrCreate(HtmlRender.class, this.html.render());
        } else {
            this.format = HtmlFormat.HTML;
            this.noTables = false;
            this.noTableHeaders = false;
            this.render = null;
        }
    }

    protected Html getAnnotation() {
        return this.html;
    }

    protected HtmlFormat getFormat() {
        return this.format;
    }

    protected boolean isXml() {
        return this.format == HtmlFormat.XML;
    }

    protected boolean isPlainText() {
        return this.format == HtmlFormat.PLAIN_TEXT;
    }

    protected boolean isHtml() {
        return this.format == HtmlFormat.HTML;
    }

    protected boolean isHtmlCdc() {
        return this.format == HtmlFormat.HTML_CDC;
    }

    protected boolean isHtmlSdc() {
        return this.format == HtmlFormat.HTML_SDC;
    }

    protected boolean isNoTables() {
        return this.noTables;
    }

    public boolean isNoTableHeaders() {
        return this.noTableHeaders;
    }

    public HtmlRender<?> getRender() {
        return this.render;
    }
}

