/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.juneau.ContextBuilder;
import org.apache.juneau.DefaultFilteringObjectMap;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.ResourceResolver;
import org.apache.juneau.Session;
import org.apache.juneau.SessionArgs;
import org.apache.juneau.annotation.BeanIgnore;
import org.apache.juneau.internal.HashCode;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.json.SimpleJsonSerializer;

public abstract class Context {
    private final PropertyStore propertyStore;
    private final int identityCode;

    public Context(PropertyStore ps, boolean allowReuse) {
        this.propertyStore = ps == null ? PropertyStore.DEFAULT : ps;
        this.identityCode = allowReuse ? new HashCode().add(this.getClass().getName()).add(ps).get() : System.identityHashCode(this);
    }

    public Object getProperty(String key) {
        return this.propertyStore.getProperty(key);
    }

    public final <T> T getProperty(String key, Class<T> c, T def) {
        return this.propertyStore.getProperty(key, c, def);
    }

    public final Boolean getBooleanProperty(String key, Boolean def) {
        return this.getProperty(key, Boolean.class, def);
    }

    public final Integer getIntegerProperty(String key, Integer def) {
        return this.getProperty(key, Integer.class, def);
    }

    public final Long getLongProperty(String key, Long def) {
        return this.getProperty(key, Long.class, def);
    }

    public final String getStringProperty(String key, String def) {
        return this.getProperty(key, String.class, def);
    }

    public final String[] getCdlProperty(String key, String def) {
        return StringUtils.split(StringUtils.emptyIfNull(this.getProperty(key, String.class, def)));
    }

    public final String getStringPropertyWithNone(String key, String def) {
        String s = this.getProperty(key, String.class, def);
        return "NONE".equalsIgnoreCase(s) ? "" : s;
    }

    public final <T> Class<? extends T> getClassProperty(String key, Class<T> type, Class<? extends T> def) {
        return this.propertyStore.getClassProperty(key, type, def);
    }

    public final <T> T[] getArrayProperty(String key, Class<T> eType) {
        return this.propertyStore.getArrayProperty(key, eType);
    }

    public final <T> T[] getArrayProperty(String key, Class<T> eType, T[] def) {
        return this.propertyStore.getArrayProperty(key, eType, def);
    }

    public final Class<?>[] getClassArrayProperty(String key) {
        return this.propertyStore.getClassArrayProperty(key);
    }

    public final Class<?>[] getClassArrayProperty(String key, Class<?>[] def) {
        return this.propertyStore.getClassArrayProperty(key, def);
    }

    public final <T> Class<T>[] getClassArrayProperty(String key, Class<T> eType) {
        return this.propertyStore.getClassArrayProperty(key, eType);
    }

    public final <T> Set<T> getSetProperty(String key, Class<T> eType) {
        return this.propertyStore.getSetProperty(key, eType);
    }

    public final <T> Set<T> getSetProperty(String key, Class<T> eType, Set<T> def) {
        return this.propertyStore.getSetProperty(key, eType, def);
    }

    public final Set<Class<?>> getClassSetProperty(String key) {
        return this.propertyStore.getClassSetProperty(key);
    }

    public final <T> Set<Class<T>> getClassSetProperty(String key, Class<T> eType) {
        return this.propertyStore.getClassSetProperty(key, eType);
    }

    public final <T> List<T> getListProperty(String key, Class<T> eType) {
        return this.propertyStore.getListProperty(key, eType);
    }

    public final <T> List<T> getListProperty(String key, Class<T> eType, List<T> def) {
        return this.propertyStore.getListProperty(key, eType, def);
    }

    public final List<Class<?>> getClassListProperty(String key) {
        return this.propertyStore.getClassListProperty(key);
    }

    public final <T> List<Class<T>> getClassListProperty(String key, Class<T> eType) {
        return this.propertyStore.getClassListProperty(key, eType);
    }

    public final <T> Map<String, T> getMapProperty(String key, Class<T> eType) {
        return this.propertyStore.getMapProperty(key, eType);
    }

    public final Map<String, Class<?>> getClassMapProperty(String key) {
        return this.propertyStore.getClassMapProperty(key);
    }

    public final <T> Map<String, Class<T>> getClassMapProperty(String key, Class<T> eType) {
        return this.propertyStore.getClassMapProperty(key, eType);
    }

    public <T> T getInstanceProperty(String key, Class<T> type, Object def) {
        return this.propertyStore.getInstanceProperty(key, type, def);
    }

    public <T> T getInstanceProperty(String key, Class<T> type, Object def, ResourceResolver resolver, Object ... args) {
        return this.propertyStore.getInstanceProperty(key, type, def, resolver, args);
    }

    public <T> T getInstanceProperty(String key, Object outer, Class<T> type, Object def, ResourceResolver resolver, Object ... args) {
        return this.propertyStore.getInstanceProperty(key, outer, type, def, resolver, args);
    }

    public <T> T[] getInstanceArrayProperty(String key, Class<T> type, T[] def) {
        return this.propertyStore.getInstanceArrayProperty(key, type, def);
    }

    public <T> T[] getInstanceArrayProperty(String key, Class<T> type, T[] def, ResourceResolver resolver, Object ... args) {
        return this.propertyStore.getInstanceArrayProperty(key, type, def, resolver, args);
    }

    public <T> T[] getInstanceArrayProperty(String key, Object outer, Class<T> type, T[] def, ResourceResolver resolver, Object ... args) {
        return this.propertyStore.getInstanceArrayProperty(key, outer, type, def, resolver, args);
    }

    public Set<String> getPropertyKeys(String group) {
        return this.propertyStore.getPropertyKeys(group);
    }

    @BeanIgnore
    public final PropertyStore getPropertyStore() {
        return this.propertyStore;
    }

    public ContextBuilder builder() {
        return null;
    }

    public Session createSession() {
        return this.createSession(this.createDefaultSessionArgs());
    }

    public abstract Session createSession(SessionArgs var1);

    public abstract SessionArgs createDefaultSessionArgs();

    public int hashCode() {
        return this.identityCode;
    }

    public int identityCode() {
        return this.identityCode;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        Context c = (Context)o;
        return c.propertyStore.equals(this.propertyStore);
    }

    public String toString() {
        return SimpleJsonSerializer.DEFAULT_READABLE.toString(this.toMap());
    }

    public ObjectMap toMap() {
        return new DefaultFilteringObjectMap().append("Context", new DefaultFilteringObjectMap().append("identityCode", this.identityCode).append("propertyStore", this.propertyStore));
    }
}

