/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.xml.annotation;

import org.apache.juneau.ConfigApply;
import org.apache.juneau.PropertyStoreBuilder;
import org.apache.juneau.reflect.AnnotationInfo;
import org.apache.juneau.svl.VarResolverSession;
import org.apache.juneau.xml.Namespace;
import org.apache.juneau.xml.XmlEventAllocator;
import org.apache.juneau.xml.XmlReporter;
import org.apache.juneau.xml.XmlResolver;
import org.apache.juneau.xml.annotation.XmlConfig;

public class XmlConfigApply
extends ConfigApply<XmlConfig> {
    public XmlConfigApply(Class<XmlConfig> c, VarResolverSession r) {
        super(c, r);
    }

    @Override
    public void apply(AnnotationInfo<XmlConfig> ai, PropertyStoreBuilder psb) {
        XmlConfig a = ai.getAnnotation();
        if (!a.addBeanTypes().isEmpty()) {
            psb.set("XmlSerializer.addBeanTypes.b", this.bool(a.addBeanTypes()));
        }
        if (!a.addNamespaceUrisToRoot().isEmpty()) {
            psb.set("XmlSerializer.addNamespaceUrisToRoot.b", this.bool(a.addNamespaceUrisToRoot()));
        }
        if (!a.autoDetectNamespaces().isEmpty()) {
            psb.set("XmlSerializer.autoDetectNamespaces.b", this.bool(a.autoDetectNamespaces()));
        }
        if (!a.defaultNamespace().isEmpty()) {
            psb.set("XmlSerializer.defaultNamespace.s", this.string(a.defaultNamespace()));
        }
        if (!a.enableNamespaces().isEmpty()) {
            psb.set("XmlSerializer.enableNamespaces.b", this.bool(a.enableNamespaces()));
        }
        if (a.namespaces().length > 0) {
            psb.set("XmlSerializer.namespaces.ls", Namespace.createArray(this.strings(a.namespaces())));
        }
        if (!a.xsNamespace().isEmpty()) {
            psb.set("XmlSerializer.xsNamespace.s", this.string(a.xsNamespace()));
        }
        if (a.eventAllocator() != XmlEventAllocator.Null.class) {
            psb.set("XmlParser.eventAllocator.c", a.eventAllocator());
        }
        if (!a.preserveRootElement().isEmpty()) {
            psb.set("XmlParser.preserveRootElement.b", this.bool(a.preserveRootElement()));
        }
        if (a.reporter() != XmlReporter.Null.class) {
            psb.set("XmlParser.reporter.c", a.reporter());
        }
        if (a.resolver() != XmlResolver.Null.class) {
            psb.set("XmlParser.resolver.c", a.resolver());
        }
        if (!a.validating().isEmpty()) {
            psb.set("XmlParser.validating.b", this.bool(a.validating()));
        }
    }
}

