/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.juneau.Visibility;
import org.apache.juneau.internal.ClassUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.reflect.ClassInfo;
import org.apache.juneau.reflect.ParamInfo;
import org.apache.juneau.reflect.ReflectFlags;

public abstract class ExecutableInfo {
    final ClassInfo declaringClass;
    final Executable e;
    final boolean isConstructor;
    private List<ParamInfo> params;
    private List<ClassInfo> paramTypes;
    private List<ClassInfo> exceptionInfos;
    private Class<?>[] rawParamTypes;
    private Class<?>[] rawExceptionTypes;
    private Type[] rawGenericParamTypes;
    private Parameter[] rawParameters;
    private Map<Class<?>, Optional<Annotation>> annotationMap;

    protected ExecutableInfo(ClassInfo declaringClass, Executable e) {
        this.declaringClass = declaringClass;
        this.e = e;
        this.isConstructor = e instanceof Constructor;
    }

    public final ClassInfo getDeclaringClass() {
        return this.declaringClass;
    }

    public final boolean isConstructor() {
        return this.isConstructor;
    }

    public final int getParamCount() {
        return this.e.getParameterCount();
    }

    public final boolean hasParams() {
        return this.getParamCount() != 0;
    }

    public final boolean hasNoParams() {
        return this.getParamCount() == 0;
    }

    public final boolean hasNumParams(int number) {
        return this.getParamCount() == number;
    }

    public final List<ParamInfo> getParams() {
        if (this.params == null) {
            Parameter[] rp = this.rawParameters();
            ArrayList<ParamInfo> l = new ArrayList<ParamInfo>(rp.length);
            for (int i = 0; i < rp.length; ++i) {
                l.add(new ParamInfo(this, rp[i], i));
            }
            this.params = Collections.unmodifiableList(l);
        }
        return this.params;
    }

    public final ParamInfo getParam(int index) {
        this.checkIndex(index);
        if (this.params != null) {
            return this.params.get(index);
        }
        return new ParamInfo(this, this.rawParameters()[index], index);
    }

    public final List<ClassInfo> getParamTypes() {
        if (this.paramTypes == null) {
            Class<?>[] ptc = this.rawParamTypes();
            Type[] ptt = this.rawGenericParamTypes();
            if (ptt.length != ptc.length) {
                ptt = ptc;
            }
            ArrayList<ClassInfo> l = new ArrayList<ClassInfo>(ptc.length);
            for (int i = 0; i < ptc.length; ++i) {
                l.add(ClassInfo.of(ptc[i], ptt[i]));
            }
            this.paramTypes = Collections.unmodifiableList(l);
        }
        return this.paramTypes;
    }

    public final ClassInfo getParamType(int index) {
        this.checkIndex(index);
        if (this.paramTypes != null) {
            return this.getParamTypes().get(index);
        }
        return ClassInfo.of(this.getRawParamType(index), this.getRawGenericParamType(index));
    }

    public final Class<?>[] getRawParamTypes() {
        return (Class[])this.rawParamTypes().clone();
    }

    public final Class<?> getRawParamType(int index) {
        this.checkIndex(index);
        return this.rawParamTypes()[index];
    }

    public final Type[] getRawGenericParamTypes() {
        return (Type[])this.rawGenericParamTypes().clone();
    }

    public final Type getRawGenericParamType(int index) {
        this.checkIndex(index);
        return this.rawGenericParamTypes()[index];
    }

    public final Parameter[] getRawParameters() {
        return (Parameter[])this.rawParameters().clone();
    }

    public final Parameter getRawParameter(int index) {
        this.checkIndex(index);
        return this.rawParameters()[index];
    }

    Class<?>[] rawParamTypes() {
        if (this.rawParamTypes == null) {
            this.rawParamTypes = this.e.getParameterTypes();
        }
        return this.rawParamTypes;
    }

    Type[] rawGenericParamTypes() {
        if (this.rawGenericParamTypes == null) {
            this.rawGenericParamTypes = this.e.getGenericParameterTypes();
        }
        return this.rawGenericParamTypes;
    }

    Parameter[] rawParameters() {
        if (this.rawParameters == null) {
            this.rawParameters = this.e.getParameters();
        }
        return this.rawParameters;
    }

    private void checkIndex(int index) {
        int pc = this.getParamCount();
        if (pc == 0) {
            throw new IndexOutOfBoundsException(StringUtils.format("Invalid index ''{0}''.  No parameters.", index));
        }
        if (index < 0 || index >= pc) {
            throw new IndexOutOfBoundsException(StringUtils.format("Invalid index ''{0}''.  Parameter count: {1}", index, pc));
        }
    }

    public final Annotation[][] getParameterAnnotations() {
        return this.e.getParameterAnnotations();
    }

    public final Annotation[] getParameterAnnotations(int index) {
        this.checkIndex(index);
        return this.e.getParameterAnnotations()[index];
    }

    public final boolean hasAnnotation(Class<? extends Annotation> a) {
        return this.getAnnotation(a) != null;
    }

    public final <T extends Annotation> T getAnnotation(Class<T> a) {
        if (a == null) {
            return null;
        }
        Optional<Annotation> o = this.annotationMap().get(a);
        if (o == null) {
            o = Optional.ofNullable(this.findAnnotation(a));
            this.annotationMap().put(a, o);
        }
        return (T)(o.isPresent() ? o.get() : null);
    }

    protected <T extends Annotation> T findAnnotation(Class<T> a) {
        return this.e.getAnnotation(a);
    }

    private synchronized Map<Class<?>, Optional<Annotation>> annotationMap() {
        if (this.annotationMap == null) {
            this.annotationMap = new ConcurrentHashMap();
        }
        return this.annotationMap;
    }

    public final List<ClassInfo> getExceptionTypes() {
        if (this.exceptionInfos == null) {
            Class<?>[] exceptionTypes = this.rawExceptionTypes();
            ArrayList<ClassInfo> l = new ArrayList<ClassInfo>(exceptionTypes.length);
            for (Class<?> et : exceptionTypes) {
                l.add(ClassInfo.of(et));
            }
            this.exceptionInfos = Collections.unmodifiableList(l);
        }
        return this.exceptionInfos;
    }

    public final Class<?>[] getRawExceptionTypes() {
        return (Class[])this.rawExceptionTypes().clone();
    }

    private Class<?>[] rawExceptionTypes() {
        if (this.rawExceptionTypes == null) {
            this.rawExceptionTypes = this.e.getExceptionTypes();
        }
        return this.rawExceptionTypes;
    }

    public final boolean isAll(ReflectFlags ... flags) {
        block12: for (ReflectFlags f : flags) {
            switch (f) {
                case DEPRECATED: {
                    if (!this.isNotDeprecated()) continue block12;
                    return false;
                }
                case NOT_DEPRECATED: {
                    if (!this.isDeprecated()) continue block12;
                    return false;
                }
                case HAS_PARAMS: {
                    if (!this.hasNoParams()) continue block12;
                    return false;
                }
                case HAS_NO_PARAMS: {
                    if (!this.hasParams()) continue block12;
                    return false;
                }
                case PUBLIC: {
                    if (!this.isNotPublic()) continue block12;
                    return false;
                }
                case NOT_PUBLIC: {
                    if (!this.isPublic()) continue block12;
                    return false;
                }
                case STATIC: {
                    if (!this.isNotStatic()) continue block12;
                    return false;
                }
                case NOT_STATIC: {
                    if (!this.isStatic()) continue block12;
                    return false;
                }
                case ABSTRACT: {
                    if (!this.isNotAbstract()) continue block12;
                    return false;
                }
                case NOT_ABSTRACT: {
                    if (!this.isAbstract()) continue block12;
                    return false;
                }
                default: {
                    throw new RuntimeException("Invalid flag for executable: " + (Object)((Object)f));
                }
            }
        }
        return true;
    }

    public final boolean isAny(ReflectFlags ... flags) {
        block12: for (ReflectFlags f : flags) {
            switch (f) {
                case DEPRECATED: {
                    if (!this.isDeprecated()) continue block12;
                    return true;
                }
                case NOT_DEPRECATED: {
                    if (!this.isNotDeprecated()) continue block12;
                    return true;
                }
                case HAS_PARAMS: {
                    if (!this.hasParams()) continue block12;
                    return true;
                }
                case HAS_NO_PARAMS: {
                    if (!this.hasNoParams()) continue block12;
                    return true;
                }
                case PUBLIC: {
                    if (!this.isPublic()) continue block12;
                    return true;
                }
                case NOT_PUBLIC: {
                    if (!this.isNotPublic()) continue block12;
                    return true;
                }
                case STATIC: {
                    if (!this.isStatic()) continue block12;
                    return true;
                }
                case NOT_STATIC: {
                    if (!this.isNotStatic()) continue block12;
                    return true;
                }
                case ABSTRACT: {
                    if (!this.isAbstract()) continue block12;
                    return true;
                }
                case NOT_ABSTRACT: {
                    if (!this.isNotAbstract()) continue block12;
                    return true;
                }
                default: {
                    throw new RuntimeException("Invalid flag for executable: " + (Object)((Object)f));
                }
            }
        }
        return false;
    }

    public final boolean hasParamTypes(Class<?> ... args) {
        Class<?>[] pt = this.rawParamTypes();
        if (pt.length == args.length) {
            for (int i = 0; i < pt.length; ++i) {
                if (pt[i].equals(args[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public final boolean hasParamTypes(ClassInfo ... args) {
        Class<?>[] pt = this.rawParamTypes();
        if (pt.length == args.length) {
            for (int i = 0; i < pt.length; ++i) {
                if (pt[i].equals(args[i].inner())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public final boolean hasParamTypeParents(Class<?> ... args) {
        Class<?>[] pt = this.rawParamTypes();
        if (pt.length == args.length) {
            for (int i = 0; i < pt.length; ++i) {
                if (args[i].isAssignableFrom(pt[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public final boolean hasParamTypeParents(ClassInfo ... args) {
        Class<?>[] pt = this.rawParamTypes();
        if (pt.length == args.length) {
            for (int i = 0; i < pt.length; ++i) {
                if (args[i].inner().isAssignableFrom(pt[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public final boolean hasFuzzyParamTypes(Class<?> ... args) {
        return ClassUtils.fuzzyArgsMatch(this.rawParamTypes(), args) != -1;
    }

    public boolean hasFuzzyParamTypes(ClassInfo ... args) {
        return ClassUtils.fuzzyArgsMatch(this.rawParamTypes(), args) != -1;
    }

    public final boolean isDeprecated() {
        return this.e.isAnnotationPresent(Deprecated.class);
    }

    public final boolean isNotDeprecated() {
        return !this.e.isAnnotationPresent(Deprecated.class);
    }

    public final boolean isAbstract() {
        return Modifier.isAbstract(this.e.getModifiers());
    }

    public final boolean isNotAbstract() {
        return !Modifier.isAbstract(this.e.getModifiers());
    }

    public final boolean isPublic() {
        return Modifier.isPublic(this.e.getModifiers());
    }

    public final boolean isNotPublic() {
        return !Modifier.isPublic(this.e.getModifiers());
    }

    public final boolean isStatic() {
        return Modifier.isStatic(this.e.getModifiers());
    }

    public final boolean isNotStatic() {
        return !Modifier.isStatic(this.e.getModifiers());
    }

    public final boolean setAccessible() {
        try {
            if (!this.e.isAccessible()) {
                this.e.setAccessible(true);
            }
            return true;
        }
        catch (SecurityException e) {
            return false;
        }
    }

    public final boolean isVisible(Visibility v) {
        return v.isVisible(this.e);
    }

    public final boolean hasName(String name) {
        return this.getSimpleName().equals(name);
    }

    public final boolean hasName(String ... names) {
        for (String n : names) {
            if (!this.getSimpleName().equals(n)) continue;
            return true;
        }
        return false;
    }

    public final boolean hasName(Set<String> names) {
        return names.contains(this.getSimpleName());
    }

    public final String getFullName() {
        StringBuilder sb = new StringBuilder(128);
        ClassInfo dc = this.declaringClass;
        Package p = dc.getPackage();
        if (p != null) {
            sb.append(p.getName()).append('.');
        }
        dc.appendShortName(sb);
        if (!this.isConstructor) {
            sb.append('.').append(this.getSimpleName());
        }
        sb.append('(');
        List<ClassInfo> pt = this.getParamTypes();
        for (int i = 0; i < pt.size(); ++i) {
            if (i > 0) {
                sb.append(',');
            }
            pt.get(i).appendFullName(sb);
        }
        sb.append(')');
        return sb.toString();
    }

    public final String getShortName() {
        StringBuilder sb = new StringBuilder(64);
        sb.append(this.getSimpleName()).append('(');
        Class<?>[] pt = this.rawParamTypes();
        for (int i = 0; i < pt.length; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(pt[i].getSimpleName());
        }
        sb.append(')');
        return sb.toString();
    }

    public final String getSimpleName() {
        return this.isConstructor ? this.e.getDeclaringClass().getSimpleName() : this.e.getName();
    }

    public String toString() {
        return this.getShortName();
    }
}

