/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.jsonschema;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.BeanPropertyMetaExtended;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.jsonschema.SchemaUtils;
import org.apache.juneau.jsonschema.annotation.Schema;
import org.apache.juneau.parser.ParseException;

public class JsonSchemaBeanPropertyMeta
extends BeanPropertyMetaExtended {
    public static final JsonSchemaBeanPropertyMeta DEFAULT = new JsonSchemaBeanPropertyMeta();
    private final ObjectMap schema;

    public JsonSchemaBeanPropertyMeta(BeanPropertyMeta bpm) {
        super(bpm);
        this.schema = new ObjectMap();
        Field field = bpm.getInnerField();
        Method getter = bpm.getGetter();
        Method setter = bpm.getSetter();
        try {
            if (field != null) {
                this.schema.appendAll(SchemaUtils.asMap(field.getAnnotation(Schema.class)));
            }
            if (getter != null) {
                this.schema.appendAll(SchemaUtils.asMap(getter.getAnnotation(Schema.class)));
            }
            if (setter != null) {
                this.schema.appendAll(SchemaUtils.asMap(setter.getAnnotation(Schema.class)));
            }
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    private JsonSchemaBeanPropertyMeta() {
        super(null);
        this.schema = ObjectMap.EMPTY_MAP;
    }

    protected ObjectMap getSchema() {
        return this.schema;
    }
}

