/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.json;

import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.juneau.BeanMap;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.DefaultFilteringObjectMap;
import org.apache.juneau.ExecutableException;
import org.apache.juneau.ObjectList;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.internal.AsciiSet;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.json.JsonClassMeta;
import org.apache.juneau.json.JsonParser;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.parser.ParserPipe;
import org.apache.juneau.parser.ParserReader;
import org.apache.juneau.parser.ParserSession;
import org.apache.juneau.parser.ParserSessionArgs;
import org.apache.juneau.parser.ReaderParserSession;
import org.apache.juneau.transform.BuilderSwap;
import org.apache.juneau.transform.PojoSwap;

public final class JsonParserSession
extends ReaderParserSession {
    private static final AsciiSet decChars = AsciiSet.create().ranges("0-9").build();
    private final JsonParser ctx;
    private static final AsciiSet VALID_BARE_CHARS = AsciiSet.create().range('A', 'Z').range('a', 'z').range('0', '9').chars("$_-.").build();

    protected JsonParserSession(JsonParser ctx, ParserSessionArgs args) {
        super(ctx, args);
        this.ctx = ctx;
    }

    protected final boolean isWhitespace(int cp) {
        if (this.isStrict()) {
            return cp <= 32 && (cp == 9 || cp == 10 || cp == 13 || cp == 32);
        }
        return Character.isWhitespace(cp);
    }

    protected final boolean isCommentOrWhitespace(int cp) {
        if (cp == 47) {
            return true;
        }
        if (this.isStrict()) {
            return cp <= 32 && (cp == 9 || cp == 10 || cp == 13 || cp == 32);
        }
        return Character.isWhitespace(cp);
    }

    @Override
    protected <T> T doParse(ParserPipe pipe, ClassMeta<T> type) throws IOException, ParseException, ExecutableException {
        try (ParserReader r = pipe.getParserReader();){
            if (r == null) {
                T t = null;
                return t;
            }
            T o = this.parseAnything(type, r, this.getOuter(), null);
            this.validateEnd(r);
            T t = o;
            return t;
        }
    }

    @Override
    protected <K, V> Map<K, V> doParseIntoMap(ParserPipe pipe, Map<K, V> m, Type keyType, Type valueType) throws IOException, ParseException, ExecutableException {
        try (ParserReader r = pipe.getParserReader();){
            m = this.parseIntoMap2(r, m, this.getClassMeta(keyType, new Type[0]), this.getClassMeta(valueType, new Type[0]), null);
            this.validateEnd(r);
            Map<K, V> map = m;
            return map;
        }
    }

    @Override
    protected <E> Collection<E> doParseIntoCollection(ParserPipe pipe, Collection<E> c, Type elementType) throws IOException, ParseException, ExecutableException {
        try (ParserReader r = pipe.getParserReader();){
            c = this.parseIntoCollection2(r, c, this.getClassMeta(elementType, new Type[0]), null);
            this.validateEnd(r);
            Collection<E> collection = c;
            return collection;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private <T> T parseAnything(ClassMeta<?> eType, ParserReader r, Object outer, BeanPropertyMeta pMeta) throws IOException, ParseException, ExecutableException {
        int c;
        if (eType == null) {
            eType = this.object();
        }
        PojoSwap<Object, ?> swap = eType.getPojoSwap(this);
        BuilderSwap<Object, Object> builder = eType.getBuilderSwap(this);
        ClassMeta<Object> sType = null;
        sType = builder != null ? builder.getBuilderClassMeta(this) : (swap != null ? swap.getSwapClassMeta(this) : eType);
        this.setCurrentClass(sType);
        String wrapperAttr = sType.getExtendedMeta(JsonClassMeta.class).getWrapperAttr();
        Object o = null;
        this.skipCommentsAndSpace(r);
        if (wrapperAttr != null) {
            this.skipWrapperAttrStart(r, wrapperAttr);
        }
        if ((c = r.peek()) == -1) {
            if (this.isStrict()) {
                throw new ParseException((ParserSession)this, "Empty input.", new Object[0]);
            }
        } else if (c == 44 || c == 125 || c == 93) {
            if (this.isStrict()) {
                throw new ParseException((ParserSession)this, "Missing value detected.", new Object[0]);
            }
        } else if (c == 110) {
            this.parseKeyword("null", r);
        } else if (sType.isObject()) {
            if (c == 123) {
                ObjectMap objectMap = new ObjectMap(this);
                this.parseIntoMap2(r, objectMap, this.string(), this.object(), pMeta);
                o = this.cast(objectMap, pMeta, eType);
            } else if (c == 91) {
                o = this.parseIntoCollection2(r, new ObjectList(this), this.object(), pMeta);
            } else if (c == 39 || c == 34) {
                o = this.parseString(r);
                if (sType.isChar()) {
                    o = StringUtils.parseCharacter(o);
                }
            } else if (c >= 48 && c <= 57 || c == 45 || c == 46) {
                o = this.parseNumber(r, null);
            } else if (c == 116) {
                this.parseKeyword("true", r);
                o = Boolean.TRUE;
            } else {
                this.parseKeyword("false", r);
                o = Boolean.FALSE;
            }
        } else if (sType.isBoolean()) {
            o = this.parseBoolean(r);
        } else if (sType.isCharSequence()) {
            o = this.parseString(r);
        } else if (sType.isChar()) {
            o = StringUtils.parseCharacter(this.parseString(r));
        } else if (sType.isNumber()) {
            o = this.parseNumber(r, sType.getInnerClass());
        } else if (sType.isMap()) {
            Map<String, Object> map = sType.canCreateNewInstance(outer) ? (Map)sType.newInstance(outer) : new ObjectMap(this);
            o = this.parseIntoMap2(r, map, sType.getKeyType(), sType.getValueType(), pMeta);
        } else if (sType.isCollection()) {
            if (c == 123) {
                ObjectMap objectMap = new ObjectMap(this);
                this.parseIntoMap2(r, objectMap, this.string(), this.object(), pMeta);
                o = this.cast(objectMap, pMeta, eType);
            } else {
                Collection<Object> collection = sType.canCreateNewInstance(outer) ? (Collection)sType.newInstance() : new ObjectList(this);
                o = this.parseIntoCollection2(r, collection, sType, pMeta);
            }
        } else if (builder != null) {
            BeanMap<?> beanMap = this.toBeanMap(builder.create(this, eType));
            o = builder.build(this, this.parseIntoBeanMap2(r, beanMap).getBean(), eType);
        } else if (sType.canCreateNewBean(outer)) {
            BeanMap<Object> beanMap = this.newBeanMap(outer, sType.getInnerClass());
            o = this.parseIntoBeanMap2(r, beanMap).getBean();
        } else if (sType.canCreateNewInstanceFromString(outer) && (c == 39 || c == 34)) {
            o = sType.newInstanceFromString(outer, this.parseString(r));
        } else if (sType.isArray() || sType.isArgs()) {
            if (c == 123) {
                ObjectMap objectMap = new ObjectMap(this);
                this.parseIntoMap2(r, objectMap, this.string(), this.object(), pMeta);
                o = this.cast(objectMap, pMeta, eType);
            } else {
                ArrayList arrayList = (ArrayList)this.parseIntoCollection2(r, new ArrayList(), sType, pMeta);
                o = this.toArray(sType, arrayList);
            }
        } else if (c == 123) {
            ObjectMap objectMap = new ObjectMap(this);
            this.parseIntoMap2(r, objectMap, sType.getKeyType(), sType.getValueType(), pMeta);
            if (!objectMap.containsKey(this.getBeanTypePropertyName(eType))) throw new ParseException((ParserSession)this, "Class ''{0}'' could not be instantiated.  Reason: ''{1}''", sType.getInnerClass().getName(), sType.getNotABeanReason());
            o = this.cast(objectMap, pMeta, eType);
        } else {
            if (!sType.canCreateNewInstanceFromString(outer) || this.isStrict()) throw new ParseException((ParserSession)this, "Unrecognized syntax for class type ''{0}'', starting character ''{1}''", sType, Character.valueOf((char)c));
            o = sType.newInstanceFromString(outer, this.parseString(r));
        }
        if (wrapperAttr != null) {
            this.skipWrapperAttrEnd(r);
        }
        if (swap != null && o != null) {
            o = this.unswap(swap, o, eType);
        }
        if (outer == null) return (T)o;
        JsonParserSession.setParent(eType, o, outer);
        return (T)o;
    }

    private Number parseNumber(ParserReader r, Class<? extends Number> type) throws IOException, ParseException {
        int c = r.peek();
        if (c == 39 || c == 34) {
            return this.parseNumber(r, this.parseString(r), type);
        }
        return this.parseNumber(r, StringUtils.parseNumberString(r), type);
    }

    private Number parseNumber(ParserReader r, String s, Class<? extends Number> type) throws ParseException {
        if (this.isStrict()) {
            char c2;
            if (s.length() == 0) {
                throw new ParseException((ParserSession)this, "Invalid JSON number: ''{0}''", s);
            }
            boolean isNegative = false;
            int c = s.charAt(0);
            if (c == 45) {
                isNegative = true;
                int n = c = s.length() == 1 ? 120 : (int)s.charAt(1);
            }
            if (c == 46) {
                throw new ParseException((ParserSession)this, "Invalid JSON number: ''{0}''", s);
            }
            if (c == 48 && s.length() > (isNegative ? 2 : 1) && (c2 = s.charAt(isNegative ? 2 : 1)) != '.' && c2 != 'e' && c2 != 'E') {
                throw new ParseException((ParserSession)this, "Invalid JSON number: ''{0}''", s);
            }
            int i = s.indexOf(46);
            if (!(i == -1 || s.length() != i + 1 && decChars.contains(s.charAt(i + 1)))) {
                throw new ParseException((ParserSession)this, "Invalid JSON number: ''{0}''", s);
            }
        }
        return StringUtils.parseNumber(s, type);
    }

    private Boolean parseBoolean(ParserReader r) throws IOException, ParseException {
        int c = r.peek();
        if (c == 39 || c == 34) {
            return Boolean.valueOf(this.parseString(r));
        }
        if (c == 116) {
            this.parseKeyword("true", r);
            return Boolean.TRUE;
        }
        if (c == 102) {
            this.parseKeyword("false", r);
            return Boolean.FALSE;
        }
        throw new ParseException((ParserSession)this, "Unrecognized syntax.  Expected boolean value, actual=''{0}''", r.read(100));
    }

    private <K, V> Map<K, V> parseIntoMap2(ParserReader r, Map<K, V> m, ClassMeta<K> keyType, ClassMeta<V> valueType, BeanPropertyMeta pMeta) throws IOException, ParseException, ExecutableException {
        if (keyType == null) {
            keyType = this.string();
        }
        int S0 = 0;
        int S1 = 1;
        int S3 = 3;
        int S4 = 4;
        int S5 = 5;
        int S6 = 6;
        this.skipCommentsAndSpace(r);
        int state = S0;
        String currAttr = null;
        int c = 0;
        while (c != -1) {
            c = r.read();
            if (state == S0) {
                if (c != 123) break;
                state = S1;
                continue;
            }
            if (state == S1) {
                if (c == 125) {
                    return m;
                }
                if (this.isCommentOrWhitespace(c)) {
                    this.skipCommentsAndSpace(r.unread());
                    continue;
                }
                currAttr = this.parseFieldName(r.unread());
                state = S3;
                continue;
            }
            if (state == S3) {
                if (c != 58) continue;
                state = S4;
                continue;
            }
            if (state == S4) {
                if (this.isCommentOrWhitespace(c)) {
                    this.skipCommentsAndSpace(r.unread());
                    continue;
                }
                K key = this.convertAttrToType(m, currAttr, keyType);
                Object value = this.parseAnything(valueType, r.unread(), m, pMeta);
                JsonParserSession.setName(valueType, value, key);
                m.put(key, value);
                state = S5;
                continue;
            }
            if (state == S5) {
                if (c == 44) {
                    state = S6;
                    continue;
                }
                if (this.isCommentOrWhitespace(c)) {
                    this.skipCommentsAndSpace(r.unread());
                    continue;
                }
                if (c != 125) break;
                return m;
            }
            if (state != S6) continue;
            if (c == 125) break;
            if (this.isCommentOrWhitespace(c)) {
                this.skipCommentsAndSpace(r.unread());
                continue;
            }
            currAttr = this.parseFieldName(r.unread());
            state = S3;
        }
        if (state == S0) {
            throw new ParseException((ParserSession)this, "Expected '{' at beginning of JSON object.", new Object[0]);
        }
        if (state == S1) {
            throw new ParseException((ParserSession)this, "Could not find attribute name on JSON object.", new Object[0]);
        }
        if (state == S3) {
            throw new ParseException((ParserSession)this, "Could not find ':' following attribute name on JSON object.", new Object[0]);
        }
        if (state == S4) {
            throw new ParseException((ParserSession)this, "Expected one of the following characters: {,[,',\",LITERAL.", new Object[0]);
        }
        if (state == S5) {
            throw new ParseException((ParserSession)this, "Could not find '}' marking end of JSON object.", new Object[0]);
        }
        if (state == S6) {
            throw new ParseException((ParserSession)this, "Unexpected '}' found in JSON object.", new Object[0]);
        }
        return null;
    }

    private String parseFieldName(ParserReader r) throws IOException, ParseException {
        int c = r.peek();
        if (c == 39 || c == 34) {
            return this.parseString(r);
        }
        if (this.isStrict()) {
            throw new ParseException((ParserSession)this, "Unquoted attribute detected.", new Object[0]);
        }
        if (!VALID_BARE_CHARS.contains(c)) {
            throw new ParseException((ParserSession)this, "Could not find the start of the field name.", new Object[0]);
        }
        r.mark();
        while (c != -1) {
            c = r.read();
            if (VALID_BARE_CHARS.contains(c)) continue;
            r.unread();
            String s = r.getMarked().intern();
            return s.equals("null") ? null : s;
        }
        throw new ParseException((ParserSession)this, "Could not find the end of the field name.", new Object[0]);
    }

    private <E> Collection<E> parseIntoCollection2(ParserReader r, Collection<E> l, ClassMeta<?> type, BeanPropertyMeta pMeta) throws IOException, ParseException, ExecutableException {
        int S0 = 0;
        int S1 = 1;
        int S2 = 2;
        int S3 = 3;
        int argIndex = 0;
        int state = S0;
        int c = 0;
        while (c != -1) {
            c = r.read();
            if (state == S0) {
                if (c == 91) {
                    state = S1;
                    continue;
                }
                if (!this.isCommentOrWhitespace(c)) break;
                this.skipCommentsAndSpace(r.unread());
                continue;
            }
            if (state == S1) {
                if (c == 93) {
                    return l;
                }
                if (this.isCommentOrWhitespace(c)) {
                    this.skipCommentsAndSpace(r.unread());
                    continue;
                }
                if (c == -1) continue;
                l.add(this.parseAnything(type.isArgs() ? type.getArg(argIndex++) : type.getElementType(), r.unread(), l, pMeta));
                state = S2;
                continue;
            }
            if (state == S2) {
                if (c == 44) {
                    state = S3;
                    continue;
                }
                if (this.isCommentOrWhitespace(c)) {
                    this.skipCommentsAndSpace(r.unread());
                    continue;
                }
                if (c != 93) break;
                return l;
            }
            if (state != S3) continue;
            if (this.isCommentOrWhitespace(c)) {
                this.skipCommentsAndSpace(r.unread());
                continue;
            }
            if (c == 93) break;
            if (c == -1) continue;
            l.add(this.parseAnything(type.isArgs() ? type.getArg(argIndex++) : type.getElementType(), r.unread(), l, pMeta));
            state = S2;
        }
        if (state == S0) {
            throw new ParseException((ParserSession)this, "Expected '[' at beginning of JSON array.", new Object[0]);
        }
        if (state == S1) {
            throw new ParseException((ParserSession)this, "Expected one of the following characters: {,[,',\",LITERAL.", new Object[0]);
        }
        if (state == S2) {
            throw new ParseException((ParserSession)this, "Expected ',' or ']'.", new Object[0]);
        }
        if (state == S3) {
            throw new ParseException((ParserSession)this, "Unexpected trailing comma in array.", new Object[0]);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> BeanMap<T> parseIntoBeanMap2(ParserReader r, BeanMap<T> m) throws IOException, ParseException, ExecutableException {
        int S0 = 0;
        int S1 = 1;
        int S3 = 3;
        int S4 = 4;
        int S5 = 5;
        int state = S0;
        String currAttr = "";
        int c = 0;
        this.mark();
        try {
            while (c != -1) {
                BeanMap<T> beanMap;
                c = r.read();
                if (state == S0) {
                    if (c == 123) {
                        state = S1;
                        continue;
                    }
                    if (!this.isCommentOrWhitespace(c)) break;
                    this.skipCommentsAndSpace(r.unread());
                    continue;
                }
                if (state == S1) {
                    if (c == 125) {
                        beanMap = m;
                        return beanMap;
                    }
                    if (this.isCommentOrWhitespace(c)) {
                        this.skipCommentsAndSpace(r.unread());
                        continue;
                    }
                    r.unread();
                    this.mark();
                    currAttr = this.parseFieldName(r);
                    state = S3;
                    continue;
                }
                if (state == S3) {
                    if (c != 58) continue;
                    state = S4;
                    continue;
                }
                if (state == S4) {
                    if (this.isCommentOrWhitespace(c)) {
                        this.skipCommentsAndSpace(r.unread());
                        continue;
                    }
                    if (!currAttr.equals(this.getBeanTypePropertyName(m.getClassMeta()))) {
                        BeanPropertyMeta pMeta = m.getPropertyMeta(currAttr);
                        this.setCurrentProperty(pMeta);
                        if (pMeta == null) {
                            this.onUnknownProperty(currAttr, m);
                            this.unmark();
                            this.parseAnything(this.object(), r.unread(), m.getBean(false), null);
                        } else {
                            this.unmark();
                            ClassMeta<?> cm = pMeta.getClassMeta();
                            T value = this.parseAnything(cm, r.unread(), m.getBean(false), pMeta);
                            JsonParserSession.setName(cm, value, currAttr);
                            pMeta.set(m, currAttr, value);
                        }
                        this.setCurrentProperty(null);
                    }
                    state = S5;
                    continue;
                }
                if (state != S5) continue;
                if (c == 44) {
                    state = S1;
                    continue;
                }
                if (this.isCommentOrWhitespace(c)) {
                    this.skipCommentsAndSpace(r.unread());
                    continue;
                }
                if (c != 125) continue;
                beanMap = m;
                return beanMap;
            }
            if (state == S0) {
                throw new ParseException((ParserSession)this, "Expected '{' at beginning of JSON object.", new Object[0]);
            }
            if (state == S1) {
                throw new ParseException((ParserSession)this, "Could not find attribute name on JSON object.", new Object[0]);
            }
            if (state == S3) {
                throw new ParseException((ParserSession)this, "Could not find ':' following attribute name on JSON object.", new Object[0]);
            }
            if (state == S4) {
                throw new ParseException((ParserSession)this, "Expected one of the following characters: {,[,',\",LITERAL.", new Object[0]);
            }
            if (state == S5) {
                throw new ParseException((ParserSession)this, "Could not find '}' marking end of JSON object.", new Object[0]);
            }
        }
        finally {
            this.unmark();
        }
        return null;
    }

    private String parseString(ParserReader r) throws IOException, ParseException {
        r.mark();
        int qc = r.read();
        if (qc != 34 && this.isStrict()) {
            String msg = qc == 39 ? "Invalid quote character \"{0}\" being used." : "Did not find quote character marking beginning of string.  Character=\"{0}\"";
            throw new ParseException((ParserSession)this, msg, Character.valueOf((char)qc));
        }
        boolean isQuoted = qc == 39 || qc == 34;
        String s = null;
        boolean isInEscape = false;
        int c = 0;
        while (c != -1) {
            c = r.read();
            if (this.isStrict() && c <= 31) {
                throw new ParseException((ParserSession)this, "Unescaped control character encountered: ''0x{0}''", String.format("%04X", c));
            }
            if (isInEscape) {
                switch (c) {
                    case 110: {
                        r.replace('\n');
                        break;
                    }
                    case 114: {
                        r.replace('\r');
                        break;
                    }
                    case 116: {
                        r.replace('\t');
                        break;
                    }
                    case 102: {
                        r.replace('\f');
                        break;
                    }
                    case 98: {
                        r.replace('\b');
                        break;
                    }
                    case 92: {
                        r.replace('\\');
                        break;
                    }
                    case 47: {
                        r.replace('/');
                        break;
                    }
                    case 39: {
                        r.replace('\'');
                        break;
                    }
                    case 34: {
                        r.replace('\"');
                        break;
                    }
                    case 117: {
                        String n = r.read(4);
                        try {
                            r.replace(Integer.parseInt(n, 16), 6);
                            break;
                        }
                        catch (NumberFormatException e) {
                            throw new ParseException((ParserSession)this, "Invalid Unicode escape sequence in string.", new Object[0]);
                        }
                    }
                    default: {
                        throw new ParseException((ParserSession)this, "Invalid escape sequence in string.", new Object[0]);
                    }
                }
                isInEscape = false;
                continue;
            }
            if (c == 92) {
                isInEscape = true;
                r.delete();
                continue;
            }
            if (isQuoted) {
                if (c != qc) continue;
                s = r.getMarked(1, -1);
                break;
            }
            if (c == 44 || c == 125 || c == 93 || this.isWhitespace(c)) {
                s = r.getMarked(0, -1);
                r.unread();
                break;
            }
            if (c != -1) continue;
            s = r.getMarked(0, 0);
            break;
        }
        if (s == null) {
            throw new ParseException((ParserSession)this, "Could not find expected end character ''{0}''.", Character.valueOf((char)qc));
        }
        this.skipCommentsAndSpace(r);
        if (r.peek() == 43) {
            if (this.isStrict()) {
                throw new ParseException((ParserSession)this, "String concatenation detected.", new Object[0]);
            }
            r.read();
            this.skipCommentsAndSpace(r);
            s = s + this.parseString(r);
        }
        return this.trim(s);
    }

    private void parseKeyword(String keyword, ParserReader r) throws IOException, ParseException {
        try {
            String s = r.read(keyword.length());
            if (s.equals(keyword)) {
                return;
            }
            throw new ParseException((ParserSession)this, "Unrecognized syntax.  Expected=''{0}'', Actual=''{1}''", keyword, s);
        }
        catch (IndexOutOfBoundsException e) {
            throw new ParseException((ParserSession)this, "Unrecognized syntax.  Expected=''{0}'', found end-of-file.", keyword);
        }
    }

    private void skipCommentsAndSpace(ParserReader r) throws IOException, ParseException {
        int c = 0;
        while ((c = r.read()) != -1) {
            if (this.isWhitespace(c)) continue;
            if (c == 47) {
                if (this.isStrict()) {
                    throw new ParseException((ParserSession)this, "Javascript comment detected.", new Object[0]);
                }
                this.skipComments(r);
                continue;
            }
            r.unread();
            return;
        }
    }

    private void skipWrapperAttrStart(ParserReader r, String wrapperAttr) throws IOException, ParseException {
        int S0 = 0;
        int S1 = 1;
        int S3 = 3;
        int S4 = 4;
        int state = S0;
        String currAttr = null;
        int c = 0;
        while (c != -1) {
            c = r.read();
            if (state == S0) {
                if (c != 123) continue;
                state = S1;
                continue;
            }
            if (state == S1) {
                if (this.isCommentOrWhitespace(c)) {
                    this.skipCommentsAndSpace(r.unread());
                    continue;
                }
                currAttr = this.parseFieldName(r.unread());
                if (!currAttr.equals(wrapperAttr)) {
                    throw new ParseException((ParserSession)this, "Expected to find wrapper attribute ''{0}'' but found attribute ''{1}''", wrapperAttr, currAttr);
                }
                state = S3;
                continue;
            }
            if (state == S3) {
                if (c != 58) continue;
                state = S4;
                continue;
            }
            if (state != S4) continue;
            if (this.isCommentOrWhitespace(c)) {
                this.skipCommentsAndSpace(r.unread());
                continue;
            }
            r.unread();
            return;
        }
        if (state == S0) {
            throw new ParseException((ParserSession)this, "Expected '{' at beginning of JSON object.", new Object[0]);
        }
        if (state == S1) {
            throw new ParseException((ParserSession)this, "Could not find attribute name on JSON object.", new Object[0]);
        }
        if (state == S3) {
            throw new ParseException((ParserSession)this, "Could not find ':' following attribute name on JSON object.", new Object[0]);
        }
        if (state == S4) {
            throw new ParseException((ParserSession)this, "Expected one of the following characters: {,[,',\",LITERAL.", new Object[0]);
        }
    }

    private void skipWrapperAttrEnd(ParserReader r) throws ParseException, IOException {
        int c = 0;
        while ((c = r.read()) != -1) {
            if (this.isWhitespace(c)) continue;
            if (c == 47) {
                if (this.isStrict()) {
                    throw new ParseException((ParserSession)this, "Javascript comment detected.", new Object[0]);
                }
                this.skipComments(r);
                continue;
            }
            if (c == 125) {
                return;
            }
            throw new ParseException((ParserSession)this, "Could not find '}' at the end of JSON wrapper object.", new Object[0]);
        }
    }

    private void skipComments(ParserReader r) throws ParseException, IOException {
        block3: {
            int c;
            block2: {
                c = r.read();
                if (c != 42) break block2;
                while (c != -1) {
                    c = r.read();
                    if (c != 42 || (c = r.read()) != 47) continue;
                    return;
                }
                break block3;
            }
            if (c != 47) break block3;
            while (c != -1) {
                c = r.read();
                if (c != -1 && c != 10) continue;
                return;
            }
        }
        throw new ParseException((ParserSession)this, "Open ended comment.", new Object[0]);
    }

    private void validateEnd(ParserReader r) throws IOException, ParseException {
        if (!this.isValidateEnd()) {
            return;
        }
        this.skipCommentsAndSpace(r);
        int c = r.read();
        if (c != -1 && c != 59) {
            throw new ParseException((ParserSession)this, "Remainder after parse: ''{0}''.", Character.valueOf((char)c));
        }
    }

    protected final boolean isValidateEnd() {
        return this.ctx.isValidateEnd();
    }

    @Override
    public ObjectMap toMap() {
        return super.toMap().append("JsonParserSession", new DefaultFilteringObjectMap());
    }
}

