/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.internal;

import java.beans.Introspector;
import java.lang.reflect.Method;
import org.apache.juneau.internal.ClassUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.reflect.ClassInfo;

public class HttpUtils {
    public static String detectHttpMethod(Method m, boolean detectMethod, String def) {
        String n = m.getName();
        if (detectMethod) {
            String n2;
            if (n.startsWith("do") && n.length() > 2 && StringUtils.isOneOf(n2 = n.substring(2).toUpperCase(), "GET", "PUT", "POST", "DELETE", "OPTIONS", "HEAD", "CONNECT", "TRACE", "PATCH")) {
                return n2;
            }
            for (String t : new String[]{"get", "put", "post", "delete", "options", "head", "connect", "trace", "patch"}) {
                if (!n.startsWith(t) || n.length() != t.length() && !Character.isUpperCase(n.charAt(t.length()))) continue;
                return t.toUpperCase();
            }
        }
        return def;
    }

    public static String detectHttpPath(Method m, boolean detectMethod) {
        String n = m.getName();
        if (detectMethod) {
            String n2;
            if (n.startsWith("do") && n.length() > 2 && StringUtils.isOneOf(n2 = n.substring(2).toUpperCase(), "GET", "PUT", "POST", "DELETE", "OPTIONS", "HEAD", "CONNECT", "TRACE", "PATCH")) {
                return "/";
            }
            for (String t : new String[]{"get", "put", "post", "delete", "options", "head", "connect", "trace", "patch"}) {
                if (!n.startsWith(t) || n.length() != t.length() && !Character.isUpperCase(n.charAt(t.length()))) continue;
                return '/' + Introspector.decapitalize(n.substring(t.length()));
            }
        }
        return '/' + n;
    }

    public static String getMethodArgsSignature(Method m, boolean full) {
        StringBuilder sb = new StringBuilder(128);
        Class<?>[] pt = m.getParameterTypes();
        if (pt.length == 0) {
            return "";
        }
        sb.append('(');
        for (int i = 0; i < pt.length; ++i) {
            ClassInfo pti = ClassUtils.getClassInfo(pt[i]);
            if (i > 0) {
                sb.append(',');
            }
            if (full) {
                pti.appendFullName(sb);
                continue;
            }
            pti.appendShortName(sb);
        }
        sb.append(')');
        return sb.toString();
    }
}

