/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.internal;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import org.apache.juneau.FormattedRuntimeException;
import org.apache.juneau.ObjectList;
import org.apache.juneau.reflect.ClassInfo;
import org.apache.juneau.reflect.ConstructorInfo;
import org.apache.juneau.reflect.FieldInfo;
import org.apache.juneau.reflect.MethodInfo;
import org.apache.juneau.reflect.Mutater;
import org.apache.juneau.reflect.Mutaters;
import org.apache.juneau.utils.AList;

public final class ClassUtils {
    public static ClassInfo getClassInfo(Type t) {
        return ClassInfo.of(t);
    }

    public static ClassInfo getClassInfo(Object o) {
        return ClassInfo.of(o);
    }

    public static MethodInfo getMethodInfo(Method m) {
        return MethodInfo.of(m);
    }

    public static MethodInfo getMethodInfo(Class<?> c, Method m) {
        return MethodInfo.of(ClassInfo.of(c), m);
    }

    public static FieldInfo getFieldInfo(Field f) {
        return FieldInfo.of(f);
    }

    public static ConstructorInfo getConstructorInfo(Constructor<?> c) {
        return ConstructorInfo.of(c);
    }

    public static ObjectList getFullClassNames(Object[] o) {
        ObjectList l = new ObjectList();
        for (int i = 0; i < o.length; ++i) {
            l.add(o[i] == null ? "null" : ClassInfo.of(o[i].getClass()).getFullName());
        }
        return l;
    }

    public static boolean argsMatch(Class<?>[] paramTypes, Class<?>[] argTypes) {
        if (paramTypes.length == argTypes.length) {
            for (int i = 0; i < paramTypes.length; ++i) {
                if (ClassUtils.getClassInfo(paramTypes[i]).isParentOf(argTypes[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean argsMatch(List<ClassInfo> paramTypes, Class<?>[] argTypes) {
        if (paramTypes.size() == argTypes.length) {
            for (int i = 0; i < paramTypes.size(); ++i) {
                if (paramTypes.get(i).isParentOf(argTypes[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static int fuzzyArgsMatch(Class<?>[] paramTypes, Class<?> ... argTypes) {
        int matches = 0;
        block0: for (Class<?> p : paramTypes) {
            ClassInfo pi = ClassUtils.getClassInfo(p).getWrapperInfoIfPrimitive();
            for (Class<?> a : argTypes) {
                ClassInfo ai = ClassUtils.getClassInfo(a).getWrapperInfoIfPrimitive();
                if (!pi.isParentOf(ai.inner())) continue;
                ++matches;
                continue block0;
            }
            return -1;
        }
        return matches;
    }

    public static int fuzzyArgsMatch(Class<?>[] paramTypes, ClassInfo ... argTypes) {
        int matches = 0;
        block0: for (Class<?> p : paramTypes) {
            ClassInfo pi = ClassUtils.getClassInfo(p).getWrapperInfoIfPrimitive();
            for (ClassInfo a : argTypes) {
                ClassInfo ai = a.getWrapperInfoIfPrimitive();
                if (!pi.isParentOf(ai.inner())) continue;
                ++matches;
                continue block0;
            }
            return -1;
        }
        return matches;
    }

    public static int fuzzyArgsMatch(List<ClassInfo> paramTypes, Class<?> ... argTypes) {
        int matches = 0;
        block0: for (ClassInfo p : paramTypes) {
            p = p.getWrapperInfoIfPrimitive();
            for (Class<?> a : argTypes) {
                if (!p.isParentOf(a)) continue;
                ++matches;
                continue block0;
            }
            return -1;
        }
        return matches;
    }

    public static Class<?>[] getClasses(Object ... args) {
        Class[] pt = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            pt[i] = args[i] == null ? null : args[i].getClass();
        }
        return pt;
    }

    public static <T> T castOrCreate(Class<T> c, Object c2) {
        return ClassUtils.castOrCreateFromOuter(null, c, c2, false, new Object[0]);
    }

    public static <T> T castOrCreate(Class<T> c, Object c2, boolean fuzzyArgs, Object ... args) {
        return ClassUtils.castOrCreateFromOuter(null, c, c2, fuzzyArgs, args);
    }

    public static <T> T castOrCreateFromOuter(Object outer, Class<T> c, Object c2, boolean fuzzyArgs, Object ... args) {
        if (c2 == null) {
            return null;
        }
        if (c2 instanceof Class) {
            try {
                ClassInfo c3 = ClassUtils.getClassInfo((Class)c2);
                if (c3.isInterface() || c3.isAbstract()) {
                    return null;
                }
                ConstructorInfo con = c3.getPublicConstructor(args);
                if (con != null) {
                    return con.invoke(args);
                }
                if (outer != null && (con = c3.getPublicConstructor(args = new AList<Object>().append(outer).appendAll((Object[])args).toArray())) != null) {
                    return con.invoke(args);
                }
                if (fuzzyArgs && (con = c3.getPublicConstructorFuzzy(args)) != null) {
                    return con.invoke(ClassUtils.getMatchingArgs(con.getParamTypes(), args));
                }
                throw new FormattedRuntimeException("Could not instantiate class {0}/{1}.  Constructor not found.", c.getName(), c2);
            }
            catch (Exception e) {
                throw new FormattedRuntimeException(e, "Could not instantiate class {0}", c.getName());
            }
        }
        if (ClassUtils.getClassInfo(c).isParentOf(c2.getClass())) {
            return (T)c2;
        }
        throw new FormattedRuntimeException("Object of type {0} found but was expecting {1}.", c2.getClass(), c.getClass());
    }

    public static Object[] getMatchingArgs(Class<?>[] paramTypes, Object ... args) {
        Object[] params = new Object[paramTypes.length];
        block0: for (int i = 0; i < paramTypes.length; ++i) {
            ClassInfo pt = ClassUtils.getClassInfo(paramTypes[i]).getWrapperInfoIfPrimitive();
            for (int j = 0; j < args.length; ++j) {
                if (args[j] == null || !pt.isParentOf(args[j].getClass())) continue;
                params[i] = args[j];
                continue block0;
            }
        }
        return params;
    }

    public static Object[] getMatchingArgs(List<ClassInfo> paramTypes, Object ... args) {
        Object[] params = new Object[paramTypes.size()];
        block0: for (int i = 0; i < paramTypes.size(); ++i) {
            ClassInfo pt = paramTypes.get(i).getWrapperInfoIfPrimitive();
            for (int j = 0; j < args.length; ++j) {
                if (!pt.isParentOf(args[j].getClass())) continue;
                params[i] = args[j];
                continue block0;
            }
        }
        return params;
    }

    public static <T> T fromString(Class<T> c, String s) {
        Mutater<String, T> t = Mutaters.get(String.class, c);
        return t == null ? null : (T)t.mutate(s);
    }

    public static String toString(Object o) {
        if (o == null) {
            return null;
        }
        Mutater<?, String> t = Mutaters.get(o.getClass(), String.class);
        return t == null ? o.toString() : t.mutate(o);
    }

    public static boolean setAccessible(Constructor<?> x) {
        try {
            if (x != null && !x.isAccessible()) {
                x.setAccessible(true);
            }
            return true;
        }
        catch (SecurityException e) {
            return false;
        }
    }

    public static boolean setAccessible(Method x) {
        try {
            if (x != null && !x.isAccessible()) {
                x.setAccessible(true);
            }
            return true;
        }
        catch (SecurityException e) {
            return false;
        }
    }

    public static boolean setAccessible(Field x) {
        try {
            if (x != null && !x.isAccessible()) {
                x.setAccessible(true);
            }
            return true;
        }
        catch (SecurityException e) {
            return false;
        }
    }

    public static Class<?> toClass(Type t) {
        if (t instanceof Class) {
            return (Class)t;
        }
        if (t instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)t;
            return (Class)pt.getRawType();
        }
        return null;
    }
}

