/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau;

import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.juneau.BeanContext;
import org.apache.juneau.BeanRuntimeException;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.annotation.Bean;
import org.apache.juneau.internal.ClassUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.reflect.ClassInfo;

public class BeanRegistry {
    private final Map<String, ClassMeta<?>> map;
    private final Map<Class<?>, String> reverseMap;
    private final BeanContext beanContext;
    private final boolean isEmpty;

    BeanRegistry(BeanContext beanContext, BeanRegistry parent, Class<?> ... classes) {
        this.beanContext = beanContext;
        this.map = new ConcurrentHashMap();
        this.reverseMap = new ConcurrentHashMap();
        for (Class<?> clazz : beanContext.getBeanDictionaryClasses()) {
            this.addClass(clazz);
        }
        if (parent != null) {
            for (Map.Entry entry : parent.map.entrySet()) {
                this.addToMap((String)entry.getKey(), (ClassMeta)entry.getValue());
            }
        }
        for (Class<?> c : classes) {
            this.addClass(c);
        }
        this.isEmpty = this.map.isEmpty();
    }

    private void addClass(Class<?> c) {
        try {
            if (c != null) {
                ClassInfo ci = ClassUtils.getClassInfo(c);
                if (ci.isChildOf(Collection.class)) {
                    Collection cc = ClassUtils.castOrCreate(Collection.class, c);
                    for (Object o : cc) {
                        if (o instanceof Class) {
                            this.addClass((Class)o);
                            continue;
                        }
                        throw new BeanRuntimeException("Collection class ''{0}'' passed to BeanRegistry does not contain Class objects.", c.getName());
                    }
                } else if (ci.isChildOf(Map.class)) {
                    Map m = ClassUtils.castOrCreate(Map.class, c);
                    for (Map.Entry e : m.entrySet()) {
                        String typeName = StringUtils.stringify(e.getKey());
                        Object v = e.getValue();
                        ClassMeta<Object> val = null;
                        if (v instanceof Type) {
                            val = this.beanContext.getClassMeta((Type)v, new Type[0]);
                        } else if (v.getClass().isArray()) {
                            val = this.getTypedClassMeta(v);
                        } else {
                            throw new BeanRuntimeException("Class ''{0}'' was passed to BeanRegistry but value of type ''{1}'' found in map is not a Type object.", c.getName(), v.getClass().getName());
                        }
                        this.addToMap(typeName, val);
                    }
                } else {
                    Bean b = c.getAnnotation(Bean.class);
                    if (b == null || b.typeName().isEmpty()) {
                        throw new BeanRuntimeException("Class ''{0}'' was passed to BeanRegistry but it doesn't have a @Bean(typeName) annotation defined.", c.getName());
                    }
                    this.addToMap(b.typeName(), this.beanContext.getClassMeta(c));
                }
            }
        }
        catch (BeanRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BeanRuntimeException(e);
        }
    }

    private ClassMeta<?> getTypedClassMeta(Object array) {
        int len = Array.getLength(array);
        if (len == 0) {
            throw new BeanRuntimeException("Map entry had an empty array value.");
        }
        Type type = (Type)Array.get(array, 0);
        Type[] args = new Type[len - 1];
        for (int i = 1; i < len; ++i) {
            args[i - 1] = (Type)Array.get(array, i);
        }
        return this.beanContext.getClassMeta(type, args);
    }

    private void addToMap(String typeName, ClassMeta<?> cm) {
        this.map.put(typeName, cm);
        this.reverseMap.put(cm.innerClass, typeName);
    }

    public ClassMeta<?> getClassMeta(String typeName) {
        if (this.isEmpty) {
            return null;
        }
        if (typeName == null) {
            return null;
        }
        ClassMeta<?> cm = this.map.get(typeName);
        if (cm != null) {
            return cm;
        }
        if (typeName.charAt(typeName.length() - 1) == '^') {
            cm = this.getClassMeta(typeName.substring(0, typeName.length() - 1));
            if (cm != null) {
                cm = this.beanContext.getClassMeta(Array.newInstance(cm.innerClass, 1).getClass());
                this.map.put(typeName, cm);
            }
            return cm;
        }
        return null;
    }

    public String getTypeName(ClassMeta<?> c) {
        if (this.isEmpty) {
            return null;
        }
        return this.reverseMap.get(c.innerClass);
    }

    public boolean hasName(String typeName) {
        return this.getClassMeta(typeName) != null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        for (Map.Entry<String, ClassMeta<?>> e : this.map.entrySet()) {
            sb.append(e.getKey()).append(":").append(e.getValue().toString(true)).append(", ");
        }
        sb.append('}');
        return sb.toString();
    }
}

