/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.juneau.FormattedRuntimeException;
import org.apache.juneau.internal.ArrayUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.json.JsonParser;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.parser.ParserPipe;
import org.apache.juneau.rest.Inherit;
import org.apache.juneau.rest.None;
import org.apache.juneau.uon.UonReader;
import org.apache.juneau.utils.AMap;

public final class RestUtils {
    private static Map<Integer, String> httpMsgs = new AMap().append((Object)100, (Object)"Continue").append((Object)101, (Object)"Switching Protocols").append((Object)102, (Object)"Processing").append((Object)103, (Object)"Early Hints").append((Object)200, (Object)"OK").append((Object)201, (Object)"Created").append((Object)202, (Object)"Accepted").append((Object)203, (Object)"Non-Authoritative Information").append((Object)204, (Object)"No Content").append((Object)205, (Object)"Reset Content").append((Object)206, (Object)"Partial Content").append((Object)300, (Object)"Multiple Choices").append((Object)301, (Object)"Moved Permanently").append((Object)302, (Object)"Temporary Redirect").append((Object)303, (Object)"See Other").append((Object)304, (Object)"Not Modified").append((Object)305, (Object)"Use Proxy").append((Object)307, (Object)"Temporary Redirect").append((Object)400, (Object)"Bad Request").append((Object)401, (Object)"Unauthorized").append((Object)402, (Object)"Payment Required").append((Object)403, (Object)"Forbidden").append((Object)404, (Object)"Not Found").append((Object)405, (Object)"Method Not Allowed").append((Object)406, (Object)"Not Acceptable").append((Object)407, (Object)"Proxy Authentication Required").append((Object)408, (Object)"Request Time-Out").append((Object)409, (Object)"Conflict").append((Object)410, (Object)"Gone").append((Object)411, (Object)"Length Required").append((Object)412, (Object)"Precondition Failed").append((Object)413, (Object)"Request Entity Too Large").append((Object)414, (Object)"Request-URI Too Large").append((Object)415, (Object)"Unsupported Media Type").append((Object)500, (Object)"Internal Server Error").append((Object)501, (Object)"Not Implemented").append((Object)502, (Object)"Bad Gateway").append((Object)503, (Object)"Service Unavailable").append((Object)504, (Object)"Gateway Timeout").append((Object)505, (Object)"HTTP Version Not Supported");
    private static final Pattern INDEXED_LINK_PATTERN = Pattern.compile("(?s)(\\S*)\\[(\\d+)\\]\\:(.*)");

    public static String getHttpResponseText(int rc) {
        return httpMsgs.get(rc);
    }

    public static String getPathInfoUndecoded(HttpServletRequest req) {
        String requestURI = req.getRequestURI();
        String contextPath = req.getContextPath();
        String servletPath = req.getServletPath();
        int l = contextPath.length() + servletPath.length();
        if (requestURI.length() == l) {
            return null;
        }
        return requestURI.substring(l);
    }

    public static StringBuffer trimPathInfo(StringBuffer requestURI, String contextPath, String servletPath) {
        if (servletPath.equals("/")) {
            servletPath = "";
        }
        if (contextPath.equals("/")) {
            contextPath = "";
        }
        try {
            int sc = 0;
            for (int i = 0; i < requestURI.length(); ++i) {
                int c = requestURI.charAt(i);
                if (c == 47) {
                    int j;
                    if (++sc != 3) continue;
                    if (servletPath.isEmpty()) {
                        requestURI.setLength(i);
                        return requestURI;
                    }
                    for (j = 0; j < contextPath.length(); ++j) {
                        if (requestURI.charAt(i) != contextPath.charAt(j)) {
                            throw new Exception("case=1");
                        }
                        ++i;
                    }
                    for (j = 0; j < servletPath.length(); ++j) {
                        if (requestURI.charAt(i) != servletPath.charAt(j)) {
                            throw new Exception("case=2");
                        }
                        ++i;
                    }
                    int n = c = requestURI.length() == i ? 47 : (int)requestURI.charAt(i);
                    if (c == 47 || c == 63) {
                        requestURI.setLength(i);
                        return requestURI;
                    }
                    throw new Exception("case=3");
                }
                if (c != 63) continue;
                if (sc != 2) {
                    throw new Exception("case=4");
                }
                if (servletPath.isEmpty()) {
                    requestURI.setLength(i);
                    return requestURI;
                }
                throw new Exception("case=5");
            }
            if (servletPath.isEmpty()) {
                return requestURI;
            }
            throw new Exception("case=6");
        }
        catch (Exception e) {
            throw new FormattedRuntimeException((Throwable)e, "Could not find servlet path in request URI.  URI=''{0}'', servletPath=''{1}''", new Object[]{requestURI, servletPath});
        }
    }

    public static String[] parseHeader(String s) {
        int i = s.indexOf(58);
        if (i == -1) {
            i = s.indexOf(61);
        }
        if (i == -1) {
            return null;
        }
        String name = s.substring(0, i).trim().toLowerCase(Locale.ENGLISH);
        String val = s.substring(i + 1).trim();
        return new String[]{name, val};
    }

    public static String[] parseKeyValuePair(String s) {
        int i = -1;
        for (int j = 0; j < s.length() && i < 0; ++j) {
            char c = s.charAt(j);
            if (c != '=' && c != ':') continue;
            i = j;
        }
        if (i == -1) {
            return null;
        }
        String name = s.substring(0, i).trim();
        String val = s.substring(i + 1).trim();
        return new String[]{name, val};
    }

    static String resolveNewlineSeparatedAnnotation(String[] value, String fromParent) {
        if (value.length == 0) {
            return fromParent;
        }
        ArrayList<String> l = new ArrayList<String>();
        for (String v : value) {
            if (!"INHERIT".equals(v)) {
                l.add(v);
                continue;
            }
            if (fromParent == null) continue;
            l.addAll(Arrays.asList(fromParent));
        }
        return StringUtils.join(l, (char)'\n');
    }

    static String[] resolveLinks(String[] links, String[] parentLinks) {
        if (links.length == 0) {
            return parentLinks;
        }
        ArrayList<String> list = new ArrayList<String>();
        for (String l : links) {
            if ("INHERIT".equals(l)) {
                list.addAll(Arrays.asList(parentLinks));
                continue;
            }
            if (l.indexOf(91) != -1 && INDEXED_LINK_PATTERN.matcher(l).matches()) {
                Matcher lm = INDEXED_LINK_PATTERN.matcher(l);
                lm.matches();
                String key = lm.group(1);
                int index = Math.min(list.size(), Integer.parseInt(lm.group(2)));
                String remainder = lm.group(3);
                list.add(index, key.isEmpty() ? remainder : key + ":" + remainder);
                continue;
            }
            list.add(l);
        }
        return list.toArray(new String[list.size()]);
    }

    static String[] resolveContent(String[] content, String[] parentContent) {
        if (content.length == 0) {
            return parentContent;
        }
        ArrayList<String> list = new ArrayList<String>();
        for (String l : content) {
            if ("INHERIT".equals(l)) {
                list.addAll(Arrays.asList(parentContent));
                continue;
            }
            if ("NONE".equals(l)) {
                return new String[0];
            }
            list.add(l);
        }
        return list.toArray(new String[list.size()]);
    }

    public static Map<String, String[]> parseQuery(Object qs) {
        return RestUtils.parseQuery(qs, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<String, String[]> parseQuery(Object qs, Map<String, String[]> map) {
        try {
            Map<String, String[]> m = map;
            if (m == null) {
                m = new TreeMap<String, String[]>();
            }
            if (qs == null) return m;
            if (qs instanceof CharSequence && StringUtils.isEmpty((Object)qs)) {
                return m;
            }
            try (ParserPipe p = new ParserPipe(qs);){
                boolean S1 = true;
                int S2 = 2;
                int S3 = 3;
                int S4 = 4;
                try (UonReader r = new UonReader(p, true);){
                    int c = r.peekSkipWs();
                    if (c == 63) {
                        r.read();
                    }
                    int state = 1;
                    String currAttr = null;
                    while (c != -1) {
                        c = r.read();
                        if (state == 1) {
                            if (c == -1) continue;
                            r.unread();
                            r.mark();
                            state = 2;
                            continue;
                        }
                        if (state == 2) {
                            if (c == -1) {
                                RestUtils.add(m, r.getMarked(), null);
                                continue;
                            }
                            if (c == 1) {
                                m.put(r.getMarked(0, -1), null);
                                state = 1;
                                continue;
                            }
                            if (c != 2) continue;
                            currAttr = r.getMarked(0, -1);
                            state = 3;
                            continue;
                        }
                        if (state == 3) {
                            if (c == -1 || c == 1) {
                                RestUtils.add(m, currAttr, "");
                                state = 1;
                                continue;
                            }
                            if (c == 2) {
                                r.replace('=');
                            }
                            r.unread();
                            r.mark();
                            state = 4;
                            continue;
                        }
                        if (state != 4) continue;
                        if (c == -1) {
                            RestUtils.add(m, currAttr, r.getMarked());
                            continue;
                        }
                        if (c == 1) {
                            RestUtils.add(m, currAttr, r.getMarked(0, -1));
                            state = 1;
                            continue;
                        }
                        if (c != 2) continue;
                        r.replace('=');
                    }
                }
                Map<String, String[]> map2 = m;
                return map2;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void add(Map<String, String[]> m, String key, String val) {
        boolean b = m.containsKey(key);
        if (val == null) {
            if (!b) {
                m.put(key, null);
            }
        } else if (b && m.get(key) != null) {
            m.put(key, (String[])ArrayUtils.append((Object[])m.get(key), (Object[])new String[]{val}));
        } else {
            m.put(key, new String[]{val});
        }
    }

    public static Object parseAnything(String s) throws ParseException {
        if (StringUtils.isJson((String)s)) {
            return JsonParser.DEFAULT.parse(s, Object.class);
        }
        return s;
    }

    public static Object[] merge(Object[] fromParent, Object[] fromChild) {
        if (fromParent == null) {
            fromParent = new Object[]{};
        }
        if (ArrayUtils.contains(None.class, (Object[])fromChild)) {
            return new Object[0];
        }
        if (fromChild.length == 0) {
            return fromParent;
        }
        if (!ArrayUtils.contains(Inherit.class, (Object[])fromChild)) {
            return fromChild;
        }
        ArrayList<Object> l = new ArrayList<Object>(fromParent.length + fromChild.length);
        for (Object o : fromChild) {
            if (o == Inherit.class) {
                l.addAll(Arrays.asList(fromParent));
                continue;
            }
            l.add(o);
        }
        return l.toArray(new Object[l.size()]);
    }

    public static String trimContextPath(String contextPath, String path) {
        if (path == null) {
            return null;
        }
        if (path.length() == 0 || path.equals("/") || contextPath.length() == 0 || contextPath.equals("/")) {
            return path;
        }
        String op = path;
        if (path.charAt(0) == '/') {
            path = path.substring(1);
        }
        if (contextPath.charAt(0) == '/') {
            contextPath = contextPath.substring(1);
        }
        if (path.startsWith(contextPath)) {
            if (path.length() == contextPath.length()) {
                return "/";
            }
            if ((path = path.substring(contextPath.length())).isEmpty() || path.charAt(0) == '/') {
                return path;
            }
        }
        return op;
    }

    public static String fixMethodPath(String path) {
        if (path == null) {
            return null;
        }
        if (path.equals("/")) {
            return path;
        }
        return StringUtils.trimTrailingSlashes((String)path);
    }

    public static boolean isValidContextPath(String value) {
        if (value == null) {
            return false;
        }
        if (value.isEmpty()) {
            return true;
        }
        if (value.charAt(value.length() - 1) == '/') {
            return false;
        }
        return value.charAt(0) == '/';
    }

    public static void validateContextPath(String value) {
        if (!RestUtils.isValidContextPath(value)) {
            throw new RuntimeException("Value is not a valid context path: [" + value + "]");
        }
    }

    public static boolean isValidServletPath(String value) {
        if (value == null) {
            return false;
        }
        if (value.isEmpty()) {
            return true;
        }
        if (value.equals("/")) {
            return false;
        }
        if (value.charAt(value.length() - 1) == '/') {
            return false;
        }
        return value.charAt(0) == '/';
    }

    public static void validateServletPath(String value) {
        if (!RestUtils.isValidServletPath(value)) {
            throw new RuntimeException("Value is not a valid servlet path: [" + value + "]");
        }
    }

    public static boolean isValidPathInfo(String value) {
        if (value == null) {
            return true;
        }
        if (value.isEmpty()) {
            return false;
        }
        return value.charAt(0) == '/';
    }

    public static void validatePathInfo(String value) {
        if (!RestUtils.isValidPathInfo(value)) {
            throw new RuntimeException("Value is not a valid path-info path: [" + value + "]");
        }
    }
}

