/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.converters;

import org.apache.juneau.BeanSession;
import org.apache.juneau.rest.RestConverter;
import org.apache.juneau.rest.RestException;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.rest.exception.InternalServerError;
import org.apache.juneau.transform.PojoSwap;
import org.apache.juneau.utils.PojoRest;
import org.apache.juneau.utils.PojoRestException;

public final class Traversable
implements RestConverter {
    @Override
    public Object convert(RestRequest req, Object o) throws RestException, InternalServerError {
        if (o == null) {
            return null;
        }
        String pathRemainder = req.getPathMatch().getRemainder();
        if (pathRemainder != null) {
            try {
                BeanSession bs = req.getBeanSession();
                PojoSwap swap = bs.getClassMetaForObject(o).getPojoSwap(bs);
                if (swap != null) {
                    o = swap.swap(bs, o);
                }
                PojoRest p = new PojoRest(o, req.getBody().getReaderParser());
                o = p.get(pathRemainder);
            }
            catch (PojoRestException e) {
                throw new RestException(e, e.getStatus());
            }
            catch (Exception e) {
                throw new InternalServerError(e);
            }
        }
        return o;
    }
}

