/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest;

import java.io.IOException;
import java.util.logging.Level;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.juneau.internal.ClassUtils;
import org.apache.juneau.internal.JuneauLogger;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.reflect.ClassInfo;
import org.apache.juneau.rest.RestContext;
import org.apache.juneau.rest.RestContextBuilder;
import org.apache.juneau.rest.RestContextProperties;
import org.apache.juneau.rest.RestException;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.rest.RestResourceResolver;
import org.apache.juneau.rest.RestResponse;
import org.apache.juneau.rest.annotation.RestResource;
import org.apache.juneau.rest.exception.InternalServerError;

public abstract class RestServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private RestContextBuilder builder;
    private volatile RestContext context;
    private volatile Exception initException;
    private boolean isInitialized = false;
    private volatile RestResourceResolver resourceResolver;
    private JuneauLogger logger = JuneauLogger.getLogger(((Object)((Object)this)).getClass());

    public final synchronized void init(ServletConfig servletConfig) throws ServletException {
        try {
            if (this.context != null) {
                return;
            }
            this.builder = RestContext.create(servletConfig, ((Object)((Object)this)).getClass(), null);
            if (this.resourceResolver != null) {
                this.builder.resourceResolver(this.resourceResolver);
            }
            this.builder.init((Object)this);
            super.init(servletConfig);
            this.builder.servletContext(this.getServletContext());
            this.setContext(this.builder.build());
            this.context.postInitChildFirst();
        }
        catch (RestException e) {
            this.initException = e;
            this.log(Level.SEVERE, e, "Servlet init error on class ''{0}''", ((Object)((Object)this)).getClass().getName());
        }
        catch (ServletException e) {
            this.initException = e;
            this.log(Level.SEVERE, e, "Servlet init error on class ''{0}''", ((Object)((Object)this)).getClass().getName());
            throw e;
        }
        catch (Exception e) {
            this.initException = e;
            this.log(Level.SEVERE, e, "Servlet init error on class ''{0}''", ((Object)((Object)this)).getClass().getName());
            throw new ServletException((Throwable)e);
        }
        catch (Throwable e) {
            this.initException = new Exception(e);
            this.log(Level.SEVERE, e, "Servlet init error on class ''{0}''", ((Object)((Object)this)).getClass().getName());
            throw new ServletException(e);
        }
    }

    synchronized void innerInit(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
    }

    public synchronized void setContext(RestContext context) throws ServletException {
        this.builder = context.builder;
        this.context = context;
        this.isInitialized = true;
        context.postInit();
    }

    public synchronized RestServlet setRestResourceResolver(RestResourceResolver resourceResolver) {
        this.resourceResolver = resourceResolver;
        return this;
    }

    public synchronized String getPath() {
        if (this.context != null) {
            return this.context.getPath();
        }
        ClassInfo ci = ClassUtils.getClassInfo(((Object)((Object)this)).getClass());
        for (RestResource rr : ci.getAnnotations(RestResource.class)) {
            if (rr.path().isEmpty()) continue;
            return StringUtils.trimSlashes((String)rr.path());
        }
        return "";
    }

    public synchronized RestContextBuilder getServletConfig() {
        return this.builder;
    }

    protected synchronized RestContext getContext() {
        return this.context;
    }

    public void service(HttpServletRequest r1, HttpServletResponse r2) throws ServletException, InternalServerError, IOException {
        try {
            if (!this.isInitialized) {
                if (this.initException != null) {
                    if (this.initException instanceof RestException) {
                        throw (RestException)this.initException;
                    }
                    throw new InternalServerError(this.initException);
                }
                if (this.context == null) {
                    throw new InternalServerError("Servlet {0} not initialized.  init(ServletConfig) was not called.  This can occur if you've overridden this method but didn't call super.init(RestConfig).", ((Object)((Object)this)).getClass().getName());
                }
                this.isInitialized = true;
            }
            this.context.getCallHandler().service(r1, r2);
        }
        catch (RestException e) {
            r2.sendError(500, e.getLocalizedMessage());
        }
        catch (Throwable e) {
            r2.sendError(500, e.getLocalizedMessage());
        }
    }

    public void log(String msg) {
        this.logger.info(msg);
    }

    public void log(String msg, Throwable cause) {
        this.logger.info(cause, msg, new Object[0]);
    }

    public void log(Level level, String msg, Object ... args) {
        this.logger.log(level, msg, args);
    }

    public void logObjects(Level level, String msg, Object ... args) {
        this.logger.logObjects(level, msg, args);
    }

    public void log(Level level, Throwable cause, String msg, Object ... args) {
        this.logger.log(level, cause, msg, args);
    }

    public RestRequest getRequest() {
        if (this.context == null) {
            return null;
        }
        return this.context.getRequest();
    }

    public RestResponse getResponse() {
        if (this.context == null) {
            return null;
        }
        return this.context.getResponse();
    }

    public synchronized void destroy() {
        if (this.context != null) {
            this.context.destroy();
        }
        super.destroy();
    }

    public RestContextProperties getProperties() {
        return this.getContext().getProperties();
    }
}

