/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.xmlschema;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.juneau.BeanMeta;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.BeanSession;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.DefaultFilteringObjectMap;
import org.apache.juneau.FormattedRuntimeException;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.internal.ArrayUtils;
import org.apache.juneau.serializer.SerializeException;
import org.apache.juneau.serializer.SerializerPipe;
import org.apache.juneau.serializer.SerializerSessionArgs;
import org.apache.juneau.xml.Namespace;
import org.apache.juneau.xml.XmlBeanMeta;
import org.apache.juneau.xml.XmlBeanPropertyMeta;
import org.apache.juneau.xml.XmlClassMeta;
import org.apache.juneau.xml.XmlSerializer;
import org.apache.juneau.xml.XmlSerializerSession;
import org.apache.juneau.xml.XmlUtils;
import org.apache.juneau.xml.XmlWriter;
import org.apache.juneau.xml.annotation.XmlFormat;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;

public class XmlSchemaSerializerSession
extends XmlSerializerSession {
    private static Pattern pTargetNs = Pattern.compile("targetNamespace=['\"]([^'\"]+)['\"]");

    protected XmlSchemaSerializerSession(XmlSerializer ctx, SerializerSessionArgs args) {
        super(ctx, args);
    }

    @Override
    protected void doSerialize(SerializerPipe out, Object o) throws IOException, SerializeException {
        if (this.isEnableNamespaces() && this.isAutoDetectNamespaces()) {
            this.findNsfMappings(o);
        }
        Namespace xs = this.getXsNamespace();
        Namespace[] allNs = ArrayUtils.append(new Namespace[]{this.getDefaultNamespace()}, this.getNamespaces());
        Schemas schemas = new Schemas(this, xs, this.getDefaultNamespace(), allNs);
        schemas.process(o);
        schemas.serializeTo(out.getWriter());
    }

    public Validator getValidator(SerializerPipe out, Object o) throws Exception {
        this.doSerialize(out, o);
        String xmlSchema = out.getWriter().toString();
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        if (xmlSchema.indexOf(0) != -1) {
            final HashMap<String, String> schemas = new HashMap<String, String>();
            String[] ss = xmlSchema.split("\u0000");
            xmlSchema = ss[0];
            for (String s : ss) {
                Matcher m = pTargetNs.matcher(s);
                if (!m.find()) continue;
                schemas.put(m.group(1), s);
            }
            factory.setResourceResolver(new LSResourceResolver(){

                @Override
                public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
                    String schema = (String)schemas.get(namespaceURI);
                    if (schema == null) {
                        throw new FormattedRuntimeException("No schema found for namespaceURI ''{0}''", namespaceURI);
                    }
                    try {
                        DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
                        DOMImplementationLS domImplementationLS = (DOMImplementationLS)((Object)registry.getDOMImplementation("LS 3.0"));
                        LSInput in = domImplementationLS.createLSInput();
                        in.setCharacterStream(new StringReader(schema));
                        in.setSystemId(systemId);
                        return in;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
        return factory.newSchema(new StreamSource(new StringReader(xmlSchema))).newValidator();
    }

    @Override
    protected boolean isTrimStrings() {
        return super.isTrimStrings();
    }

    @SafeVarargs
    static <T> T first(T ... tt) {
        for (T t : tt) {
            if (t == null) continue;
            return t;
        }
        return null;
    }

    static String getXmlAttrType(ClassMeta<?> cm) {
        if (cm.isBoolean()) {
            return "boolean";
        }
        if (cm.isNumber()) {
            if (cm.isDecimal()) {
                return "decimal";
            }
            return "integer";
        }
        return "string";
    }

    @Override
    public ObjectMap toMap() {
        return super.toMap().append("XmlSchemaSerializerSession", new DefaultFilteringObjectMap());
    }

    private final class Schema {
        private StringWriter sw = new StringWriter();
        private XmlWriter w;
        private Namespace defaultNs;
        private Namespace targetNs;
        private Schemas schemas;
        private Set<String> processedTypes = new HashSet<String>();
        private Set<String> processedAttributes = new HashSet<String>();
        private Set<String> processedElements = new HashSet<String>();

        public Schema(Schemas schemas, Namespace xs, Namespace targetNs, Namespace defaultNs, Namespace[] allNs) throws IOException {
            this.schemas = schemas;
            this.defaultNs = defaultNs;
            this.targetNs = targetNs;
            this.w = new XmlWriter(this.sw, XmlSchemaSerializerSession.this.isUseWhitespace(), XmlSchemaSerializerSession.this.getMaxIndent(), XmlSchemaSerializerSession.this.isTrimStrings(), XmlSchemaSerializerSession.this.getQuoteChar(), null, true, null);
            int i = XmlSchemaSerializerSession.this.indent;
            this.w.oTag(i, "schema");
            this.w.attr("xmlns", xs.getUri());
            this.w.attr("targetNamespace", targetNs.getUri());
            this.w.attr("elementFormDefault", "qualified");
            if (targetNs != defaultNs) {
                this.w.attr("attributeFormDefault", "qualified");
            }
            for (Namespace ns2 : allNs) {
                this.w.attr("xmlns", ns2.getName(), (Object)ns2.getUri());
            }
            this.w.append('>').nl(i);
            for (Namespace ns : allNs) {
                if (ns == targetNs) continue;
                this.w.oTag(i + 1, "import").attr("namespace", ns.getUri()).attr("schemaLocation", ns.getName() + ".xsd").append("/>").nl(i + 1);
            }
        }

        boolean processElement(String name, ClassMeta<?> cm) throws IOException {
            if (this.processedElements.contains(name)) {
                return false;
            }
            this.processedElements.add(name);
            ClassMeta<?> ft = cm.getSerializedClassMeta(this.schemas.session);
            if (name == null) {
                name = this.getElementName(ft);
            }
            Namespace ns = XmlSchemaSerializerSession.first(ft.getExtendedMeta(XmlClassMeta.class).getNamespace(), this.defaultNs);
            String type = this.getXmlType(ns, ft);
            this.w.oTag(XmlSchemaSerializerSession.this.indent + 1, "element").attr("name", XmlUtils.encodeElementName(name)).attr("type", type).append('/').append('>').nl(XmlSchemaSerializerSession.this.indent + 1);
            this.schemas.queueType(ns, null, ft);
            this.schemas.processQueue();
            return true;
        }

        boolean processAttribute(String name, ClassMeta<?> cm) throws IOException {
            if (this.processedAttributes.contains(name)) {
                return false;
            }
            this.processedAttributes.add(name);
            String type = XmlSchemaSerializerSession.getXmlAttrType(cm);
            this.w.oTag(XmlSchemaSerializerSession.this.indent + 1, "attribute").attr("name", name).attr("type", type).append('/').append('>').nl(XmlSchemaSerializerSession.this.indent + 1);
            return true;
        }

        boolean processType(String name, ClassMeta<?> cm) throws IOException {
            if (this.processedTypes.contains(name)) {
                return false;
            }
            this.processedTypes.add(name);
            int i = XmlSchemaSerializerSession.this.indent + 1;
            cm = cm.getSerializedClassMeta(this.schemas.session);
            XmlBeanMeta xbm = cm.isBean() ? cm.getBeanMeta().getExtendedMeta(XmlBeanMeta.class) : null;
            this.w.oTag(i, "complexType").attr("name", name);
            if (xbm != null && xbm.getContentFormat() != null && xbm.getContentFormat().isOneOf(XmlFormat.TEXT, XmlFormat.TEXT_PWS, XmlFormat.MIXED, XmlFormat.MIXED_PWS, XmlFormat.XMLTEXT) || !cm.isMapOrBean()) {
                this.w.attr("mixed", "true");
            }
            this.w.cTag().nl(i);
            if (!(cm.isMapOrBean() || cm.isCollectionOrArray() || cm.isAbstract() && !cm.isNumber() || cm.isObject())) {
                this.w.oTag(i + 1, "attribute").attr("name", XmlSchemaSerializerSession.this.getBeanTypePropertyName(cm)).attr("type", "string").ceTag().nl(i + 1);
            } else {
                if (cm.isBean()) {
                    BeanMeta<?> bm = cm.getBeanMeta();
                    boolean hasChildElements = false;
                    for (BeanPropertyMeta pMeta : bm.getPropertyMetas()) {
                        XmlFormat bpXml;
                        if (!pMeta.canRead() || (bpXml = pMeta.getExtendedMeta(XmlBeanPropertyMeta.class).getXmlFormat()) == XmlFormat.ATTR) continue;
                        hasChildElements = true;
                    }
                    XmlBeanMeta xbm2 = bm.getExtendedMeta(XmlBeanMeta.class);
                    if (xbm2.getContentProperty() != null && xbm2.getContentFormat() == XmlFormat.ELEMENTS) {
                        this.w.sTag(i + 1, "sequence").nl(i + 1);
                        this.w.oTag(i + 2, "any").attr("processContents", "skip").attr("minOccurs", 0).ceTag().nl(i + 2);
                        this.w.eTag(i + 1, "sequence").nl(i + 1);
                    } else if (hasChildElements) {
                        XmlBeanPropertyMeta xmlMeta;
                        boolean hasOtherNsElement = false;
                        boolean hasCollapsed = false;
                        for (BeanPropertyMeta pMeta : bm.getPropertyMetas()) {
                            if (!pMeta.canRead() || (xmlMeta = pMeta.getExtendedMeta(XmlBeanPropertyMeta.class)).getXmlFormat() == XmlFormat.ATTR) continue;
                            if (xmlMeta.getNamespace() != null) {
                                ClassMeta<?> ct2 = pMeta.getClassMeta();
                                Namespace cNs = XmlSchemaSerializerSession.first(xmlMeta.getNamespace(), ct2.getExtendedMeta(XmlClassMeta.class).getNamespace(), cm.getExtendedMeta(XmlClassMeta.class).getNamespace(), this.defaultNs);
                                this.schemas.queueElement(cNs, pMeta.getName(), ct2);
                                hasOtherNsElement = true;
                            }
                            if (xmlMeta.getXmlFormat() != XmlFormat.COLLAPSED) continue;
                            hasCollapsed = true;
                        }
                        if (hasOtherNsElement || hasCollapsed) {
                            this.w.oTag(i + 1, "choice").attr("maxOccurs", "unbounded").cTag().nl(i + 1);
                            this.w.oTag(i + 2, "any").attr("processContents", "skip").attr("minOccurs", 0).ceTag().nl(i + 2);
                            this.w.eTag(i + 1, "choice").nl(i + 1);
                        } else {
                            this.w.sTag(i + 1, "all").nl(i + 1);
                            for (BeanPropertyMeta pMeta : bm.getPropertyMetas()) {
                                if (!pMeta.canRead() || (xmlMeta = pMeta.getExtendedMeta(XmlBeanPropertyMeta.class)).getXmlFormat() == XmlFormat.ATTR) continue;
                                boolean isCollapsed = xmlMeta.getXmlFormat() == XmlFormat.COLLAPSED;
                                ClassMeta<?> ct2 = pMeta.getClassMeta();
                                String childName = pMeta.getName();
                                if (isCollapsed) {
                                    if (xmlMeta.getChildName() != null) {
                                        childName = xmlMeta.getChildName();
                                    }
                                    ct2 = pMeta.getClassMeta().getElementType();
                                }
                                Namespace cNs = XmlSchemaSerializerSession.first(xmlMeta.getNamespace(), ct2.getExtendedMeta(XmlClassMeta.class).getNamespace(), cm.getExtendedMeta(XmlClassMeta.class).getNamespace(), this.defaultNs);
                                if (xmlMeta.getNamespace() == null) {
                                    this.w.oTag(i + 2, "element").attr("name", (Object)XmlUtils.encodeElementName(childName), false).attr("type", this.getXmlType(cNs, ct2)).attr("minOccurs", 0);
                                    this.w.ceTag().nl(i + 2);
                                    continue;
                                }
                                this.schemas.queueElement(cNs, pMeta.getName(), ct2);
                                hasOtherNsElement = true;
                            }
                            this.w.eTag(i + 1, "all").nl(i + 1);
                        }
                    }
                    for (BeanPropertyMeta pMeta : bm.getExtendedMeta(XmlBeanMeta.class).getAttrProperties().values()) {
                        if (!pMeta.canRead()) continue;
                        Namespace pNs = pMeta.getExtendedMeta(XmlBeanPropertyMeta.class).getNamespace();
                        if (pNs == null) {
                            pNs = this.defaultNs;
                        }
                        if (pNs != this.targetNs) {
                            this.schemas.queueAttribute(pNs, pMeta.getName(), pMeta.getClassMeta());
                            this.w.oTag(i + 1, "attribute").attr("ref", pNs.getName() + ':' + pMeta.getName()).ceTag().nl(i + 1);
                            continue;
                        }
                        this.w.oTag(i + 1, "attribute").attr("name", (Object)pMeta.getName(), true).attr("type", XmlSchemaSerializerSession.getXmlAttrType(pMeta.getClassMeta())).ceTag().nl(i + 1);
                    }
                } else if (cm.isCollectionOrArray()) {
                    ClassMeta<?> elementType = cm.getElementType();
                    if (elementType.isObject()) {
                        this.w.sTag(i + 1, "sequence").nl(i + 1);
                        this.w.oTag(i + 2, "any").attr("processContents", "skip").attr("maxOccurs", "unbounded").attr("minOccurs", "0").ceTag().nl(i + 2);
                        this.w.eTag(i + 1, "sequence").nl(i + 1);
                    } else {
                        Namespace cNs = XmlSchemaSerializerSession.first(elementType.getExtendedMeta(XmlClassMeta.class).getNamespace(), cm.getExtendedMeta(XmlClassMeta.class).getNamespace(), this.defaultNs);
                        this.schemas.queueType(cNs, null, elementType);
                        this.w.sTag(i + 1, "sequence").nl(i + 1);
                        this.w.oTag(i + 2, "any").attr("processContents", "skip").attr("maxOccurs", "unbounded").attr("minOccurs", "0").ceTag().nl(i + 2);
                        this.w.eTag(i + 1, "sequence").nl(i + 1);
                    }
                } else if (cm.isMap() || cm.isAbstract() || cm.isObject()) {
                    this.w.sTag(i + 1, "sequence").nl(i + 1);
                    this.w.oTag(i + 2, "any").attr("processContents", "skip").attr("maxOccurs", "unbounded").attr("minOccurs", "0").ceTag().nl(i + 2);
                    this.w.eTag(i + 1, "sequence").nl(i + 1);
                }
                this.w.oTag(i + 1, "attribute").attr("name", XmlSchemaSerializerSession.this.getBeanTypePropertyName(null)).attr("type", "string").ceTag().nl(i + 1);
            }
            this.w.eTag(i, "complexType").nl(i);
            this.schemas.processQueue();
            return true;
        }

        private String getElementName(ClassMeta<?> cm) {
            String name = (cm = cm.getSerializedClassMeta(this.schemas.session)).getDictionaryName();
            if (name == null) {
                name = cm.isBoolean() ? "boolean" : (cm.isNumber() ? "number" : (cm.isCollectionOrArray() ? "array" : (!cm.isMapOrBean() && !cm.isCollectionOrArray() && !cm.isObject() && !cm.isAbstract() ? "string" : "object")));
            }
            return name;
        }

        public String toString() {
            try {
                this.w.eTag(XmlSchemaSerializerSession.this.indent, "schema").nl(XmlSchemaSerializerSession.this.indent);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return this.sw.toString();
        }

        private String getXmlType(Namespace currentNs, ClassMeta<?> cm) {
            String name = null;
            cm = cm.getSerializedClassMeta(this.schemas.session);
            if (currentNs == this.targetNs && cm.isPrimitive()) {
                if (cm.isBoolean()) {
                    name = "boolean";
                } else if (cm.isNumber()) {
                    name = cm.isDecimal() ? "decimal" : "integer";
                }
            }
            if (name == null) {
                name = XmlUtils.encodeElementName(cm);
                this.schemas.queueType(currentNs, name, cm);
                return currentNs.getName() + ":" + name;
            }
            return name;
        }
    }

    final class Schemas
    extends LinkedHashMap<Namespace, Schema> {
        private static final long serialVersionUID = 1L;
        private Namespace defaultNs;
        BeanSession session;
        private LinkedList<QueueEntry> elementQueue = new LinkedList();
        private LinkedList<QueueEntry> attributeQueue = new LinkedList();
        private LinkedList<QueueEntry> typeQueue = new LinkedList();

        Schemas(BeanSession session, Namespace xs, Namespace defaultNs, Namespace[] allNs) throws IOException {
            this.session = session;
            this.defaultNs = defaultNs;
            for (Namespace ns : allNs) {
                this.put(ns, new Schema(this, xs, ns, defaultNs, allNs));
            }
        }

        Schema getSchema(Namespace ns) {
            Schema s;
            if (ns == null) {
                ns = this.defaultNs;
            }
            if ((s = (Schema)this.get(ns)) == null) {
                throw new FormattedRuntimeException("No schema defined for namespace ''{0}''", ns);
            }
            return s;
        }

        void process(Object o) throws IOException {
            ClassMeta<Object> cm = XmlSchemaSerializerSession.this.getClassMetaForObject(o);
            Namespace ns = this.defaultNs;
            if (cm == null) {
                this.queueElement(ns, "null", XmlSchemaSerializerSession.this.object());
            } else {
                XmlClassMeta xmlMeta = cm.getExtendedMeta(XmlClassMeta.class);
                if (cm.getDictionaryName() != null && xmlMeta.getNamespace() != null) {
                    ns = xmlMeta.getNamespace();
                }
                this.queueElement(ns, cm.getDictionaryName(), cm);
            }
            this.processQueue();
        }

        void processQueue() throws IOException {
            boolean b;
            do {
                QueueEntry q;
                b = false;
                while (!this.elementQueue.isEmpty()) {
                    q = this.elementQueue.removeFirst();
                    b |= this.getSchema(q.ns).processElement(q.name, q.cm);
                }
                while (!this.typeQueue.isEmpty()) {
                    q = this.typeQueue.removeFirst();
                    b |= this.getSchema(q.ns).processType(q.name, q.cm);
                }
                while (!this.attributeQueue.isEmpty()) {
                    q = this.attributeQueue.removeFirst();
                    b |= this.getSchema(q.ns).processAttribute(q.name, q.cm);
                }
            } while (b);
        }

        void queueElement(Namespace ns, String name, ClassMeta<?> cm) {
            this.elementQueue.add(new QueueEntry(ns, name, cm));
        }

        void queueType(Namespace ns, String name, ClassMeta<?> cm) {
            if (name == null) {
                name = XmlUtils.encodeElementName(cm);
            }
            this.typeQueue.add(new QueueEntry(ns, name, cm));
        }

        void queueAttribute(Namespace ns, String name, ClassMeta<?> cm) {
            this.attributeQueue.add(new QueueEntry(ns, name, cm));
        }

        void serializeTo(Writer w) throws IOException {
            boolean b = false;
            for (Schema s : this.values()) {
                if (b) {
                    w.append('\u0000');
                }
                w.append(s.toString());
                b = true;
            }
        }
    }

    private static class QueueEntry {
        Namespace ns;
        String name;
        ClassMeta<?> cm;

        QueueEntry(Namespace ns, String name, ClassMeta<?> cm) {
            this.ns = ns;
            this.name = name;
            this.cm = cm;
        }
    }
}

