/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.urlencoding;

import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import org.apache.juneau.BeanMap;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.DefaultFilteringObjectMap;
import org.apache.juneau.ExecutableException;
import org.apache.juneau.ObjectList;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.internal.ArrayUtils;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.parser.ParserPipe;
import org.apache.juneau.parser.ParserSession;
import org.apache.juneau.parser.ParserSessionArgs;
import org.apache.juneau.transform.BuilderSwap;
import org.apache.juneau.transform.PojoSwap;
import org.apache.juneau.uon.UonParserSession;
import org.apache.juneau.uon.UonReader;
import org.apache.juneau.urlencoding.UrlEncodingClassMeta;
import org.apache.juneau.urlencoding.UrlEncodingParser;

public class UrlEncodingParserSession
extends UonParserSession {
    private final UrlEncodingParser ctx;

    protected UrlEncodingParserSession(UrlEncodingParser ctx, ParserSessionArgs args) {
        super(ctx, args);
        this.ctx = ctx;
    }

    public final boolean shouldUseExpandedParams(BeanPropertyMeta pMeta) {
        ClassMeta<?> cm = pMeta.getClassMeta().getSerializedClassMeta(this);
        if (cm.isCollectionOrArray()) {
            if (this.isExpandedParams()) {
                return true;
            }
            if (pMeta.getBeanMeta().getClassMeta().getExtendedMeta(UrlEncodingClassMeta.class).isExpandedParams()) {
                return true;
            }
        }
        return false;
    }

    @Override
    protected <T> T doParse(ParserPipe pipe, ClassMeta<T> type) throws IOException, ParseException, ExecutableException {
        try (UonReader r = this.getUonReader(pipe, true);){
            T t = this.parseAnything(type, r, this.getOuter());
            return t;
        }
    }

    @Override
    protected <K, V> Map<K, V> doParseIntoMap(ParserPipe pipe, Map<K, V> m, Type keyType, Type valueType) throws Exception {
        try (UonReader r = this.getUonReader(pipe, true);){
            if (r.peekSkipWs() == 63) {
                r.read();
            }
            Map<K, V> map = m = this.parseIntoMap2(r, m, this.getClassMeta((Type)((Object)Map.class), keyType, valueType), null);
            return map;
        }
    }

    private <T> T parseAnything(ClassMeta<T> eType, UonReader r, Object outer) throws IOException, ParseException, ExecutableException {
        Object o;
        if (eType == null) {
            eType = this.object();
        }
        PojoSwap<T, ?> swap = eType.getPojoSwap(this);
        BuilderSwap<Object, Object> builder = eType.getBuilderSwap(this);
        ClassMeta<Object> sType = null;
        sType = builder != null ? builder.getBuilderClassMeta(this) : (swap != null ? swap.getSwapClassMeta(this) : eType);
        int c = r.peekSkipWs();
        if (c == 63) {
            r.read();
        }
        if (sType.isObject()) {
            ObjectMap m = new ObjectMap(this);
            this.parseIntoMap2(r, m, this.getClassMeta((Type)((Object)Map.class), new Type[]{String.class, Object.class}), outer);
            o = m.containsKey("_value") ? m.get("_value") : this.cast(m, null, eType);
        } else if (sType.isMap()) {
            Map<String, Object> m = sType.canCreateNewInstance() ? (Map)sType.newInstance() : new ObjectMap(this);
            o = this.parseIntoMap2(r, m, sType, m);
        } else if (builder != null) {
            BeanMap<?> m = this.toBeanMap(builder.create(this, eType));
            o = (m = this.parseIntoBeanMap(r, m)) == null ? null : builder.build(this, m.getBean(), eType);
        } else if (sType.canCreateNewBean(outer)) {
            BeanMap<Object> m = this.newBeanMap(outer, sType.getInnerClass());
            o = (m = this.parseIntoBeanMap(r, m)) == null ? null : m.getBean();
        } else if (sType.isCollection() || sType.isArray() || sType.isArgs()) {
            ObjectList c2 = sType.isArray() || sType.isArgs() || !sType.canCreateNewInstance(outer) ? new ObjectList(this) : (Collection)sType.newInstance();
            TreeMap m = new TreeMap();
            this.parseIntoMap2(r, m, sType, c2);
            c2.addAll(m.values());
            o = sType.isArray() ? ArrayUtils.toArray(c2, sType.getElementType().getInnerClass()) : (sType.isArgs() ? c2.toArray(new Object[c2.size()]) : c2);
        } else {
            ObjectMap m = new ObjectMap(this);
            this.parseIntoMap2(r, m, this.getClassMeta((Type)((Object)Map.class), new Type[]{String.class, Object.class}), outer);
            if (m.containsKey(this.getBeanTypePropertyName(eType))) {
                o = this.cast(m, null, eType);
            } else if (m.containsKey("_value")) {
                o = this.convertToType(m.get("_value"), sType);
            } else {
                if (sType.getNotABeanReason() != null) {
                    throw new ParseException((ParserSession)this, "Class ''{0}'' could not be instantiated as application/x-www-form-urlencoded.  Reason: ''{1}''", sType, sType.getNotABeanReason());
                }
                throw new ParseException((ParserSession)this, "Malformed application/x-www-form-urlencoded input for class ''{0}''.", sType);
            }
        }
        if (swap != null && o != null) {
            o = this.unswap(swap, o, eType);
        }
        if (outer != null) {
            UrlEncodingParserSession.setParent(eType, o, outer);
        }
        return (T)o;
    }

    private <K, V> Map<K, V> parseIntoMap2(UonReader r, Map<K, V> m, ClassMeta<?> type, Object outer) throws IOException, ParseException, ExecutableException {
        ClassMeta<Integer> keyType = type.isArgs() || type.isCollectionOrArray() ? this.getClassMeta(Integer.class) : type.getKeyType();
        int c = r.peekSkipWs();
        if (c == -1) {
            return m;
        }
        boolean S1 = true;
        int S2 = 2;
        int S3 = 3;
        int S4 = 4;
        boolean isInEscape = false;
        int state = 1;
        int argIndex = 0;
        Integer currAttr = null;
        while (c != -1) {
            c = r.read();
            if (!isInEscape) {
                if (state == 1) {
                    if (c == -1) {
                        return m;
                    }
                    r.unread();
                    Object attr = this.parseAttr(r, true);
                    currAttr = attr == null ? null : this.convertAttrToType(m, this.trim(attr.toString()), keyType);
                    state = 2;
                    c = 0;
                } else if (state == 2) {
                    if (c == 2) {
                        state = 3;
                    } else if (c == -1 || c == 1) {
                        m.put(currAttr, null);
                        if (c == -1) {
                            return m;
                        }
                        state = 1;
                    }
                } else if (state == 3) {
                    Object value;
                    ClassMeta<?> valueType;
                    if (c == -1 || c == 1) {
                        valueType = type.isArgs() ? type.getArg(argIndex++) : (type.isCollectionOrArray() ? type.getElementType() : type.getValueType());
                        value = this.convertAttrToType(m, "", valueType);
                        m.put(currAttr, value);
                        if (c == -1) {
                            return m;
                        }
                        state = 1;
                    } else {
                        valueType = type.isArgs() ? type.getArg(argIndex++) : (type.isCollectionOrArray() ? type.getElementType() : type.getValueType());
                        String string = value = valueType.isString() ? super.parseString(r.unread(), true) : super.parseAnything(valueType, r.unread(), outer, true, null);
                        if (m.containsKey(currAttr) && valueType.isObject()) {
                            Object v2 = m.get(currAttr);
                            if (!(v2 instanceof ObjectList)) {
                                v2 = new ObjectList(v2).setBeanSession(this);
                                m.put(currAttr, v2);
                            }
                            ((ObjectList)v2).add(value);
                        } else {
                            m.put(currAttr, value);
                        }
                        state = 4;
                        c = 0;
                    }
                } else if (state == 4) {
                    if (c == 1) {
                        state = 1;
                    } else if (c == -1) {
                        return m;
                    }
                }
            }
            isInEscape = c == 92 && !isInEscape;
        }
        if (state == 1) {
            throw new ParseException((ParserSession)this, "Could not find attribute name on object.", new Object[0]);
        }
        if (state == 2) {
            throw new ParseException((ParserSession)this, "Could not find '=' following attribute name on object.", new Object[0]);
        }
        if (state == 3) {
            throw new ParseException((ParserSession)this, "Dangling '=' found in object entry", new Object[0]);
        }
        if (state == 4) {
            throw new ParseException((ParserSession)this, "Could not find end of object.", new Object[0]);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> BeanMap<T> parseIntoBeanMap(UonReader r, BeanMap<T> m) throws IOException, ParseException, ExecutableException {
        int c = r.peekSkipWs();
        if (c == -1) {
            return m;
        }
        boolean S1 = true;
        int S2 = 2;
        int S3 = 3;
        int S4 = 4;
        boolean isInEscape = false;
        int state = 1;
        String currAttr = "";
        this.mark();
        try {
            while (c != -1) {
                c = r.read();
                if (!isInEscape) {
                    BeanMap<T> beanMap;
                    if (state == 1) {
                        if (c == -1) {
                            beanMap = m;
                            return beanMap;
                        }
                        r.unread();
                        this.mark();
                        currAttr = this.parseAttrName(r, true);
                        if (currAttr == null) {
                            beanMap = null;
                            return beanMap;
                        }
                        state = 2;
                    } else if (state == 2) {
                        if (c == 2) {
                            state = 3;
                        } else if (c == -1 || c == 1) {
                            m.put(currAttr, (Object)null);
                            if (c == -1) {
                                beanMap = m;
                                return beanMap;
                            }
                            state = 1;
                        }
                    } else if (state == 3) {
                        ClassMeta<?> cm;
                        Object pMeta;
                        if (c == -1 || c == 1) {
                            if (!currAttr.equals(this.getBeanTypePropertyName(m.getClassMeta()))) {
                                pMeta = m.getPropertyMeta(currAttr);
                                if (pMeta == null) {
                                    this.onUnknownProperty(currAttr, m);
                                    this.unmark();
                                } else {
                                    this.unmark();
                                    this.setCurrentProperty((BeanPropertyMeta)pMeta);
                                    cm = ((BeanPropertyMeta)pMeta).getClassMeta();
                                    if (cm.canCreateNewInstance()) {
                                        ((BeanPropertyMeta)pMeta).set(m, currAttr, cm.newInstance());
                                    }
                                    this.setCurrentProperty(null);
                                }
                            }
                            if (c == -1) {
                                pMeta = m;
                                return pMeta;
                            }
                            state = 1;
                        } else {
                            if (!currAttr.equals(this.getBeanTypePropertyName(m.getClassMeta()))) {
                                pMeta = m.getPropertyMeta(currAttr);
                                if (pMeta == null) {
                                    this.onUnknownProperty(currAttr, m);
                                    this.unmark();
                                    this.parseAnything(this.object(), r.unread(), m.getBean(false), true, null);
                                } else {
                                    Object value;
                                    this.unmark();
                                    this.setCurrentProperty((BeanPropertyMeta)pMeta);
                                    if (this.shouldUseExpandedParams((BeanPropertyMeta)pMeta)) {
                                        ClassMeta<?> et = ((BeanPropertyMeta)pMeta).getClassMeta().getElementType();
                                        value = this.parseAnything(et, r.unread(), m.getBean(false), true, (BeanPropertyMeta)pMeta);
                                        UrlEncodingParserSession.setName(et, value, currAttr);
                                        ((BeanPropertyMeta)pMeta).add(m, currAttr, value);
                                    } else {
                                        cm = ((BeanPropertyMeta)pMeta).getClassMeta();
                                        value = this.parseAnything(cm, r.unread(), m.getBean(false), true, (BeanPropertyMeta)pMeta);
                                        UrlEncodingParserSession.setName(cm, value, currAttr);
                                        ((BeanPropertyMeta)pMeta).set(m, currAttr, value);
                                    }
                                    this.setCurrentProperty(null);
                                }
                            }
                            state = 4;
                        }
                    } else if (state == 4) {
                        if (c == 1) {
                            state = 1;
                        } else if (c == -1) {
                            beanMap = m;
                            return beanMap;
                        }
                    }
                }
                isInEscape = c == 92 && !isInEscape;
            }
            if (state == 1) {
                throw new ParseException((ParserSession)this, "Could not find attribute name on object.", new Object[0]);
            }
            if (state == 2) {
                throw new ParseException((ParserSession)this, "Could not find '=' following attribute name on object.", new Object[0]);
            }
            if (state == 3) {
                throw new ParseException((ParserSession)this, "Could not find value following '=' on object.", new Object[0]);
            }
            if (state == 4) {
                throw new ParseException((ParserSession)this, "Could not find end of object.", new Object[0]);
            }
        }
        finally {
            this.unmark();
        }
        return null;
    }

    protected final boolean isExpandedParams() {
        return this.ctx.isExpandedParams();
    }

    @Override
    public ObjectMap toMap() {
        return super.toMap().append("UrlEncodingParserSession", new DefaultFilteringObjectMap());
    }
}

