/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.apache.juneau.Visibility;
import org.apache.juneau.annotation.BeanIgnore;
import org.apache.juneau.reflect.ClassInfo;
import org.apache.juneau.reflect.ReflectFlags;

@BeanIgnore
public final class FieldInfo
implements Comparable<FieldInfo> {
    private final Field f;
    private ClassInfo declaringClass;
    private ClassInfo type;

    protected FieldInfo(ClassInfo declaringClass, Field f) {
        this.declaringClass = declaringClass;
        this.f = f;
    }

    public static FieldInfo of(ClassInfo declaringClass, Field f) {
        if (f == null) {
            return null;
        }
        return new FieldInfo(declaringClass, f);
    }

    public static FieldInfo of(Field f) {
        if (f == null) {
            return null;
        }
        return new FieldInfo(null, f);
    }

    public Field inner() {
        return this.f;
    }

    public ClassInfo getDeclaringClass() {
        if (this.declaringClass == null) {
            this.declaringClass = ClassInfo.of(this.f.getDeclaringClass());
        }
        return this.declaringClass;
    }

    public <T extends Annotation> T getAnnotation(Class<T> a) {
        if (a == null) {
            return null;
        }
        return this.f.getAnnotation(a);
    }

    public boolean hasAnnotation(Class<? extends Annotation> a) {
        return this.f.isAnnotationPresent(a);
    }

    public boolean isAll(ReflectFlags ... flags) {
        block10: for (ReflectFlags f : flags) {
            switch (f) {
                case DEPRECATED: {
                    if (!this.isNotDeprecated()) continue block10;
                    return false;
                }
                case NOT_DEPRECATED: {
                    if (!this.isDeprecated()) continue block10;
                    return false;
                }
                case PUBLIC: {
                    if (!this.isNotPublic()) continue block10;
                    return false;
                }
                case NOT_PUBLIC: {
                    if (!this.isPublic()) continue block10;
                    return false;
                }
                case STATIC: {
                    if (!this.isNotStatic()) continue block10;
                    return false;
                }
                case NOT_STATIC: {
                    if (!this.isStatic()) continue block10;
                    return false;
                }
                case TRANSIENT: {
                    if (!this.isNotTransient()) continue block10;
                    return false;
                }
                case NOT_TRANSIENT: {
                    if (!this.isTransient()) continue block10;
                    return false;
                }
                default: {
                    throw new RuntimeException("Invalid flag for field: " + (Object)((Object)f));
                }
            }
        }
        return true;
    }

    public boolean isAny(ReflectFlags ... flags) {
        block10: for (ReflectFlags f : flags) {
            switch (f) {
                case DEPRECATED: {
                    if (!this.isDeprecated()) continue block10;
                    return true;
                }
                case NOT_DEPRECATED: {
                    if (!this.isNotDeprecated()) continue block10;
                    return true;
                }
                case PUBLIC: {
                    if (!this.isPublic()) continue block10;
                    return true;
                }
                case NOT_PUBLIC: {
                    if (!this.isNotPublic()) continue block10;
                    return true;
                }
                case STATIC: {
                    if (!this.isStatic()) continue block10;
                    return true;
                }
                case NOT_STATIC: {
                    if (!this.isNotStatic()) continue block10;
                    return true;
                }
                case TRANSIENT: {
                    if (!this.isTransient()) continue block10;
                    return true;
                }
                case NOT_TRANSIENT: {
                    if (!this.isNotTransient()) continue block10;
                    return true;
                }
                default: {
                    throw new RuntimeException("Invalid flag for field: " + (Object)((Object)f));
                }
            }
        }
        return false;
    }

    public boolean isDeprecated() {
        return this.f.isAnnotationPresent(Deprecated.class);
    }

    public boolean isNotDeprecated() {
        return !this.f.isAnnotationPresent(Deprecated.class);
    }

    public boolean isPublic() {
        return Modifier.isPublic(this.f.getModifiers());
    }

    public boolean isNotPublic() {
        return !Modifier.isPublic(this.f.getModifiers());
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.f.getModifiers());
    }

    public boolean isNotStatic() {
        return !Modifier.isStatic(this.f.getModifiers());
    }

    public boolean isTransient() {
        return Modifier.isTransient(this.f.getModifiers());
    }

    public boolean isNotTransient() {
        return !Modifier.isTransient(this.f.getModifiers());
    }

    public boolean hasName(String name) {
        return this.f.getName().equals(name);
    }

    public boolean setAccessible() {
        try {
            if (!this.f.isAccessible()) {
                this.f.setAccessible(true);
            }
            return true;
        }
        catch (SecurityException e) {
            return false;
        }
    }

    public boolean isVisible(Visibility v) {
        return v.isVisible(this.f);
    }

    public ClassInfo getType() {
        if (this.type == null) {
            this.type = ClassInfo.of(this.f.getType());
        }
        return this.type;
    }

    public String toString() {
        return this.f.getDeclaringClass().getName() + "." + this.f.getName();
    }

    @Override
    public int compareTo(FieldInfo o) {
        return this.getName().compareTo(o.getName());
    }

    public String getName() {
        return this.f.getName();
    }
}

