/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.jsonschema;

import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.juneau.BeanSessionArgs;
import org.apache.juneau.BeanTraverseContext;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.DefaultFilteringObjectMap;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.annotation.ConfigurableContext;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.json.JsonSerializer;
import org.apache.juneau.jsonschema.BasicBeanDefMapper;
import org.apache.juneau.jsonschema.BeanDefMapper;
import org.apache.juneau.jsonschema.JsonSchemaGeneratorBuilder;
import org.apache.juneau.jsonschema.JsonSchemaGeneratorSession;
import org.apache.juneau.jsonschema.TypeCategory;

@ConfigurableContext
public class JsonSchemaGenerator
extends BeanTraverseContext {
    static final String PREFIX = "JsonSchemaGenerator";
    public static final String JSONSCHEMA_addDescriptionsTo = "JsonSchemaGenerator.addDescriptionsTo.s";
    public static final String JSONSCHEMA_addExamplesTo = "JsonSchemaGenerator.addExamplesTo.s";
    public static final String JSONSCHEMA_allowNestedDescriptions = "JsonSchemaGenerator.allowNestedDescriptions.b";
    public static final String JSONSCHEMA_allowNestedExamples = "JsonSchemaGenerator.allowNestedExamples.b";
    public static final String JSONSCHEMA_beanDefMapper = "JsonSchemaGenerator.beanDefMapper.o";
    public static final String JSONSCHEMA_defaultSchemas = "JsonSchemaGenerator.defaultSchemas.smo";
    public static final String JSONSCHEMA_ignoreTypes = "JsonSchemaGenerator.ignoreTypes.s";
    public static final String JSONSCHEMA_useBeanDefs = "JsonSchemaGenerator.useBeanDefs.b";
    public static final JsonSchemaGenerator DEFAULT = new JsonSchemaGenerator(PropertyStore.DEFAULT);
    private final boolean useBeanDefs = this.getBooleanProperty("JsonSchemaGenerator.useBeanDefs.b", false);
    private final boolean allowNestedExamples = this.getBooleanProperty("JsonSchemaGenerator.allowNestedExamples.b", false);
    private final boolean allowNestedDescriptions = this.getBooleanProperty("JsonSchemaGenerator.allowNestedDescriptions.b", false);
    private final BeanDefMapper beanDefMapper = this.getInstanceProperty("JsonSchemaGenerator.beanDefMapper.o", BeanDefMapper.class, BasicBeanDefMapper.class);
    private final Set<TypeCategory> addExamplesTo = TypeCategory.parse(this.getStringProperty("JsonSchemaGenerator.addExamplesTo.s", null));
    private final Set<TypeCategory> addDescriptionsTo = TypeCategory.parse(this.getStringProperty("JsonSchemaGenerator.addDescriptionsTo.s", null));
    private final Map<String, ObjectMap> defaultSchemas = this.getMapProperty("JsonSchemaGenerator.defaultSchemas.smo", ObjectMap.class);
    private final JsonSerializer jsonSerializer;
    private final Set<Pattern> ignoreTypes;

    public JsonSchemaGenerator(PropertyStore ps) {
        super(ps.builder().set("BeanTraverseContext.detectRecursions.b", true).set("BeanTraverseContext.ignoreRecursions.b", true).build());
        LinkedHashSet<Pattern> ignoreTypes = new LinkedHashSet<Pattern>();
        for (String s : StringUtils.split(ps.getProperty(JSONSCHEMA_ignoreTypes, String.class, ""))) {
            ignoreTypes.add(Pattern.compile(s.replace(".", "\\.").replace("*", ".*")));
        }
        this.ignoreTypes = ignoreTypes;
        this.jsonSerializer = new JsonSerializer(ps);
    }

    @Override
    public JsonSchemaGeneratorBuilder builder() {
        return new JsonSchemaGeneratorBuilder(this.getPropertyStore());
    }

    public static JsonSchemaGeneratorBuilder create() {
        return new JsonSchemaGeneratorBuilder();
    }

    @Override
    public JsonSchemaGeneratorSession createSession() {
        return this.createSession(this.createDefaultSessionArgs());
    }

    @Override
    public JsonSchemaGeneratorSession createSession(BeanSessionArgs args) {
        return new JsonSchemaGeneratorSession(this, args);
    }

    JsonSerializer getJsonSerializer() {
        return this.jsonSerializer;
    }

    protected final Set<TypeCategory> getAddDescriptionsTo() {
        return this.addDescriptionsTo;
    }

    protected final Set<TypeCategory> getAddExamplesTo() {
        return this.addExamplesTo;
    }

    protected final boolean isAllowNestedDescriptions() {
        return this.allowNestedDescriptions;
    }

    protected final boolean isAllowNestedExamples() {
        return this.allowNestedExamples;
    }

    protected final BeanDefMapper getBeanDefMapper() {
        return this.beanDefMapper;
    }

    protected final Map<String, ObjectMap> getDefaultSchemas() {
        return this.defaultSchemas;
    }

    public Set<Pattern> getIgnoreTypes() {
        return this.ignoreTypes;
    }

    protected final boolean isUseBeanDefs() {
        return this.useBeanDefs;
    }

    public boolean isIgnoredType(ClassMeta<?> cm) {
        for (Pattern p : this.ignoreTypes) {
            if (!p.matcher(cm.getSimpleName()).matches() && !p.matcher(cm.getName()).matches()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ObjectMap toMap() {
        return super.toMap().append(PREFIX, new DefaultFilteringObjectMap().append("useBeanDefs", this.useBeanDefs).append("allowNestedExamples", this.allowNestedExamples).append("allowNestedDescriptions", this.allowNestedDescriptions).append("beanDefMapper", this.beanDefMapper).append("addExamplesTo", this.addExamplesTo).append("addDescriptionsTo", this.addDescriptionsTo).append("defaultSchemas", this.defaultSchemas).append("ignoreTypes", this.ignoreTypes));
    }
}

