/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.jena;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.jena.rdf.model.Bag;
import org.apache.jena.rdf.model.Container;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.NodeIterator;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFList;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.RDFReader;
import org.apache.jena.rdf.model.ResIterator;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Seq;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.juneau.BeanMap;
import org.apache.juneau.BeanMeta;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.BeanSession;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.DefaultFilteringObjectMap;
import org.apache.juneau.ExecutableException;
import org.apache.juneau.ObjectList;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.jena.RdfBeanMeta;
import org.apache.juneau.jena.RdfBeanPropertyMeta;
import org.apache.juneau.jena.RdfCollectionFormat;
import org.apache.juneau.jena.RdfParser;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.parser.ParserPipe;
import org.apache.juneau.parser.ParserSession;
import org.apache.juneau.parser.ParserSessionArgs;
import org.apache.juneau.parser.ReaderParser;
import org.apache.juneau.parser.ReaderParserSession;
import org.apache.juneau.transform.BuilderSwap;
import org.apache.juneau.transform.PojoSwap;
import org.apache.juneau.xml.Namespace;
import org.apache.juneau.xml.XmlUtils;

public class RdfParserSession
extends ReaderParserSession {
    private final RdfParser ctx;
    private final Property pRoot;
    private final Property pValue;
    private final Property pType;
    private final Property pRdfType;
    private final Model model;
    private final RDFReader rdfReader;
    private final Set<Resource> urisVisited = new HashSet<Resource>();

    protected RdfParserSession(RdfParser ctx, ParserSessionArgs args) {
        super((ReaderParser)ctx, args);
        this.ctx = ctx;
        this.model = ModelFactory.createDefaultModel();
        this.addModelPrefix(ctx.getJuneauNs());
        this.addModelPrefix(ctx.getJuneauBpNs());
        this.pRoot = this.model.createProperty(ctx.getJuneauNs().getUri(), "root");
        this.pValue = this.model.createProperty(ctx.getJuneauNs().getUri(), "value");
        this.pType = this.model.createProperty(ctx.getJuneauBpNs().getUri(), "_type");
        this.pRdfType = this.model.createProperty("http://www.w3.org/1999/02/22-rdf-syntax-ns#type");
        this.rdfReader = this.model.getReader(ctx.getLanguage());
        if (!ctx.getLanguage().equals("N-TRIPLE")) {
            for (Map.Entry<String, Object> e : ctx.jenaProperties.entrySet()) {
                this.rdfReader.setProperty(e.getKey(), e.getValue());
            }
        }
    }

    protected <T> T doParse(ParserPipe pipe, ClassMeta<T> type) throws IOException, ParseException, ExecutableException {
        RDFReader r = this.rdfReader;
        r.read(this.model, pipe.getBufferedReader(), null);
        List<Resource> roots = this.getRoots(this.model);
        if (this.isLooseCollections() && type.isCollectionOrArray()) {
            Object c = null;
            c = type.isArray() || type.isArgs() ? new ArrayList() : (type.canCreateNewInstance(this.getOuter()) ? (Collection)type.newInstance(this.getOuter()) : new ObjectList((BeanSession)this));
            int argIndex = 0;
            for (Resource resource : roots) {
                c.add(this.parseAnything(type.isArgs() ? type.getArg(argIndex++) : type.getElementType(), (RDFNode)resource, this.getOuter(), null));
            }
            if (type.isArray() || type.isArgs()) {
                return (T)this.toArray(type, (Collection)c);
            }
            return (T)c;
        }
        if (roots.isEmpty()) {
            return null;
        }
        if (roots.size() > 1) {
            throw new ParseException((ParserSession)this, "Too many root nodes found in model:  {0}", new Object[]{roots.size()});
        }
        Resource resource = roots.get(0);
        return this.parseAnything(type, (RDFNode)resource, this.getOuter(), null);
    }

    private final void addModelPrefix(Namespace ns) {
        this.model.setNsPrefix(ns.getName(), ns.getUri());
    }

    private String decodeString(Object o) {
        if (o == null) {
            return null;
        }
        String s = o.toString();
        if (s.isEmpty()) {
            return s;
        }
        if (this.isTrimWhitespace()) {
            s = s.trim();
        }
        s = XmlUtils.decode((String)s, null);
        if (this.isTrimStrings()) {
            s = s.trim();
        }
        return s;
    }

    private List<Resource> getRoots(Model m) {
        LinkedList<Resource> l = new LinkedList<Resource>();
        Property root = m.createProperty(this.getJuneauNs().getUri(), "root");
        ResIterator i = m.listResourcesWithProperty(root);
        while (i.hasNext()) {
            l.add((Resource)i.next());
        }
        if (!l.isEmpty()) {
            return l;
        }
        HashSet<RDFNode> objects = new HashSet<RDFNode>();
        StmtIterator i2 = m.listStatements();
        while (i2.hasNext()) {
            Statement st = (Statement)i2.next();
            Resource subject = st.getSubject();
            RDFNode object = st.getObject();
            if (!object.isResource() || object.equals(subject)) continue;
            objects.add(object);
        }
        i2 = m.listSubjects();
        while (i2.hasNext()) {
            Resource r = (Resource)i2.next();
            if (objects.contains(r)) continue;
            l.add(r);
        }
        return l;
    }

    private <T> BeanMap<T> parseIntoBeanMap(Resource r2, BeanMap<T> m) throws IOException, ParseException, ExecutableException {
        BeanMeta bm = m.getMeta();
        RdfBeanMeta rbm = (RdfBeanMeta)bm.getExtendedMeta(RdfBeanMeta.class);
        if (rbm.hasBeanUri() && r2.getURI() != null) {
            rbm.getBeanUriProperty().set(m, null, (Object)r2.getURI());
        }
        StmtIterator i = r2.listProperties();
        while (i.hasNext()) {
            Statement st = (Statement)i.next();
            Property p = st.getPredicate();
            String key = this.decodeString(p.getLocalName());
            BeanPropertyMeta pMeta = m.getPropertyMeta(key);
            this.setCurrentProperty(pMeta);
            if (pMeta != null) {
                RDFNode o = st.getObject();
                ClassMeta cm = pMeta.getClassMeta();
                if (cm.isCollectionOrArray() && this.isMultiValuedCollections(pMeta)) {
                    ClassMeta et = cm.getElementType();
                    T value = this.parseAnything(et, o, m.getBean(false), pMeta);
                    RdfParserSession.setName((ClassMeta)et, value, (Object)key);
                    pMeta.add(m, key, value);
                } else {
                    T value = this.parseAnything(cm, o, m.getBean(false), pMeta);
                    RdfParserSession.setName((ClassMeta)cm, value, (Object)key);
                    pMeta.set(m, key, value);
                }
            } else if (!p.equals(this.pRoot) && !p.equals(this.pType)) {
                this.onUnknownProperty(key, m);
            }
            this.setCurrentProperty(null);
        }
        return m;
    }

    private boolean isMultiValuedCollections(BeanPropertyMeta pMeta) {
        RdfBeanPropertyMeta bpRdf;
        RdfBeanPropertyMeta rdfBeanPropertyMeta = bpRdf = pMeta == null ? RdfBeanPropertyMeta.DEFAULT : (RdfBeanPropertyMeta)pMeta.getExtendedMeta(RdfBeanPropertyMeta.class);
        if (bpRdf.getCollectionFormat() != RdfCollectionFormat.DEFAULT) {
            return bpRdf.getCollectionFormat() == RdfCollectionFormat.MULTI_VALUED;
        }
        return this.getCollectionFormat() == RdfCollectionFormat.MULTI_VALUED;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private <T> T parseAnything(ClassMeta<?> eType, RDFNode n, Object outer, BeanPropertyMeta pMeta) throws IOException, ParseException, ExecutableException {
        void var8_37;
        void var8_35;
        String c;
        ClassMeta tcm;
        Statement statement;
        if (eType == null) {
            eType = this.object();
        }
        PojoSwap swap = eType.getPojoSwap((BeanSession)this);
        BuilderSwap builder = eType.getBuilderSwap((BeanSession)this);
        ClassMeta sType = null;
        sType = builder != null ? builder.getBuilderClassMeta((BeanSession)this) : (swap != null ? swap.getSwapClassMeta((BeanSession)this) : eType);
        this.setCurrentClass(sType);
        if (!sType.canCreateNewInstance(outer) && n.isResource() && (statement = n.asResource().getProperty(this.pType)) != null && (tcm = this.getClassMeta(c = statement.getLiteral().getString(), pMeta, eType)) != null) {
            sType = eType = tcm;
        }
        Object var8_9 = null;
        if (!n.isResource() || n.asResource().getURI() == null || !n.asResource().getURI().equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#nil")) {
            BeanMap bm;
            Object m;
            Resource r;
            if (sType.isObject()) {
                if (n.isLiteral()) {
                    Object object = n.asLiteral().getValue();
                    if (object instanceof String) {
                        String string = this.decodeString(object);
                    }
                } else {
                    if (!n.isResource()) throw new ParseException((ParserSession)this, "Unrecognized node type ''{0}'' for object", new Object[]{n});
                    r = n.asResource();
                    if (!this.urisVisited.add(r)) {
                        String string = r.getURI();
                    } else if (r.getProperty(this.pValue) != null) {
                        T t = this.parseAnything(this.object(), n.asResource().getProperty(this.pValue).getObject(), outer, null);
                    } else if (this.isSeq((RDFNode)r)) {
                        ObjectList objectList = new ObjectList((BeanSession)this);
                        this.parseIntoCollection((Container)r.as(Seq.class), (Collection)objectList, sType, pMeta);
                    } else if (this.isBag((RDFNode)r)) {
                        ObjectList objectList = new ObjectList((BeanSession)this);
                        this.parseIntoCollection((Container)r.as(Bag.class), (Collection)objectList, sType, pMeta);
                    } else if (r.canAs(RDFList.class)) {
                        ObjectList objectList = new ObjectList((BeanSession)this);
                        this.parseIntoCollection((RDFList)r.as(RDFList.class), (Collection)objectList, sType, pMeta);
                    } else {
                        String uri = r.getURI();
                        if (uri != null && !r.listProperties().hasNext()) {
                            String string = r.getURI();
                        } else {
                            ObjectMap m2 = new ObjectMap((BeanSession)this);
                            this.parseIntoMap(r, (Map)m2, null, null, pMeta);
                            Object object = this.cast(m2, pMeta, eType);
                        }
                    }
                }
            } else if (sType.isBoolean()) {
                Object object = this.convertToType(this.getValue(n, outer), Boolean.TYPE);
            } else if (sType.isCharSequence()) {
                String string = this.decodeString(this.getValue(n, outer));
            } else if (sType.isChar()) {
                Character c2 = StringUtils.parseCharacter((Object)this.decodeString(this.getValue(n, outer)));
            } else if (sType.isNumber()) {
                Number number = StringUtils.parseNumber((String)this.getValue(n, outer).toString(), (Class)sType.getInnerClass());
            } else if (sType.isMap()) {
                r = n.asResource();
                if (!this.urisVisited.add(r)) {
                    return null;
                }
                m = sType.canCreateNewInstance(outer) ? (Map)sType.newInstance(outer) : new ObjectMap((BeanSession)this);
                Map map = this.parseIntoMap(r, (Map)m, (ClassMeta)eType.getKeyType(), (ClassMeta)eType.getValueType(), pMeta);
            } else if (sType.isCollectionOrArray() || sType.isArgs()) {
                void var8_27;
                if (sType.isArray() || sType.isArgs()) {
                    ArrayList arrayList = new ArrayList();
                } else {
                    Object object = sType.canCreateNewInstance(outer) ? (Collection)sType.newInstance(outer) : new ObjectList((BeanSession)this);
                }
                r = n.asResource();
                if (!this.urisVisited.add(r)) {
                    return null;
                }
                if (this.isSeq((RDFNode)r)) {
                    this.parseIntoCollection((Container)r.as(Seq.class), (Collection)var8_27, sType, pMeta);
                } else if (this.isBag((RDFNode)r)) {
                    this.parseIntoCollection((Container)r.as(Bag.class), (Collection)var8_27, sType, pMeta);
                } else {
                    if (!r.canAs(RDFList.class)) throw new ParseException((ParserSession)this, "Unrecognized node type ''{0}'' for collection", new Object[]{n});
                    this.parseIntoCollection((RDFList)r.as(RDFList.class), (Collection)var8_27, sType, pMeta);
                }
                if (sType.isArray() || sType.isArgs()) {
                    Object object = this.toArray(sType, (Collection)var8_27);
                }
            } else if (builder != null) {
                r = n.asResource();
                if (!this.urisVisited.add(r)) {
                    return null;
                }
                bm = this.toBeanMap(builder.create((BeanSession)this, eType));
                Object object = builder.build((BeanSession)this, this.parseIntoBeanMap(r, bm).getBean(), eType);
            } else if (sType.canCreateNewBean(outer)) {
                r = n.asResource();
                if (!this.urisVisited.add(r)) {
                    return null;
                }
                bm = this.newBeanMap(outer, sType.getInnerClass());
                Object object = this.parseIntoBeanMap(r, bm).getBean();
            } else if (sType.isUri() && n.isResource()) {
                Object object = sType.newInstanceFromString(outer, this.decodeString(n.asResource().getURI()));
            } else if (sType.canCreateNewInstanceFromString(outer)) {
                Object object = sType.newInstanceFromString(outer, this.decodeString(this.getValue(n, outer)));
            } else {
                if (!n.isResource()) throw new ParseException((ParserSession)this, "Class ''{0}'' could not be instantiated.  Reason: ''{1}''", new Object[]{sType.getInnerClass().getName(), sType.getNotABeanReason()});
                r = n.asResource();
                m = new ObjectMap((BeanSession)this);
                this.parseIntoMap(r, (Map)m, (ClassMeta)sType.getKeyType(), (ClassMeta)sType.getValueType(), pMeta);
                if (!m.containsKey(this.getBeanTypePropertyName(eType))) throw new ParseException((ParserSession)this, "Class ''{0}'' could not be instantiated.  Reason: ''{1}''", new Object[]{sType.getInnerClass().getName(), sType.getNotABeanReason()});
                Object object = this.cast((ObjectMap)m, pMeta, eType);
            }
        }
        if (swap != null && var8_35 != null) {
            Object object = this.unswap(swap, var8_35, eType);
        }
        if (outer == null) return var8_37;
        RdfParserSession.setParent((ClassMeta)eType, (Object)var8_37, (Object)outer);
        return var8_37;
    }

    private boolean isSeq(RDFNode n) {
        Statement st;
        if (n.isResource() && (st = n.asResource().getProperty(this.pRdfType)) != null) {
            return "http://www.w3.org/1999/02/22-rdf-syntax-ns#Seq".equals(st.getResource().getURI());
        }
        return false;
    }

    private boolean isBag(RDFNode n) {
        Statement st;
        if (n.isResource() && (st = n.asResource().getProperty(this.pRdfType)) != null) {
            return "http://www.w3.org/1999/02/22-rdf-syntax-ns#Bag".equals(st.getResource().getURI());
        }
        return false;
    }

    private Object getValue(RDFNode n, Object outer) throws IOException, ParseException, ExecutableException {
        Statement st;
        if (n.isLiteral()) {
            return n.asLiteral().getValue();
        }
        if (n.isResource() && (st = n.asResource().getProperty(this.pValue)) != null) {
            n = st.getObject();
            if (n.isLiteral()) {
                return n.asLiteral().getValue();
            }
            return this.parseAnything(this.object(), st.getObject(), outer, null);
        }
        throw new ParseException((ParserSession)this, "Unknown value type for node ''{0}''", new Object[]{n});
    }

    private <K, V> Map<K, V> parseIntoMap(Resource r, Map<K, V> m, ClassMeta<K> keyType, ClassMeta<V> valueType, BeanPropertyMeta pMeta) throws IOException, ParseException, ExecutableException {
        if (r.getURI() != null) {
            Object uri = this.convertAttrToType(m, "uri", keyType);
            Object value = this.convertAttrToType(m, r.getURI(), valueType);
            m.put(uri, value);
        }
        StmtIterator i = r.listProperties();
        while (i.hasNext()) {
            Statement st = (Statement)i.next();
            Property p = st.getPredicate();
            String key = p.getLocalName();
            if (key.equals("root") && p.getURI().equals(this.getJuneauNs().getUri())) continue;
            key = this.decodeString(key);
            RDFNode o = st.getObject();
            Object key2 = this.convertAttrToType(m, key, keyType);
            Object value = this.parseAnything(valueType, o, m, pMeta);
            RdfParserSession.setName(valueType, value, (Object)key);
            m.put(key2, value);
        }
        return m;
    }

    private <E> Collection<E> parseIntoCollection(Container c, Collection<E> l, ClassMeta<?> type, BeanPropertyMeta pMeta) throws IOException, ParseException, ExecutableException {
        int argIndex = 0;
        NodeIterator ni = c.iterator();
        while (ni.hasNext()) {
            Object e = this.parseAnything(type.isArgs() ? type.getArg(argIndex++) : type.getElementType(), ni.next(), l, pMeta);
            l.add(e);
        }
        return l;
    }

    private <E> Collection<E> parseIntoCollection(RDFList list, Collection<E> l, ClassMeta<?> type, BeanPropertyMeta pMeta) throws IOException, ParseException, ExecutableException {
        int argIndex = 0;
        ExtendedIterator ni = list.iterator();
        while (ni.hasNext()) {
            Object e = this.parseAnything(type.isArgs() ? type.getArg(argIndex++) : type.getElementType(), (RDFNode)ni.next(), l, pMeta);
            l.add(e);
        }
        return l;
    }

    protected final RdfCollectionFormat getCollectionFormat() {
        return this.ctx.getCollectionFormat();
    }

    protected final Namespace getJuneauBpNs() {
        return this.ctx.getJuneauBpNs();
    }

    protected final Namespace getJuneauNs() {
        return this.ctx.getJuneauNs();
    }

    protected final String getLanguage() {
        return this.ctx.getLanguage();
    }

    protected final boolean isLooseCollections() {
        return this.ctx.isLooseCollections();
    }

    protected final Map<String, Object> getJenaProperties() {
        return this.ctx.getJenaProperties();
    }

    protected final boolean isTrimWhitespace() {
        return this.ctx.isTrimWhitespace();
    }

    public ObjectMap toMap() {
        return super.toMap().append("RdfParserSession", (Object)new DefaultFilteringObjectMap());
    }
}

