/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.xml;

import java.util.List;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.ClassMetaExtended;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.reflect.ClassInfo;
import org.apache.juneau.xml.Namespace;
import org.apache.juneau.xml.XmlUtils;
import org.apache.juneau.xml.annotation.Xml;
import org.apache.juneau.xml.annotation.XmlFormat;
import org.apache.juneau.xml.annotation.XmlSchema;

public class XmlClassMeta
extends ClassMetaExtended {
    private final Namespace namespace;
    private final Xml xml;
    private final XmlFormat format;
    private final String childName;

    public XmlClassMeta(ClassMeta<?> cm) {
        super(cm);
        this.namespace = XmlClassMeta.findNamespace(cm);
        this.xml = cm.getInfo().getAnnotation(Xml.class);
        if (this.xml != null) {
            this.format = this.xml.format();
            this.childName = StringUtils.nullIfEmpty(this.xml.childName());
        } else {
            this.format = XmlFormat.DEFAULT;
            this.childName = null;
        }
    }

    protected Xml getAnnotation() {
        return this.xml;
    }

    protected XmlFormat getFormat() {
        return this.format;
    }

    protected String getChildName() {
        return this.childName;
    }

    public Namespace getNamespace() {
        return this.namespace;
    }

    private static Namespace findNamespace(ClassMeta<?> cm) {
        if (cm == null) {
            return null;
        }
        ClassInfo ci = cm.getInfo();
        List<Xml> xmls = ci.getAnnotations(Xml.class);
        List<XmlSchema> schemas = ci.getAnnotations(XmlSchema.class);
        return XmlUtils.findNamespace(xmls, schemas);
    }
}

