/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.urlencoding;

import org.apache.juneau.DefaultFilteringObjectMap;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.annotation.ConfigurableContext;
import org.apache.juneau.serializer.SerializerSessionArgs;
import org.apache.juneau.uon.UonSerializer;
import org.apache.juneau.urlencoding.UrlEncodingSerializerBuilder;
import org.apache.juneau.urlencoding.UrlEncodingSerializerSession;

@ConfigurableContext
public class UrlEncodingSerializer
extends UonSerializer {
    static final String PREFIX = "UrlEncodingSerializer";
    public static final String URLENC_expandedParams = "UrlEncodingSerializer.expandedParams.b";
    public static final UrlEncodingSerializer DEFAULT = new UrlEncodingSerializer(PropertyStore.DEFAULT);
    public static final UrlEncodingSerializer DEFAULT_PLAINTEXT = new PlainText(PropertyStore.DEFAULT);
    public static final UrlEncodingSerializer DEFAULT_EXPANDED = new Expanded(PropertyStore.DEFAULT);
    public static final UrlEncodingSerializer DEFAULT_READABLE = new Readable(PropertyStore.DEFAULT);
    private final boolean expandedParams = this.getBooleanProperty("UrlEncodingSerializer.expandedParams.b", false);

    public UrlEncodingSerializer(PropertyStore ps) {
        this(ps, "application/x-www-form-urlencoded", null);
    }

    public UrlEncodingSerializer(PropertyStore ps, String produces, String accept) {
        super(ps.builder().set("UonSerializer.encoding.b", true).build(), produces, accept);
    }

    @Override
    public UrlEncodingSerializerBuilder builder() {
        return new UrlEncodingSerializerBuilder(this.getPropertyStore());
    }

    public static UrlEncodingSerializerBuilder create() {
        return new UrlEncodingSerializerBuilder();
    }

    @Override
    public UrlEncodingSerializerSession createSession() {
        return this.createSession(this.createDefaultSessionArgs());
    }

    @Override
    public UrlEncodingSerializerSession createSession(SerializerSessionArgs args) {
        return new UrlEncodingSerializerSession(this, null, args);
    }

    protected final boolean isExpandedParams() {
        return this.expandedParams;
    }

    @Override
    public ObjectMap toMap() {
        return super.toMap().append(PREFIX, new DefaultFilteringObjectMap().append("expandedParams", this.expandedParams));
    }

    public static class PlainText
    extends UrlEncodingSerializer {
        public PlainText(PropertyStore ps) {
            super(ps.builder().set("UonSerializer.paramFormat.s", "PLAINTEXT").build());
        }
    }

    public static class Readable
    extends UrlEncodingSerializer {
        public Readable(PropertyStore ps) {
            super(ps.builder().set("WriterSerializer.useWhitespace.b", true).build());
        }
    }

    public static class Expanded
    extends UrlEncodingSerializer {
        public Expanded(PropertyStore ps) {
            super(ps.builder().set(UrlEncodingSerializer.URLENC_expandedParams, true).build());
        }
    }
}

