/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.transform;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;
import org.apache.juneau.BeanSession;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.annotation.BeanIgnore;
import org.apache.juneau.internal.ClassUtils;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.reflect.ClassInfo;
import org.apache.juneau.reflect.ConstructorInfo;
import org.apache.juneau.reflect.MethodInfo;
import org.apache.juneau.serializer.SerializeException;
import org.apache.juneau.transform.PojoSwap;

public class SurrogateSwap<T, F>
extends PojoSwap<T, F> {
    private Constructor<F> constructor;
    private Method unswapMethod;

    protected SurrogateSwap(Class<T> forClass, Constructor<F> constructor, Method unswapMethod) {
        super(forClass, constructor.getDeclaringClass());
        this.constructor = constructor;
        this.unswapMethod = unswapMethod;
    }

    public static List<SurrogateSwap<?, ?>> findPojoSwaps(Class<?> c) {
        LinkedList l = new LinkedList();
        ClassInfo ci = ClassUtils.getClassInfo(c);
        for (ConstructorInfo cc : ci.getPublicConstructors()) {
            Class<?> pt;
            if (cc.getAnnotation(BeanIgnore.class) != null || !cc.hasNumParams(1) || !cc.isPublic() || (pt = cc.getRawParamType(0)).equals(c.getDeclaringClass())) continue;
            Method unswapMethod = null;
            for (MethodInfo m : ci.getPublicMethods()) {
                if (!m.getReturnType().is(pt) || !m.isPublic()) continue;
                unswapMethod = m.inner();
            }
            l.add(new SurrogateSwap(pt, cc.inner(), unswapMethod));
        }
        return l;
    }

    @Override
    public F swap(BeanSession session, T o) throws SerializeException {
        try {
            return this.constructor.newInstance(o);
        }
        catch (Exception e) {
            throw new SerializeException(e);
        }
    }

    @Override
    public T unswap(BeanSession session, F f, ClassMeta<?> hint) throws ParseException {
        if (this.unswapMethod == null) {
            throw new ParseException("unswap() method not implement on surrogate class ''{1}''", f.getClass().getName(), this.getNormalClass().getFullName());
        }
        try {
            return (T)this.unswapMethod.invoke(f, new Object[0]);
        }
        catch (Exception e) {
            throw new ParseException(e);
        }
    }
}

