/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.transform;

import org.apache.juneau.PropertyNamer;
import org.apache.juneau.internal.ClassUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.transform.BeanFilterBuilder;
import org.apache.juneau.transform.PropertyFilter;

public final class BeanFilter {
    private final Class<?> beanClass;
    private final String[] properties;
    private final String[] excludeProperties;
    private final PropertyNamer propertyNamer;
    private final Class<?> interfaceClass;
    private final Class<?> stopClass;
    private final boolean sortProperties;
    private final boolean fluentSetters;
    private final String typeName;
    private final Class<?>[] beanDictionary;
    private final PropertyFilter propertyFilter;

    BeanFilter(BeanFilterBuilder<?> builder) {
        this.beanClass = builder.beanClass;
        this.typeName = builder.typeName;
        this.properties = StringUtils.split(builder.includeProperties, ',');
        this.excludeProperties = StringUtils.split(builder.excludeProperties, ',');
        this.interfaceClass = builder.interfaceClass;
        this.stopClass = builder.stopClass;
        this.sortProperties = builder.sortProperties;
        this.fluentSetters = builder.fluentSetters;
        this.propertyNamer = ClassUtils.castOrCreate(PropertyNamer.class, builder.propertyNamer);
        this.beanDictionary = builder.beanDictionary == null ? null : builder.beanDictionary.toArray(new Class[builder.beanDictionary.size()]);
        this.propertyFilter = builder.propertyFilter == null ? PropertyFilter.DEFAULT : ClassUtils.castOrCreate(PropertyFilter.class, builder.propertyFilter);
    }

    public Class<?> getBeanClass() {
        return this.beanClass;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String[] getProperties() {
        return this.properties;
    }

    public Class<?>[] getBeanDictionary() {
        return this.beanDictionary;
    }

    public boolean isSortProperties() {
        return this.sortProperties;
    }

    public boolean isFluentSetters() {
        return this.fluentSetters;
    }

    public String[] getExcludeProperties() {
        return this.excludeProperties;
    }

    public PropertyNamer getPropertyNamer() {
        return this.propertyNamer;
    }

    public Class<?> getInterfaceClass() {
        return this.interfaceClass;
    }

    public Class<?> getStopClass() {
        return this.stopClass;
    }

    public Object readProperty(Object bean, String name, Object value) {
        return this.propertyFilter.readProperty(bean, name, value);
    }

    public Object writeProperty(Object bean, String name, Object value) {
        return this.propertyFilter.writeProperty(bean, name, value);
    }
}

