/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.soap;

import org.apache.juneau.DefaultFilteringObjectMap;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.annotation.ConfigurableContext;
import org.apache.juneau.serializer.SerializerSessionArgs;
import org.apache.juneau.soap.SoapXmlSerializerBuilder;
import org.apache.juneau.soap.SoapXmlSerializerSession;
import org.apache.juneau.xml.XmlSerializer;

@ConfigurableContext
public final class SoapXmlSerializer
extends XmlSerializer {
    static final String PREFIX = "SoapXmlSerializer";
    public static final String SOAPXML_SOAPAction = "SoapXmlSerializer.SOAPAction.s";
    final String soapAction = this.getStringProperty("SoapXmlSerializer.SOAPAction.s", "http://www.w3.org/2003/05/soap-envelope");

    public SoapXmlSerializer(PropertyStore ps) {
        super(ps, "text/xml", "text/xml+soap");
    }

    @Override
    public SoapXmlSerializerBuilder builder() {
        return new SoapXmlSerializerBuilder(this.getPropertyStore());
    }

    public static SoapXmlSerializerBuilder create() {
        return new SoapXmlSerializerBuilder();
    }

    @Override
    public SoapXmlSerializerSession createSession() {
        return this.createSession(this.createDefaultSessionArgs());
    }

    @Override
    public SoapXmlSerializerSession createSession(SerializerSessionArgs args) {
        return new SoapXmlSerializerSession(this, args);
    }

    public String getSoapAction() {
        return this.soapAction;
    }

    @Override
    public ObjectMap toMap() {
        return super.toMap().append(PREFIX, new DefaultFilteringObjectMap().append("soapAction", this.soapAction));
    }
}

