/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.reshandlers;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.Map;
import org.apache.juneau.http.MediaType;
import org.apache.juneau.httppart.HttpPart;
import org.apache.juneau.httppart.HttpPartSchema;
import org.apache.juneau.httppart.HttpPartType;
import org.apache.juneau.httppart.bean.ResponseBeanMeta;
import org.apache.juneau.httppart.bean.ResponseBeanPropertyMeta;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.rest.ResponseHandler;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.rest.RestResponse;
import org.apache.juneau.rest.exception.InternalServerError;
import org.apache.juneau.rest.exception.NotAcceptable;
import org.apache.juneau.rest.util.FinishablePrintWriter;
import org.apache.juneau.rest.util.FinishableServletOutputStream;
import org.apache.juneau.serializer.SerializeException;
import org.apache.juneau.serializer.Serializer;
import org.apache.juneau.serializer.SerializerGroup;
import org.apache.juneau.serializer.SerializerMatch;
import org.apache.juneau.serializer.SerializerSession;
import org.apache.juneau.serializer.SerializerSessionArgs;

public class DefaultHandler
implements ResponseHandler {
    @Override
    public boolean handle(RestRequest req, RestResponse res) throws IOException, InternalServerError, NotAcceptable {
        SerializerGroup g = res.getSerializers();
        String accept = req.getHeaders().getString("Accept", "");
        SerializerMatch sm = g.getSerializerMatch(accept);
        HttpPartSchema schema = null;
        Object o = res.getOutput();
        ResponseBeanMeta rm = res.getResponseMeta();
        if (rm == null) {
            rm = req.getResponseBeanMeta(o);
        }
        if (rm != null) {
            ResponseBeanPropertyMeta stm;
            boolean isThrowable = rm.getClassMeta().isType(Throwable.class);
            if (isThrowable) {
                res.setHeader("Exception-Name", rm.getClassMeta().getName());
                res.setHeader("Exception-Message", ((Throwable)o).getMessage());
            }
            if ((stm = rm.getStatusMethod()) != null) {
                try {
                    res.setStatus((Integer)stm.getGetter().invoke(o, new Object[0]));
                }
                catch (Exception e) {
                    throw new InternalServerError((Throwable)e, "Could not get status.", new Object[0]);
                }
            } else if (rm.getCode() != 0) {
                res.setStatus(rm.getCode());
            }
            for (ResponseBeanPropertyMeta hm : rm.getHeaderMethods()) {
                try {
                    Object ho = hm.getGetter().invoke(o, new Object[0]);
                    String n = hm.getPartName();
                    if ("*".equals(n) && ho instanceof Map) {
                        Map m = (Map)ho;
                        for (Object key : m.keySet()) {
                            String k = StringUtils.stringify(key);
                            Object v = m.get(key);
                            HttpPartSchema s = hm.getSchema().getProperty(k);
                            res.setHeader(new HttpPart(k, HttpPartType.RESPONSE_HEADER, s, hm.getSerializer(req.getPartSerializer()), req.getSerializerSessionArgs(), v));
                        }
                        continue;
                    }
                    res.setHeader(new HttpPart(n, HttpPartType.RESPONSE_HEADER, hm.getSchema(), hm.getSerializer(req.getPartSerializer()), req.getSerializerSessionArgs(), ho));
                }
                catch (Exception e) {
                    throw new InternalServerError((Throwable)e, "Could not set header ''{0}''", hm.getPartName());
                }
            }
            ResponseBeanPropertyMeta bm = rm.getBodyMethod();
            if (bm != null) {
                Method m = bm.getGetter();
                try {
                    Class<?>[] pt = m.getParameterTypes();
                    if (pt.length == 1) {
                        Class<?> ptt = pt[0];
                        if (ptt == OutputStream.class) {
                            m.invoke(o, res.getOutputStream());
                        } else if (ptt == Writer.class) {
                            m.invoke(o, res.getWriter());
                        }
                        return true;
                    }
                    o = m.invoke(o, new Object[0]);
                }
                catch (Exception e) {
                    throw new InternalServerError((Throwable)e, "Could not get body.", new Object[0]);
                }
            }
            schema = rm.getSchema();
        }
        if (sm != null) {
            MediaType responseType;
            Serializer s = sm.getSerializer();
            MediaType mediaType = res.getMediaType();
            if (mediaType == null) {
                mediaType = sm.getMediaType();
            }
            if ((responseType = s.getResponseContentType()) == null) {
                responseType = mediaType;
            }
            res.setContentType(responseType.toString());
            try {
                FinishablePrintWriter w;
                if (req.isPlainText()) {
                    res.setContentType("text/plain");
                }
                SerializerSession session = s.createSession(SerializerSessionArgs.create().properties(req.getAttributes()).javaMethod(req.getJavaMethod()).locale(req.getLocale()).timeZone(req.getHeaders().getTimeZone()).mediaType(mediaType).streamCharset(res.getCharset()).schema(schema).debug(req.isDebug() ? Boolean.valueOf(true) : null).uriContext(req.getUriContext()).useWhitespace(req.isPlainText() ? Boolean.valueOf(true) : null).resolver(req.getVarResolverSession()));
                for (Map.Entry<String, String> h : session.getResponseHeaders().entrySet()) {
                    res.setHeader(h.getKey(), h.getValue());
                }
                if (!session.isWriterSerializer()) {
                    if (req.isPlainText()) {
                        w = res.getNegotiatedWriter();
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        session.serialize(o, baos);
                        w.write(StringUtils.toSpacedHex(baos.toByteArray()));
                        w.flush();
                        w.finish();
                    } else {
                        FinishableServletOutputStream os = res.getNegotiatedOutputStream();
                        session.serialize(o, os);
                        os.flush();
                        os.finish();
                    }
                } else {
                    w = res.getNegotiatedWriter();
                    session.serialize(o, w);
                    w.flush();
                    w.finish();
                }
            }
            catch (SerializeException e) {
                throw new InternalServerError(e);
            }
            return true;
        }
        if (o != null && (StringUtils.isEmpty(accept) || accept.startsWith("text/plain"))) {
            String out = null;
            if (StringUtils.isEmpty(res.getContentType())) {
                res.setContentType("text/plain");
            }
            out = req.getBeanSession().getClassMetaForObject(o).toString(o);
            FinishablePrintWriter w = res.getNegotiatedWriter();
            w.append(out);
            w.flush();
            w.finish();
            return true;
        }
        throw new NotAcceptable("Unsupported media-type in request header ''Accept'': ''{0}''\n\tSupported media-types: {1}", req.getHeaders().getString("Accept", ""), g.getSupportedMediaTypes());
    }
}

