/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.remote;

import java.io.Reader;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.juneau.dto.LinkString;
import org.apache.juneau.dto.html5.Div;
import org.apache.juneau.dto.html5.HtmlBuilder;
import org.apache.juneau.dto.html5.Table;
import org.apache.juneau.html.annotation.HtmlDocConfig;
import org.apache.juneau.http.ContentType;
import org.apache.juneau.http.annotation.Header;
import org.apache.juneau.http.annotation.Path;
import org.apache.juneau.internal.ClassUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.parser.ReaderParser;
import org.apache.juneau.remote.RemoteInterfaceMeta;
import org.apache.juneau.remote.RemoteInterfaceMethod;
import org.apache.juneau.rest.BasicRestServlet;
import org.apache.juneau.rest.annotation.MethodSwagger;
import org.apache.juneau.rest.annotation.RestMethod;
import org.apache.juneau.rest.exception.NotFound;
import org.apache.juneau.rest.exception.UnsupportedMediaType;

public abstract class RrpcServlet
extends BasicRestServlet {
    private final Map<String, RemoteInterfaceMeta> serviceMap = new ConcurrentHashMap<String, RemoteInterfaceMeta>();

    protected abstract Map<Class<?>, Object> getServiceMap() throws Exception;

    @RestMethod(name="GET", path="/", summary="List of available remote interfaces", description={"Shows a list of the interfaces registered with this remote interface servlet."})
    public List<LinkString> getInterfaces() throws Exception {
        LinkedList<LinkString> l = new LinkedList<LinkString>();
        for (Class<?> c : this.getServiceMap().keySet()) {
            l.add(new LinkString(c.getName(), "servlet:/{0}", StringUtils.urlEncode(c.getName())));
        }
        return l;
    }

    @RestMethod(name="GET", path="/{javaInterface}", summary="List of available methods on interface", description={"Shows a list of all the exposed methods on an interface."})
    @HtmlDocConfig(nav={"<h5>Interface:  $RP{javaInterface}</h5>"})
    public Collection<LinkString> listMethods(@Path(name="javaInterface", description={"Java interface name"}, example={"com.foo.MyInterface"}) String javaInterface) throws Exception {
        ArrayList<LinkString> l = new ArrayList<LinkString>();
        for (String s : this.getMethods(javaInterface).keySet()) {
            l.add(new LinkString(s, "servlet:/{0}/{1}", StringUtils.urlEncode(javaInterface), StringUtils.urlEncode(s)));
        }
        return l;
    }

    @RestMethod(name="GET", path="/{javaInterface}/{javaMethod}", summary="Form entry for interface method call", description={"Shows a form entry page for executing a remote interface method."})
    @HtmlDocConfig(nav={"<h5>Interface:  $RP{javaInterface}</h5>", "<h5>Method:  $RP{javaMethod}</h5>"})
    public Div showEntryForm(@Path(name="javaInterface", description={"Java interface name"}, example={"com.foo.MyInterface"}) String javaInterface, @Path(name="javaMethod", description={"Java method name"}, example={"myMethod"}) String javaMethod) throws NotFound, Exception {
        RemoteInterfaceMethod rmm = this.getMethods(javaInterface).get(javaMethod);
        if (rmm == null) {
            throw new NotFound("Method not found");
        }
        Table t = HtmlBuilder.table();
        Type[] types = rmm.getJavaMethod().getGenericParameterTypes();
        if (types.length == 0) {
            t.child(HtmlBuilder.tr(HtmlBuilder.td("No arguments").colspan(3).style("text-align:center")));
        } else {
            t.child(HtmlBuilder.tr(HtmlBuilder.th("Index"), HtmlBuilder.th("Type"), HtmlBuilder.th("Value")));
            for (int i = 0; i < types.length; ++i) {
                String type = ClassUtils.toString(types[i]);
                t.child(HtmlBuilder.tr(HtmlBuilder.td(i), HtmlBuilder.td(type), HtmlBuilder.td(HtmlBuilder.input().name(String.valueOf(i)).type("text"))));
            }
        }
        t.child(HtmlBuilder.tr(HtmlBuilder.td().colspan(3).style("text-align:right").children(types.length == 0 ? null : HtmlBuilder.button("reset", "Reset"), HtmlBuilder.button("button", "Cancel").onclick("window.location.href='/'"), HtmlBuilder.button("submit", "Submit"))));
        return HtmlBuilder.div(HtmlBuilder.form().id("form").action("request:/").method("POST").children(t));
    }

    @RestMethod(name="POST", path="/{javaInterface}/{javaMethod}", summary="Invoke an interface method", description={"Invoke a Java method by passing in the arguments as an array of serialized objects.\nThe returned object is then serialized to the response."}, swagger=@MethodSwagger(parameters={"{", "in: 'body',", "description: 'Serialized array of Java objects',", "schema: {", "type': 'array'", "},", "x-examples: {", "'application/json+lax': '[\\'foo\\', 123, true]'", "}", "}"}, responses={"200:{ description:'The return object serialized', schema:{type:'any'},'x-example':{foo:123} }"}))
    @HtmlDocConfig(nav={"<h5>Interface:  $RP{javaInterface}</h5>", "<h5>Method:  $RP{javaMethod}</h5>"})
    public Object invoke(Reader r, ReaderParser p, @Header(value="Content-Type") ContentType contentType, @Path(name="javaInterface", description={"Java interface name"}, example={"com.foo.MyInterface"}) String javaInterface, @Path(name="javaMethod", description={"Java method name"}, example={"myMethod"}) String javaMethod) throws UnsupportedMediaType, NotFound, Exception {
        if (p == null) {
            throw new UnsupportedMediaType("Could not find parser for media type ''{0}''", contentType);
        }
        RemoteInterfaceMeta rim = this.getInterfaceClass(javaInterface);
        Object service = this.getServiceMap().get(rim.getJavaClass());
        if (service == null) {
            throw new NotFound("Service not found");
        }
        RemoteInterfaceMethod rmm = this.getMethods(javaInterface).get(javaMethod);
        if (rmm == null) {
            throw new NotFound("Method not found");
        }
        Method m = rmm.getJavaMethod();
        Object[] params = p.parseArgs(r, m.getGenericParameterTypes());
        return m.invoke(service, params);
    }

    private Map<String, RemoteInterfaceMethod> getMethods(String javaInterface) throws Exception {
        return this.getInterfaceClass(javaInterface).getMethodsByPath();
    }

    private RemoteInterfaceMeta getInterfaceClass(String javaInterface) throws NotFound, Exception {
        RemoteInterfaceMeta rm = this.serviceMap.get(javaInterface);
        if (rm == null) {
            for (Class<?> c : this.getServiceMap().keySet()) {
                if (!c.getName().equals(javaInterface)) continue;
                rm = new RemoteInterfaceMeta(c, null);
                this.serviceMap.put(javaInterface, rm);
                return rm;
            }
            throw new NotFound("Interface class not found");
        }
        return rm;
    }
}

