/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.mock2;

import java.util.Map;
import org.apache.juneau.marshall.Html;
import org.apache.juneau.marshall.Json;
import org.apache.juneau.marshall.Marshall;
import org.apache.juneau.marshall.MsgPack;
import org.apache.juneau.marshall.OpenApi;
import org.apache.juneau.marshall.PlainText;
import org.apache.juneau.marshall.SimpleJson;
import org.apache.juneau.marshall.Uon;
import org.apache.juneau.marshall.UrlEncoding;
import org.apache.juneau.marshall.Xml;
import org.apache.juneau.parser.Parser;
import org.apache.juneau.rest.client.RestClient;
import org.apache.juneau.rest.client.RestClientBuilder;
import org.apache.juneau.rest.mock2.MockHttpClientConnectionManager;
import org.apache.juneau.rest.mock2.MockRest;
import org.apache.juneau.serializer.Serializer;

public class MockRemoteResource<T> {
    private MockRest.Builder mrb;
    private RestClientBuilder rcb = RestClient.create().json();
    private final Class<T> intf;

    protected MockRemoteResource(Class<T> intf, Object impl) {
        this.intf = intf;
        this.mrb = MockRest.create(impl);
    }

    public static <T> MockRemoteResource<T> create(Class<T> intf, Object impl) {
        return new MockRemoteResource<T>(intf, impl);
    }

    public static <T> MockRemoteResource<T> create(Class<T> intf, Object impl, Marshall m) {
        return new MockRemoteResource<T>(intf, impl).marshall(m);
    }

    public static <T> MockRemoteResource<T> create(Class<T> intf, Object impl, Serializer s, Parser p) {
        return new MockRemoteResource<T>(intf, impl).serializer(s).parser(p);
    }

    public T build() {
        MockRest mr = this.mrb.build();
        return this.rcb.httpClientConnectionManager(new MockHttpClientConnectionManager(mr)).rootUrl("http://localhost").headers(mr.getHeaders()).build().getRemoteResource(this.intf);
    }

    public static <T> T build(Class<T> intf, Object impl) {
        return MockRemoteResource.create(intf, impl).build();
    }

    public static <T> T build(Class<T> intf, Object impl, Marshall m) {
        return MockRemoteResource.create(intf, impl).marshall(m).build();
    }

    public static <T> T build(Class<T> intf, Object impl, Serializer s, Parser p) {
        return MockRemoteResource.create(intf, impl).serializer(s).parser(p).build();
    }

    public MockRemoteResource<T> debug() {
        this.mrb.debug();
        this.rcb.debug();
        return this;
    }

    public MockRemoteResource<T> header(String name, Object value) {
        this.mrb.header(name, value);
        this.rcb.header(name, value);
        return this;
    }

    public MockRemoteResource<T> headers(Map<String, Object> value) {
        this.mrb.headers(value);
        this.rcb.headers(value);
        return this;
    }

    public MockRemoteResource<T> accept(String value) {
        this.mrb.accept(value);
        this.rcb.accept(value);
        return this;
    }

    public MockRemoteResource<T> contentType(String value) {
        this.mrb.contentType(value);
        this.rcb.contentType(value);
        return this;
    }

    public MockRemoteResource<T> json() {
        this.marshall(Json.DEFAULT);
        return this;
    }

    public MockRemoteResource<T> simpleJson() {
        this.marshall(SimpleJson.DEFAULT);
        return this;
    }

    public MockRemoteResource<T> xml() {
        this.marshall(Xml.DEFAULT);
        return this;
    }

    public MockRemoteResource<T> html() {
        this.marshall(Html.DEFAULT);
        return this;
    }

    public MockRemoteResource<T> plainText() {
        this.marshall(PlainText.DEFAULT);
        return this;
    }

    public MockRemoteResource<T> msgpack() {
        this.marshall(MsgPack.DEFAULT);
        return this;
    }

    public MockRemoteResource<T> uon() {
        this.marshall(Uon.DEFAULT);
        return this;
    }

    public MockRemoteResource<T> urlEnc() {
        this.marshall(UrlEncoding.DEFAULT);
        return this;
    }

    public MockRemoteResource<T> openapi() {
        this.marshall(OpenApi.DEFAULT);
        return this;
    }

    public MockRemoteResource<T> marshall(Marshall value) {
        if (value != null) {
            this.serializer(value.getSerializer()).parser(value.getParser());
        } else {
            this.serializer(null).parser(null);
        }
        return this;
    }

    public MockRemoteResource<T> serializer(Serializer value) {
        this.rcb.serializer(value);
        this.contentType(value == null ? null : value.getPrimaryMediaType().toString());
        return this;
    }

    public MockRemoteResource<T> parser(Parser value) {
        this.rcb.parser(value);
        this.accept(value == null ? null : value.getPrimaryMediaType().toString());
        return this;
    }
}

