/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.client.remote;

import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.juneau.internal.ClassUtils;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.reflect.ClassInfo;
import org.apache.juneau.reflect.MethodInfo;
import org.apache.juneau.rest.client.remote.RemoteMethodMeta;
import org.apache.juneau.rest.client.remote.RemoteResource;

public class RemoteResourceMeta {
    private final Map<Method, RemoteMethodMeta> methods;
    private final String path;

    public RemoteResourceMeta(Class<?> c) {
        String path = "";
        ClassInfo ci = ClassUtils.getClassInfo(c);
        for (RemoteResource r : ci.getAnnotationsParentFirst(RemoteResource.class)) {
            if (r.path().isEmpty()) continue;
            path = StringUtils.trimSlashes(r.path());
        }
        LinkedHashMap<Method, RemoteMethodMeta> methods = new LinkedHashMap<Method, RemoteMethodMeta>();
        for (MethodInfo m : ci.getPublicMethods()) {
            if (!m.isPublic()) continue;
            methods.put(m.inner(), new RemoteMethodMeta(path, m.inner(), false, "GET"));
        }
        this.methods = CollectionUtils.unmodifiableMap(methods);
        this.path = path;
    }

    public RemoteMethodMeta getMethodMeta(Method m) {
        return this.methods.get(m);
    }

    public String getPath() {
        return this.path;
    }
}

