/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.client.remote;

import java.lang.reflect.Type;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.http.annotation.Response;
import org.apache.juneau.httppart.bean.ResponseBeanMeta;
import org.apache.juneau.reflect.ClassInfo;
import org.apache.juneau.reflect.MethodInfo;
import org.apache.juneau.rest.client.remote.RemoteMethod;
import org.apache.juneau.rest.client.remote.RemoteReturn;

public final class RemoteMethodReturn {
    private final Type returnType;
    private final RemoteReturn returnValue;
    private final ResponseBeanMeta meta;

    RemoteMethodReturn(MethodInfo m) {
        RemoteReturn rv;
        RemoteMethod rm = m.getAnnotation(RemoteMethod.class);
        ClassInfo rt = m.getReturnType();
        RemoteReturn remoteReturn = rt.is(Void.TYPE) ? RemoteReturn.NONE : (rv = rm == null ? RemoteReturn.BODY : rm.returns());
        if (rt.hasAnnotation(Response.class) && rt.isInterface()) {
            this.meta = ResponseBeanMeta.create(m, PropertyStore.DEFAULT);
            rv = RemoteReturn.BEAN;
        } else {
            this.meta = null;
        }
        this.returnType = m.getReturnType().innerType();
        this.returnValue = rv;
    }

    public ResponseBeanMeta getResponseBeanMeta() {
        return this.meta;
    }

    public Type getReturnType() {
        return this.returnType;
    }

    public RemoteReturn getReturnValue() {
        return this.returnValue;
    }
}

