/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.client.remote;

import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.httppart.HttpPartType;
import org.apache.juneau.httppart.bean.RequestBeanMeta;
import org.apache.juneau.internal.ClassUtils;
import org.apache.juneau.internal.HttpUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.reflect.MethodInfo;
import org.apache.juneau.reflect.ParamInfo;
import org.apache.juneau.rest.client.remote.RemoteMetadataException;
import org.apache.juneau.rest.client.remote.RemoteMethod;
import org.apache.juneau.rest.client.remote.RemoteMethodArg;
import org.apache.juneau.rest.client.remote.RemoteMethodBeanArg;
import org.apache.juneau.rest.client.remote.RemoteMethodReturn;

public class RemoteMethodMeta {
    private final String httpMethod;
    private final String fullPath;
    private final String path;
    private final RemoteMethodArg[] pathArgs;
    private final RemoteMethodArg[] queryArgs;
    private final RemoteMethodArg[] headerArgs;
    private final RemoteMethodArg[] formDataArgs;
    private final RemoteMethodArg[] otherArgs;
    private final RemoteMethodBeanArg[] requestArgs;
    private final RemoteMethodArg bodyArg;
    private final RemoteMethodReturn methodReturn;
    private final Method method;
    private final Class<?>[] exceptions;

    public RemoteMethodMeta(String parentPath, Method m, boolean useMethodSignatures, String defaultMethod) {
        Builder b = new Builder(parentPath, m, useMethodSignatures, defaultMethod);
        this.method = m;
        this.httpMethod = b.httpMethod;
        this.path = b.path;
        this.fullPath = b.fullPath;
        this.pathArgs = b.pathArgs.toArray(new RemoteMethodArg[b.pathArgs.size()]);
        this.queryArgs = b.queryArgs.toArray(new RemoteMethodArg[b.queryArgs.size()]);
        this.formDataArgs = b.formDataArgs.toArray(new RemoteMethodArg[b.formDataArgs.size()]);
        this.headerArgs = b.headerArgs.toArray(new RemoteMethodArg[b.headerArgs.size()]);
        this.requestArgs = b.requestArgs.toArray(new RemoteMethodBeanArg[b.requestArgs.size()]);
        this.otherArgs = b.otherArgs.toArray(new RemoteMethodArg[b.otherArgs.size()]);
        this.bodyArg = b.bodyArg;
        this.methodReturn = b.methodReturn;
        this.exceptions = m.getExceptionTypes();
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public String getFullPath() {
        return this.fullPath;
    }

    public RemoteMethodArg[] getPathArgs() {
        return this.pathArgs;
    }

    public RemoteMethodArg[] getQueryArgs() {
        return this.queryArgs;
    }

    public RemoteMethodArg[] getFormDataArgs() {
        return this.formDataArgs;
    }

    public RemoteMethodArg[] getHeaderArgs() {
        return this.headerArgs;
    }

    public RemoteMethodBeanArg[] getRequestArgs() {
        return this.requestArgs;
    }

    public RemoteMethodArg[] getOtherArgs() {
        return this.otherArgs;
    }

    public RemoteMethodArg getBodyArg() {
        return this.bodyArg;
    }

    public RemoteMethodReturn getReturns() {
        return this.methodReturn;
    }

    public String getPath() {
        return this.path;
    }

    public Method getJavaMethod() {
        return this.method;
    }

    public Class<?>[] getExceptions() {
        return this.exceptions;
    }

    private static final class Builder {
        String httpMethod;
        String fullPath;
        String path;
        List<RemoteMethodArg> pathArgs = new LinkedList<RemoteMethodArg>();
        List<RemoteMethodArg> queryArgs = new LinkedList<RemoteMethodArg>();
        List<RemoteMethodArg> headerArgs = new LinkedList<RemoteMethodArg>();
        List<RemoteMethodArg> formDataArgs = new LinkedList<RemoteMethodArg>();
        List<RemoteMethodArg> otherArgs = new LinkedList<RemoteMethodArg>();
        List<RemoteMethodBeanArg> requestArgs = new LinkedList<RemoteMethodBeanArg>();
        RemoteMethodArg bodyArg;
        RemoteMethodReturn methodReturn;

        Builder(String parentPath, Method m, boolean useMethodSignatures, String defaultMethod) {
            MethodInfo mi = ClassUtils.getMethodInfo(m);
            RemoteMethod rm = mi.getAnnotation(RemoteMethod.class);
            this.httpMethod = rm == null ? "" : rm.method();
            String string = this.path = rm == null ? "" : rm.path();
            if (this.path.isEmpty()) {
                this.path = HttpUtils.detectHttpPath(m, !useMethodSignatures);
                if (useMethodSignatures) {
                    this.path = this.path + HttpUtils.getMethodArgsSignature(m, true);
                }
            }
            if (this.httpMethod.isEmpty()) {
                this.httpMethod = HttpUtils.detectHttpMethod(m, !useMethodSignatures, defaultMethod);
            }
            this.path = StringUtils.trimSlashes(this.path);
            if (!StringUtils.isOneOf(this.httpMethod, "DELETE", "GET", "POST", "PUT", "OPTIONS", "HEAD", "CONNECT", "TRACE", "PATCH")) {
                throw new RemoteMetadataException(m, "Invalid value specified for @RemoteMethod(httpMethod) annotation.  Valid values are [DELTE,GET,POST,PUT].", new Object[0]);
            }
            this.methodReturn = new RemoteMethodReturn(mi);
            this.fullPath = this.path.indexOf("://") != -1 ? this.path : (parentPath.isEmpty() ? StringUtils.urlEncodePath(this.path) : StringUtils.trimSlashes(parentPath) + '/' + StringUtils.urlEncodePath(this.path));
            for (ParamInfo mpi : mi.getParams()) {
                RequestBeanMeta rmba;
                RemoteMethodArg rma = RemoteMethodArg.create(mpi);
                boolean annotated = false;
                if (rma != null) {
                    annotated = true;
                    HttpPartType pt = rma.getPartType();
                    if (pt == HttpPartType.HEADER) {
                        this.headerArgs.add(rma);
                    } else if (pt == HttpPartType.QUERY) {
                        this.queryArgs.add(rma);
                    } else if (pt == HttpPartType.FORMDATA) {
                        this.formDataArgs.add(rma);
                    } else if (pt == HttpPartType.PATH) {
                        this.pathArgs.add(rma);
                    } else if (pt == HttpPartType.BODY) {
                        this.bodyArg = rma;
                    } else {
                        annotated = false;
                    }
                }
                if ((rmba = RequestBeanMeta.create(mpi, PropertyStore.DEFAULT)) != null) {
                    annotated = true;
                    this.requestArgs.add(new RemoteMethodBeanArg(mpi.getIndex(), null, rmba));
                }
                if (annotated) continue;
                this.otherArgs.add(new RemoteMethodArg(mpi.getIndex(), HttpPartType.BODY, null));
            }
        }
    }
}

