/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest;

import java.lang.reflect.Type;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.httppart.HttpPartParser;
import org.apache.juneau.httppart.HttpPartSchema;
import org.apache.juneau.httppart.HttpPartType;
import org.apache.juneau.httppart.SchemaValidationException;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.rest.exception.BadRequest;
import org.apache.juneau.rest.exception.InternalServerError;

public class RequestPath
extends TreeMap<String, String> {
    private static final long serialVersionUID = 1L;
    static final String REST_PATHVARS_ATTR = "juneau.pathVars";
    private final RestRequest req;
    private HttpPartParser parser;

    RequestPath(RestRequest req) {
        super(String.CASE_INSENSITIVE_ORDER);
        this.req = req;
        Map parentVars = (Map)req.getAttribute(REST_PATHVARS_ATTR);
        if (parentVars != null) {
            for (Map.Entry e : parentVars.entrySet()) {
                this.put(e.getKey(), e.getValue());
            }
        }
    }

    RequestPath parser(HttpPartParser parser) {
        this.parser = parser;
        return this;
    }

    RequestPath remainder(String remainder) {
        this.put("/**", remainder);
        this.put("/*", StringUtils.urlDecode(remainder));
        return this;
    }

    @Override
    public void put(String name, Object value) {
        super.put(name, value.toString());
    }

    public String getString(String name) throws BadRequest, InternalServerError {
        return this.getInner(this.parser, null, name, null, this.req.getBeanSession().string());
    }

    public int getInt(String name) throws BadRequest, InternalServerError {
        return this.getInner(this.parser, null, name, null, this.getClassMeta(Integer.TYPE));
    }

    public boolean getBoolean(String name) throws BadRequest, InternalServerError {
        return this.getInner(null, null, name, null, this.getClassMeta(Boolean.TYPE));
    }

    public <T> T get(String name, Class<T> type) throws BadRequest, InternalServerError {
        return this.getInner(null, null, name, null, this.getClassMeta(type));
    }

    public <T> T get(HttpPartParser parser, HttpPartSchema schema, String name, Class<T> type) throws BadRequest, InternalServerError {
        return this.getInner(parser, schema, name, null, this.getClassMeta(type));
    }

    public <T> T get(String name, Type type, Type ... args) throws BadRequest, InternalServerError {
        return this.getInner(null, null, name, null, this.getClassMeta(type, args));
    }

    public <T> T get(HttpPartParser parser, HttpPartSchema schema, String name, Type type, Type ... args) throws BadRequest, InternalServerError {
        return this.getInner(parser, schema, name, null, this.getClassMeta(type, args));
    }

    private <T> T getInner(HttpPartParser parser, HttpPartSchema schema, String name, T def, ClassMeta<T> cm) throws BadRequest, InternalServerError {
        try {
            if (cm.isMapOrBean() && StringUtils.isOneOf(name, "*", "")) {
                ObjectMap m = new ObjectMap();
                for (Map.Entry e : this.entrySet()) {
                    String k = (String)e.getKey();
                    HttpPartSchema pschema = schema == null ? null : schema.getProperty(k);
                    ClassMeta<?> cm2 = cm.getValueType();
                    m.put(k, this.getInner(parser, pschema, k, null, cm2));
                }
                return this.req.getBeanSession().convertToType((Object)m, cm);
            }
            T t = this.parse(parser, schema, (String)this.get(name), cm);
            return t == null ? def : t;
        }
        catch (SchemaValidationException e) {
            throw new BadRequest((Throwable)e, "Validation failed on path parameter ''{0}''. ", name);
        }
        catch (ParseException e) {
            throw new BadRequest((Throwable)e, "Could not parse path parameter ''{0}''.", name);
        }
        catch (Exception e) {
            throw new InternalServerError((Throwable)e, "Could not parse path parameter ''{0}''.", name);
        }
    }

    private <T> T parse(HttpPartParser parser, HttpPartSchema schema, String val, ClassMeta<T> cm) throws SchemaValidationException, ParseException {
        if (parser == null) {
            parser = this.parser;
        }
        return parser.createPartSession(this.req.getParserSessionArgs()).parse(HttpPartType.PATH, schema, val, cm);
    }

    public String getRemainder() {
        return (String)this.get("/*");
    }

    public String getRemainderUndecoded() {
        return (String)this.get("/**");
    }

    private <T> ClassMeta<T> getClassMeta(Type type, Type ... args) {
        return this.req.getBeanSession().getClassMeta(type, args);
    }

    private <T> ClassMeta<T> getClassMeta(Class<T> type) {
        return this.req.getBeanSession().getClassMeta(type);
    }

    static HttpServletRequest addPathVars(HttpServletRequest req, Map<String, String> vars) {
        if (vars != null && !vars.isEmpty()) {
            TreeMap<String, String> m = (TreeMap<String, String>)req.getAttribute(REST_PATHVARS_ATTR);
            if (m == null) {
                m = new TreeMap<String, String>();
                req.setAttribute(REST_PATHVARS_ATTR, m);
            }
            m.putAll(vars);
        }
        return req;
    }
}

