/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.reflect;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.juneau.ExecutableException;
import org.apache.juneau.Visibility;
import org.apache.juneau.annotation.BeanIgnore;
import org.apache.juneau.reflect.ClassInfo;
import org.apache.juneau.reflect.ExecutableInfo;

@BeanIgnore
public final class ConstructorInfo
extends ExecutableInfo
implements Comparable<ConstructorInfo> {
    private final Constructor<?> c;

    protected ConstructorInfo(ClassInfo declaringClass, Constructor<?> c) {
        super(declaringClass, c);
        this.c = c;
    }

    public static ConstructorInfo of(ClassInfo declaringClass, Constructor<?> c) {
        if (c == null) {
            return null;
        }
        return new ConstructorInfo(declaringClass, c);
    }

    public static ConstructorInfo of(Constructor<?> c) {
        if (c == null) {
            return null;
        }
        return new ConstructorInfo(ClassInfo.of(c.getDeclaringClass()), c);
    }

    public <T> Constructor<T> inner() {
        return this.c;
    }

    public <T> T invoke(Object ... args) throws ExecutableException {
        try {
            return (T)this.c.newInstance(args);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new ExecutableException(e);
        }
    }

    public ConstructorInfo makeAccessible(Visibility v) {
        if (v.transform(this.c) == null) {
            return null;
        }
        return this;
    }

    @Override
    public int compareTo(ConstructorInfo o) {
        int i = this.getSimpleName().compareTo(o.getSimpleName());
        if (i == 0 && (i = this.getParamCount() - o.getParamCount()) == 0) {
            for (int j = 0; j < this.getParamCount() && i == 0; ++j) {
                Class<?>[] tpt = this.rawParamTypes();
                Class<?>[] opt = o.rawParamTypes();
                i = tpt[j].getName().compareTo(opt[j].getName());
            }
        }
        return i;
    }
}

