/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import org.apache.juneau.ExecutableException;
import org.apache.juneau.FormattedIllegalArgumentException;
import org.apache.juneau.Value;
import org.apache.juneau.Visibility;
import org.apache.juneau.annotation.BeanIgnore;
import org.apache.juneau.internal.ClassUtils;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.reflect.AnnotationInfo;
import org.apache.juneau.reflect.AnnotationList;
import org.apache.juneau.reflect.ConstructorInfo;
import org.apache.juneau.reflect.FieldInfo;
import org.apache.juneau.reflect.MethodInfo;
import org.apache.juneau.reflect.ReflectFlags;
import org.apache.juneau.utils.AMap;

@BeanIgnore
public final class ClassInfo {
    private final Type t;
    final Class<?> c;
    private final boolean isParameterizedType;
    private List<ClassInfo> interfaces;
    private List<ClassInfo> declaredInterfaces;
    private List<ClassInfo> parents;
    private List<ClassInfo> allParents;
    private List<MethodInfo> publicMethods;
    private List<MethodInfo> declaredMethods;
    private List<MethodInfo> allMethods;
    private List<MethodInfo> allMethodsParentFirst;
    private List<ConstructorInfo> publicConstructors;
    private List<ConstructorInfo> declaredConstructors;
    private List<FieldInfo> publicFields;
    private List<FieldInfo> declaredFields;
    private List<FieldInfo> allFields;
    private List<FieldInfo> allFieldsParentFirst;
    private Map<Class<?>, Optional<Annotation>> annotationMap;
    private Map<Class<?>, Optional<Annotation>> declaredAnnotationMap;
    private int dim = -1;
    private ClassInfo componentType;
    private static final Map<Class<?>, Class<?>> pmap1 = new HashMap();
    private static final Map<Class<?>, Class<?>> pmap2 = new HashMap();
    private static final Map<Class<?>, Object> primitiveDefaultMap;

    protected ClassInfo(Class<?> c, Type t) {
        this.t = t;
        this.c = c;
        this.isParameterizedType = t == null ? false : t instanceof ParameterizedType;
    }

    public static ClassInfo of(Type t) {
        if (t == null) {
            return null;
        }
        return new ClassInfo(ClassUtils.toClass(t), t);
    }

    public static ClassInfo of(Class<?> c) {
        if (c == null) {
            return null;
        }
        return new ClassInfo(c, c);
    }

    public static ClassInfo of(Class<?> c, Type t) {
        return new ClassInfo(c, t);
    }

    public static ClassInfo of(Object o) {
        if (o == null) {
            return null;
        }
        return new ClassInfo(o.getClass(), o.getClass());
    }

    public Type innerType() {
        return this.t;
    }

    public <T> Class<T> inner() {
        return this.c;
    }

    public ClassInfo resolved() {
        if (Value.isType(this.t)) {
            return ClassInfo.of(Value.getParameterType(this.t));
        }
        return this;
    }

    public ClassInfo getParent() {
        return this.c == null ? null : ClassInfo.of(this.c.getSuperclass());
    }

    public List<ClassInfo> getDeclaredInterfaces() {
        if (this.declaredInterfaces == null) {
            Class[] ii = this.c == null ? new Class[]{} : this.c.getInterfaces();
            ArrayList<ClassInfo> l = new ArrayList<ClassInfo>(ii.length);
            for (Class i : ii) {
                l.add(ClassInfo.of(i));
            }
            this.declaredInterfaces = CollectionUtils.unmodifiableList(l);
        }
        return this.declaredInterfaces;
    }

    public List<ClassInfo> getInterfaces() {
        if (this.interfaces == null) {
            LinkedHashSet<ClassInfo> s = new LinkedHashSet<ClassInfo>();
            for (ClassInfo ci : this.getParents()) {
                for (ClassInfo ci2 : ci.getDeclaredInterfaces()) {
                    s.add(ci2);
                    for (ClassInfo ci3 : ci2.getInterfaces()) {
                        s.add(ci3);
                    }
                }
            }
            this.interfaces = CollectionUtils.unmodifiableList(new ArrayList(s));
        }
        return this.interfaces;
    }

    public Iterable<ClassInfo> getInterfacesParentFirst() {
        return CollectionUtils.iterable(this.getInterfaces(), true);
    }

    public List<ClassInfo> getParents() {
        if (this.parents == null) {
            ArrayList<ClassInfo> l = new ArrayList<ClassInfo>();
            for (Class<?> pc = this.c; pc != null && pc != Object.class; pc = pc.getSuperclass()) {
                l.add(ClassInfo.of(pc));
            }
            this.parents = Collections.unmodifiableList(l);
        }
        return this.parents;
    }

    public Iterable<ClassInfo> getParentsParentFirst() {
        return CollectionUtils.iterable(this.getParents(), true);
    }

    public List<ClassInfo> getAllParents() {
        if (this.allParents == null) {
            ArrayList<ClassInfo> l = new ArrayList<ClassInfo>();
            l.addAll(this.getParents());
            l.addAll(this.getInterfaces());
            this.allParents = Collections.unmodifiableList(l);
        }
        return this.allParents;
    }

    public Iterable<ClassInfo> getAllParentsParentFirst() {
        return CollectionUtils.iterable(this.getAllParents(), true);
    }

    public List<MethodInfo> getPublicMethods() {
        if (this.publicMethods == null) {
            Method[] mm = this.c == null ? new Method[]{} : this.c.getMethods();
            ArrayList<MethodInfo> l = new ArrayList<MethodInfo>(mm.length);
            for (Method m : mm) {
                if (m.getDeclaringClass() == Object.class) continue;
                l.add(MethodInfo.of(this, m));
            }
            l.sort(null);
            this.publicMethods = Collections.unmodifiableList(l);
        }
        return this.publicMethods;
    }

    public MethodInfo getPublicMethod(String name, Class<?> ... args) {
        for (MethodInfo mi : this.getPublicMethods()) {
            if (!mi.hasName(name) || !mi.hasParamTypes(args)) continue;
            return mi;
        }
        return null;
    }

    public MethodInfo getMethod(String name, Class<?> ... args) {
        for (MethodInfo mi : this.getAllMethods()) {
            if (!mi.hasName(name) || !mi.hasParamTypes(args)) continue;
            return mi;
        }
        return null;
    }

    public List<MethodInfo> getDeclaredMethods() {
        if (this.declaredMethods == null) {
            Method[] mm = this.c == null ? new Method[]{} : this.c.getDeclaredMethods();
            ArrayList<MethodInfo> l = new ArrayList<MethodInfo>(mm.length);
            for (Method m : mm) {
                if ("$jacocoInit".equals(m.getName())) continue;
                l.add(MethodInfo.of(this, m));
            }
            l.sort(null);
            this.declaredMethods = Collections.unmodifiableList(l);
        }
        return this.declaredMethods;
    }

    public List<MethodInfo> getAllMethods() {
        if (this.allMethods == null) {
            ArrayList<MethodInfo> l = new ArrayList<MethodInfo>();
            for (ClassInfo c : this.getAllParents()) {
                c.appendDeclaredMethods(l);
            }
            this.allMethods = Collections.unmodifiableList(l);
        }
        return this.allMethods;
    }

    public List<MethodInfo> getAllMethodsParentFirst() {
        if (this.allMethodsParentFirst == null) {
            ArrayList<MethodInfo> l = new ArrayList<MethodInfo>();
            for (ClassInfo c : this.getAllParentsParentFirst()) {
                c.appendDeclaredMethods(l);
            }
            this.allMethodsParentFirst = Collections.unmodifiableList(l);
        }
        return this.allMethodsParentFirst;
    }

    private List<MethodInfo> appendDeclaredMethods(List<MethodInfo> l) {
        l.addAll(this.getDeclaredMethods());
        return l;
    }

    public MethodInfo getStaticCreateMethod(Class<?> ic, String ... additionalNames) {
        if (this.c != null) {
            for (MethodInfo m : this.getPublicMethods()) {
                if (!m.isAll(ReflectFlags.STATIC, ReflectFlags.PUBLIC, ReflectFlags.NOT_DEPRECATED) || !m.hasReturnType(this.c) || !m.hasParamTypes(ic)) continue;
                String n = m.getSimpleName();
                String cn = ic.getSimpleName();
                if (!(StringUtils.isOneOf(n, "create", "from", "fromValue", "parse", "valueOf") || StringUtils.isOneOf(n, additionalNames) || n.startsWith("from") && n.substring(4).equals(cn) || n.startsWith("for") && n.substring(3).equals(cn)) && (!n.startsWith("parse") || !n.substring(5).equals(cn))) continue;
                return m;
            }
        }
        return null;
    }

    public MethodInfo getStaticPublicMethod(String name, Class<?> rt, Class<?> ... args) {
        if (this.c != null) {
            for (MethodInfo m : this.getPublicMethods()) {
                if (!m.isAll(ReflectFlags.STATIC, ReflectFlags.PUBLIC, ReflectFlags.NOT_DEPRECATED) || !name.equals(m.getSimpleName()) || !m.hasReturnType(rt) || !m.hasParamTypes(args)) continue;
                return m;
            }
        }
        return null;
    }

    public Method getStaticPublicMethodInner(String name, Class<?> rt, Class<?> ... args) {
        MethodInfo mi = this.getStaticPublicMethod(name, rt, args);
        return mi == null ? null : mi.inner();
    }

    public MethodInfo getBuilderCreateMethod() {
        for (MethodInfo m : this.getDeclaredMethods()) {
            if (!m.isAll(ReflectFlags.PUBLIC, ReflectFlags.STATIC) || !m.hasName("create") || m.hasReturnType(Void.TYPE)) continue;
            return m;
        }
        return null;
    }

    public MethodInfo getBuilderBuildMethod() {
        for (MethodInfo m : this.getDeclaredMethods()) {
            if (!m.isAll(ReflectFlags.NOT_STATIC) || !m.hasName("build") || m.hasParams() || m.hasReturnType(Void.TYPE)) continue;
            return m;
        }
        return null;
    }

    public List<ConstructorInfo> getPublicConstructors() {
        if (this.publicConstructors == null) {
            Constructor[] cc = this.c == null ? new Constructor[]{} : this.c.getConstructors();
            ArrayList<ConstructorInfo> l = new ArrayList<ConstructorInfo>(cc.length);
            for (Constructor ccc : cc) {
                l.add(ConstructorInfo.of(this, ccc));
            }
            l.sort(null);
            this.publicConstructors = Collections.unmodifiableList(l);
        }
        return this.publicConstructors;
    }

    public ConstructorInfo getPublicConstructor(Class<?> ... args) {
        for (ConstructorInfo ci : this.getPublicConstructors()) {
            if (!ci.hasParamTypes(args)) continue;
            return ci;
        }
        return null;
    }

    public ConstructorInfo getDeclaredConstructor(Class<?> ... args) {
        for (ConstructorInfo ci : this.getDeclaredConstructors()) {
            if (!ci.hasParamTypes(args)) continue;
            return ci;
        }
        return null;
    }

    public ConstructorInfo getAvailablePublicConstructor(Class<?> ... args) {
        return this.getConstructor(Visibility.PUBLIC, false, args);
    }

    public List<ConstructorInfo> getDeclaredConstructors() {
        if (this.declaredConstructors == null) {
            Constructor[] cc = this.c == null ? new Constructor[]{} : this.c.getDeclaredConstructors();
            ArrayList<ConstructorInfo> l = new ArrayList<ConstructorInfo>(cc.length);
            for (Constructor ccc : cc) {
                l.add(ConstructorInfo.of(this, ccc));
            }
            l.sort(null);
            this.declaredConstructors = Collections.unmodifiableList(l);
        }
        return this.declaredConstructors;
    }

    public ConstructorInfo getPublicConstructor(Object ... args) {
        return this.getPublicConstructor(ClassUtils.getClasses(args));
    }

    public ConstructorInfo getPublicConstructorFuzzy(Object ... args) {
        return this.getConstructor(Visibility.PUBLIC, true, ClassUtils.getClasses(args));
    }

    public ConstructorInfo getConstructor(Visibility vis, Class<?> ... argTypes) {
        return this.getConstructor(vis, false, argTypes);
    }

    private ConstructorInfo getConstructor(Visibility vis, boolean fuzzyArgs, Class<?> ... argTypes) {
        if (fuzzyArgs) {
            int bestCount = -1;
            ConstructorInfo bestMatch = null;
            for (ConstructorInfo n : this.getDeclaredConstructors()) {
                int m;
                if (!vis.isVisible(n.inner()) || (m = ClassUtils.fuzzyArgsMatch(n.getParamTypes(), argTypes)) <= bestCount) continue;
                bestCount = m;
                bestMatch = n;
            }
            return bestMatch;
        }
        boolean isMemberClass = this.isNonStaticMemberClass();
        for (ConstructorInfo n : this.getDeclaredConstructors()) {
            List<ClassInfo> paramTypes = n.getParamTypes();
            if (isMemberClass) {
                paramTypes = paramTypes.subList(1, paramTypes.size());
            }
            if (!ClassUtils.argsMatch(paramTypes, argTypes) || !vis.isVisible(n.inner())) continue;
            return n;
        }
        return null;
    }

    public ConstructorInfo getNoArgConstructor(Visibility v) {
        if (this.isAbstract()) {
            return null;
        }
        boolean isMemberClass = this.isNonStaticMemberClass();
        for (ConstructorInfo cc : this.getDeclaredConstructors()) {
            if (!cc.hasNumParams(isMemberClass ? 1 : 0) || !cc.isVisible(v)) continue;
            return cc.makeAccessible(v);
        }
        return null;
    }

    public List<FieldInfo> getPublicFields() {
        if (this.publicFields == null) {
            LinkedHashMap<String, FieldInfo> m = new LinkedHashMap<String, FieldInfo>();
            for (ClassInfo c : this.getParents()) {
                c.appendDeclaredPublicFields(m);
            }
            ArrayList l = new ArrayList(m.values());
            l.sort(null);
            this.publicFields = Collections.unmodifiableList(l);
        }
        return this.publicFields;
    }

    public List<FieldInfo> getDeclaredFields() {
        if (this.declaredFields == null) {
            Field[] ff = this.c == null ? new Field[]{} : this.c.getDeclaredFields();
            ArrayList<FieldInfo> l = new ArrayList<FieldInfo>(ff.length);
            for (Field f : ff) {
                if ("$jacocoData".equals(f.getName())) continue;
                l.add(FieldInfo.of(this, f));
            }
            l.sort(null);
            this.declaredFields = Collections.unmodifiableList(l);
        }
        return this.declaredFields;
    }

    public List<FieldInfo> getAllFields() {
        if (this.allFields == null) {
            ArrayList<FieldInfo> l = new ArrayList<FieldInfo>();
            for (ClassInfo c : this.getAllParents()) {
                c.appendDeclaredFields(l);
            }
            this.allFields = Collections.unmodifiableList(l);
        }
        return this.allFields;
    }

    public List<FieldInfo> getAllFieldsParentFirst() {
        if (this.allFieldsParentFirst == null) {
            ArrayList<FieldInfo> l = new ArrayList<FieldInfo>();
            for (ClassInfo c : this.getAllParentsParentFirst()) {
                c.appendDeclaredFields(l);
            }
            this.allFieldsParentFirst = Collections.unmodifiableList(l);
        }
        return this.allFieldsParentFirst;
    }

    private List<FieldInfo> appendDeclaredFields(List<FieldInfo> l) {
        l.addAll(this.getDeclaredFields());
        return l;
    }

    private Map<String, FieldInfo> appendDeclaredPublicFields(Map<String, FieldInfo> m) {
        for (FieldInfo f : this.getDeclaredFields()) {
            String fn = f.getName();
            if (!f.isPublic() || m.containsKey(fn) || "$jacocoData".equals(fn)) continue;
            m.put(f.getName(), f);
        }
        return m;
    }

    public FieldInfo getPublicField(String name) {
        for (FieldInfo f : this.getPublicFields()) {
            if (!f.getName().equals(name)) continue;
            return f;
        }
        return null;
    }

    public FieldInfo getDeclaredField(String name) {
        for (FieldInfo f : this.getDeclaredFields()) {
            if (!f.getName().equals(name)) continue;
            return f;
        }
        return null;
    }

    public FieldInfo getStaticPublicField(String name) {
        for (FieldInfo f : this.getPublicFields()) {
            if (!f.isStatic() || !f.getName().equals(name)) continue;
            return f;
        }
        return null;
    }

    public Field getStaticPublicFieldInner(String name) {
        for (FieldInfo f : this.getPublicFields()) {
            if (!f.isStatic() || !f.getName().equals(name)) continue;
            return f.inner();
        }
        return null;
    }

    public <T extends Annotation> T getAnnotation(Class<T> a) {
        if (a == null) {
            return null;
        }
        Optional<Annotation> o = this.annotationMap().get(a);
        if (o == null) {
            o = Optional.ofNullable(this.findAnnotation(a));
            this.annotationMap().put(a, o);
        }
        return (T)(o.isPresent() ? o.get() : null);
    }

    public boolean hasAnnotation(Class<? extends Annotation> a) {
        return this.getAnnotation(a) != null;
    }

    public <T extends Annotation> T getDeclaredAnnotation(Class<T> a) {
        if (a == null) {
            return null;
        }
        Optional<Annotation> o = this.declaredAnnotationMap().get(a);
        if (o == null) {
            o = Optional.ofNullable(this.findDeclaredAnnotation(a));
            this.declaredAnnotationMap().put(a, o);
        }
        return (T)(o.isPresent() ? o.get() : null);
    }

    public <T extends Annotation> T getPackageAnnotation(Class<T> a) {
        Package p = this.c == null ? null : this.c.getPackage();
        return p == null ? null : (T)p.getAnnotation(a);
    }

    public <T extends Annotation> AnnotationInfo<T> getDeclaredAnnotationInfo(Class<T> a) {
        T ca = this.getDeclaredAnnotation(a);
        return ca == null ? null : AnnotationInfo.of(this, ca);
    }

    public <T extends Annotation> AnnotationInfo<T> getPackageAnnotationInfo(Class<T> a) {
        T ca = this.getPackageAnnotation(a);
        return ca == null ? null : AnnotationInfo.of(this.getPackage(), ca);
    }

    public <T extends Annotation> List<T> getAnnotations(Class<T> a) {
        return this.appendAnnotations(new ArrayList(), a);
    }

    public <T extends Annotation> List<T> getAnnotationsParentFirst(Class<T> a) {
        return this.appendAnnotationsParentFirst(new ArrayList(), a);
    }

    public <T extends Annotation> List<AnnotationInfo<T>> getAnnotationInfos(Class<T> a) {
        return this.appendAnnotationInfos(new ArrayList<AnnotationInfo<T>>(), a);
    }

    public <T extends Annotation> List<AnnotationInfo<T>> getAnnotationInfosParentFirst(Class<T> a) {
        return this.appendAnnotationInfosParentFirst(new ArrayList<AnnotationInfo<T>>(), a);
    }

    public AnnotationList getAnnotationList(Predicate<AnnotationInfo<?>> filter) {
        return this.appendAnnotationList(new AnnotationList(filter));
    }

    public AnnotationList getAnnotationListParentFirst(Predicate<AnnotationInfo<?>> filter) {
        return this.appendAnnotationListParentFirst(new AnnotationList(filter));
    }

    public <T extends Annotation> List<T> appendAnnotations(List<T> l, Class<T> a) {
        for (ClassInfo ci : this.getParents()) {
            CollectionUtils.addIfNotNull(l, ci.getDeclaredAnnotation(a));
        }
        for (ClassInfo ci : this.getInterfaces()) {
            CollectionUtils.addIfNotNull(l, ci.getDeclaredAnnotation(a));
        }
        CollectionUtils.addIfNotNull(l, this.getPackageAnnotation(a));
        return l;
    }

    public <T extends Annotation> List<T> appendAnnotationsParentFirst(List<T> l, Class<T> a) {
        CollectionUtils.addIfNotNull(l, this.getPackageAnnotation(a));
        for (ClassInfo ci : this.getInterfacesParentFirst()) {
            CollectionUtils.addIfNotNull(l, ci.getDeclaredAnnotation(a));
        }
        for (ClassInfo ci : this.getParentsParentFirst()) {
            CollectionUtils.addIfNotNull(l, ci.getDeclaredAnnotation(a));
        }
        return l;
    }

    public <T extends Annotation> List<AnnotationInfo<T>> appendAnnotationInfos(List<AnnotationInfo<T>> l, Class<T> a) {
        for (ClassInfo ci : this.getParents()) {
            CollectionUtils.addIfNotNull(l, ci.getDeclaredAnnotationInfo(a));
        }
        for (ClassInfo ci : this.getInterfaces()) {
            CollectionUtils.addIfNotNull(l, ci.getDeclaredAnnotationInfo(a));
        }
        CollectionUtils.addIfNotNull(l, this.getPackageAnnotationInfo(a));
        return l;
    }

    public <T extends Annotation> List<AnnotationInfo<T>> appendAnnotationInfosParentFirst(List<AnnotationInfo<T>> l, Class<T> a) {
        CollectionUtils.addIfNotNull(l, this.getPackageAnnotationInfo(a));
        for (ClassInfo ci : this.getInterfacesParentFirst()) {
            CollectionUtils.addIfNotNull(l, ci.getDeclaredAnnotationInfo(a));
        }
        for (ClassInfo ci : this.getParentsParentFirst()) {
            CollectionUtils.addIfNotNull(l, ci.getDeclaredAnnotationInfo(a));
        }
        return l;
    }

    AnnotationList appendAnnotationList(AnnotationList m) {
        Annotation a;
        int n;
        int n2;
        Annotation[] annotationArray;
        for (ClassInfo ci : this.getParents()) {
            annotationArray = ci.c.getDeclaredAnnotations();
            n2 = annotationArray.length;
            for (n = 0; n < n2; ++n) {
                a = annotationArray[n];
                m.add(AnnotationInfo.of(ci, a));
            }
        }
        for (ClassInfo ci : this.getInterfaces()) {
            annotationArray = ci.c.getDeclaredAnnotations();
            n2 = annotationArray.length;
            for (n = 0; n < n2; ++n) {
                a = annotationArray[n];
                m.add(AnnotationInfo.of(ci, a));
            }
        }
        Package p = this.c.getPackage();
        if (p != null) {
            for (Annotation a2 : p.getDeclaredAnnotations()) {
                m.add(AnnotationInfo.of(p, a2));
            }
        }
        return m;
    }

    AnnotationList appendAnnotationListParentFirst(AnnotationList m) {
        Package p = this.c.getPackage();
        if (p != null) {
            for (Annotation a : p.getDeclaredAnnotations()) {
                m.add(AnnotationInfo.of(p, a));
            }
        }
        for (ClassInfo ci : this.getInterfacesParentFirst()) {
            Annotation[] annotationArray = ci.c.getDeclaredAnnotations();
            int n = annotationArray.length;
            for (int i = 0; i < n; ++i) {
                Annotation a = annotationArray[i];
                m.add(AnnotationInfo.of(ci, a));
            }
        }
        for (ClassInfo ci : this.getParentsParentFirst()) {
            for (Annotation a : ci.c.getDeclaredAnnotations()) {
                m.add(AnnotationInfo.of(ci, a));
            }
        }
        return m;
    }

    private <T extends Annotation> T findAnnotation(Class<T> a) {
        T t2 = this.getDeclaredAnnotation(a);
        if (t2 != null) {
            return t2;
        }
        ClassInfo sci = this.getParent();
        if (sci != null && (t2 = sci.getAnnotation(a)) != null) {
            return t2;
        }
        for (ClassInfo c2 : this.getInterfaces()) {
            t2 = c2.getAnnotation(a);
            if (t2 == null) continue;
            return t2;
        }
        return null;
    }

    private <T extends Annotation> T findDeclaredAnnotation(Class<T> a) {
        for (Annotation a2 : this.c.getDeclaredAnnotations()) {
            if (a2.annotationType() != a) continue;
            return (T)a2;
        }
        return null;
    }

    private synchronized Map<Class<?>, Optional<Annotation>> annotationMap() {
        if (this.annotationMap == null) {
            this.annotationMap = new ConcurrentHashMap();
        }
        return this.annotationMap;
    }

    private synchronized Map<Class<?>, Optional<Annotation>> declaredAnnotationMap() {
        if (this.declaredAnnotationMap == null) {
            this.declaredAnnotationMap = new ConcurrentHashMap();
        }
        return this.declaredAnnotationMap;
    }

    public boolean isAll(ReflectFlags ... flags) {
        block14: for (ReflectFlags f : flags) {
            switch (f) {
                case DEPRECATED: {
                    if (!this.isNotDeprecated()) continue block14;
                    return false;
                }
                case NOT_DEPRECATED: {
                    if (!this.isDeprecated()) continue block14;
                    return false;
                }
                case PUBLIC: {
                    if (!this.isNotPublic()) continue block14;
                    return false;
                }
                case NOT_PUBLIC: {
                    if (!this.isPublic()) continue block14;
                    return false;
                }
                case STATIC: {
                    if (!this.isNotStatic()) continue block14;
                    return false;
                }
                case NOT_STATIC: {
                    if (!this.isStatic()) continue block14;
                    return false;
                }
                case MEMBER: {
                    if (!this.isNotMemberClass()) continue block14;
                    return false;
                }
                case NOT_MEMBER: {
                    if (!this.isMemberClass()) continue block14;
                    return false;
                }
                case ABSTRACT: {
                    if (!this.isNotAbstract()) continue block14;
                    return false;
                }
                case NOT_ABSTRACT: {
                    if (!this.isAbstract()) continue block14;
                    return false;
                }
                case INTERFACE: {
                    if (!this.isClass()) continue block14;
                    return false;
                }
                case CLASS: {
                    if (!this.isInterface()) continue block14;
                    return false;
                }
                default: {
                    throw new RuntimeException("Invalid flag for class: " + (Object)((Object)f));
                }
            }
        }
        return true;
    }

    public boolean isAny(ReflectFlags ... flags) {
        block14: for (ReflectFlags f : flags) {
            switch (f) {
                case DEPRECATED: {
                    if (!this.isDeprecated()) continue block14;
                    return true;
                }
                case NOT_DEPRECATED: {
                    if (!this.isNotDeprecated()) continue block14;
                    return true;
                }
                case PUBLIC: {
                    if (!this.isPublic()) continue block14;
                    return true;
                }
                case NOT_PUBLIC: {
                    if (!this.isNotPublic()) continue block14;
                    return true;
                }
                case STATIC: {
                    if (!this.isStatic()) continue block14;
                    return true;
                }
                case NOT_STATIC: {
                    if (!this.isNotStatic()) continue block14;
                    return true;
                }
                case MEMBER: {
                    if (!this.isMemberClass()) continue block14;
                    return true;
                }
                case NOT_MEMBER: {
                    if (!this.isNotMemberClass()) continue block14;
                    return true;
                }
                case ABSTRACT: {
                    if (!this.isAbstract()) continue block14;
                    return true;
                }
                case NOT_ABSTRACT: {
                    if (!this.isNotAbstract()) continue block14;
                    return true;
                }
                case INTERFACE: {
                    if (!this.isInterface()) continue block14;
                    return true;
                }
                case CLASS: {
                    if (!this.isClass()) continue block14;
                    return true;
                }
                default: {
                    throw new RuntimeException("Invalid flag for class: " + (Object)((Object)f));
                }
            }
        }
        return false;
    }

    public boolean isDeprecated() {
        return this.c != null && this.c.isAnnotationPresent(Deprecated.class);
    }

    public boolean isNotDeprecated() {
        return this.c == null || !this.c.isAnnotationPresent(Deprecated.class);
    }

    public boolean isPublic() {
        return this.c != null && Modifier.isPublic(this.c.getModifiers());
    }

    public boolean isNotPublic() {
        return this.c == null || !Modifier.isPublic(this.c.getModifiers());
    }

    public boolean isStatic() {
        return this.c != null && Modifier.isStatic(this.c.getModifiers());
    }

    public boolean isNotStatic() {
        return this.c == null || !Modifier.isStatic(this.c.getModifiers());
    }

    public boolean isAbstract() {
        return this.c != null && Modifier.isAbstract(this.c.getModifiers());
    }

    public boolean isNotAbstract() {
        return this.c == null || !Modifier.isAbstract(this.c.getModifiers());
    }

    public boolean isMemberClass() {
        return this.c != null && this.c.isMemberClass();
    }

    public boolean isNotMemberClass() {
        return this.c == null || !this.c.isMemberClass();
    }

    public boolean isNonStaticMemberClass() {
        return this.c != null && this.c.isMemberClass() && !this.isStatic();
    }

    public boolean isNotNonStaticMemberClass() {
        return !this.isNonStaticMemberClass();
    }

    public boolean isLocalClass() {
        return this.c != null && this.c.isLocalClass();
    }

    public boolean isNotLocalClass() {
        return this.c == null || !this.c.isLocalClass();
    }

    public boolean isVisible(Visibility v) {
        return this.c != null && v.isVisible(this.c);
    }

    public boolean isPrimitive() {
        return this.c != null && this.c.isPrimitive();
    }

    public boolean isNotPrimitive() {
        return this.c == null || !this.c.isPrimitive();
    }

    public boolean isInterface() {
        return this.c != null && this.c.isInterface();
    }

    public boolean isClass() {
        return this.c != null && !this.c.isInterface();
    }

    public boolean hasPrimitiveWrapper() {
        return pmap1.containsKey(this.c);
    }

    public Class<?> getPrimitiveWrapper() {
        return pmap1.get(this.c);
    }

    public Class<?> getPrimitiveForWrapper() {
        return pmap2.get(this.c);
    }

    public Class<?> getWrapperIfPrimitive() {
        if (this.c != null && !this.c.isPrimitive()) {
            return this.c;
        }
        return pmap1.get(this.c);
    }

    public ClassInfo getWrapperInfoIfPrimitive() {
        if (this.c == null || !this.c.isPrimitive()) {
            return this;
        }
        return ClassInfo.of(pmap1.get(this.c));
    }

    public Object getPrimitiveDefault() {
        return primitiveDefaultMap.get(this.c);
    }

    public String getFullName() {
        Class ct = this.getComponentType().inner();
        int dim = this.getDimensions();
        if (ct != null && dim == 0 && !this.isParameterizedType) {
            return ct.getName();
        }
        StringBuilder sb = new StringBuilder(128);
        this.appendFullName(sb);
        return sb.toString();
    }

    public StringBuilder appendFullName(StringBuilder sb) {
        Class ct = this.getComponentType().inner();
        int dim = this.getDimensions();
        if (ct != null && dim == 0 && !this.isParameterizedType) {
            return sb.append(ct.getName());
        }
        sb.append(ct != null ? ct.getName() : this.t.getTypeName());
        if (this.isParameterizedType) {
            ParameterizedType pt = (ParameterizedType)this.t;
            sb.append('<');
            boolean first = true;
            for (Type t2 : pt.getActualTypeArguments()) {
                if (!first) {
                    sb.append(',');
                }
                first = false;
                ClassInfo.of(t2).appendFullName(sb);
            }
            sb.append('>');
        }
        for (int i = 0; i < dim; ++i) {
            sb.append('[').append(']');
        }
        return sb;
    }

    public String getShortName() {
        Class ct = this.getComponentType().inner();
        int dim = this.getDimensions();
        if (!(ct == null || dim != 0 || this.isParameterizedType || this.isMemberClass() || this.c.isLocalClass())) {
            return ct.getSimpleName();
        }
        StringBuilder sb = new StringBuilder(32);
        this.appendShortName(sb);
        return sb.toString();
    }

    public StringBuilder appendShortName(StringBuilder sb) {
        Class ct = this.getComponentType().inner();
        int dim = this.getDimensions();
        if (ct != null) {
            if (ct.isLocalClass()) {
                sb.append(ClassInfo.of(ct.getEnclosingClass()).getSimpleName()).append('$').append(ct.getSimpleName());
            } else if (ct.isMemberClass()) {
                sb.append(ClassInfo.of(ct.getDeclaringClass()).getSimpleName()).append('$').append(ct.getSimpleName());
            } else {
                sb.append(ct.getSimpleName());
            }
        } else {
            sb.append(this.t.getTypeName());
        }
        if (this.isParameterizedType) {
            ParameterizedType pt = (ParameterizedType)this.t;
            sb.append('<');
            boolean first = true;
            for (Type t2 : pt.getActualTypeArguments()) {
                if (!first) {
                    sb.append(',');
                }
                first = false;
                ClassInfo.of(t2).appendShortName(sb);
            }
            sb.append('>');
        }
        for (int i = 0; i < dim; ++i) {
            sb.append('[').append(']');
        }
        return sb;
    }

    public String getSimpleName() {
        return this.c != null ? this.c.getSimpleName() : this.t.getTypeName();
    }

    public String getName() {
        return this.c != null ? this.c.getName() : this.t.getTypeName();
    }

    public String getReadableName() {
        if (this.c == null) {
            return this.t.getTypeName();
        }
        if (!this.c.isArray()) {
            return this.c.getSimpleName();
        }
        Class<?> c = this.c;
        StringBuilder sb = new StringBuilder();
        while (c.isArray()) {
            sb.append("Array");
            c = c.getComponentType();
        }
        return c.getSimpleName() + sb;
    }

    public boolean isParentOf(Class<?> child) {
        return this.c != null && child != null && this.c.isAssignableFrom(child);
    }

    public boolean isParentOf(Type child) {
        if (child instanceof Class) {
            return this.isParentOf((Class)child);
        }
        return false;
    }

    public boolean isStrictChildOf(Class<?> parent) {
        return this.c != null && parent != null && parent.isAssignableFrom(this.c) && !this.c.equals(parent);
    }

    public boolean isChildOf(Class<?> parent) {
        return this.c != null && parent != null && parent.isAssignableFrom(this.c);
    }

    public boolean isChildOfAny(Class<?> ... parents) {
        for (Class<?> p : parents) {
            if (!this.isChildOf(p)) continue;
            return true;
        }
        return false;
    }

    public boolean isChildOf(Type parent) {
        if (parent instanceof Class) {
            return this.isChildOf((Class)parent);
        }
        return false;
    }

    public boolean isChildOf(ClassInfo parent) {
        return this.isChildOf(parent.inner());
    }

    public boolean is(Class<?> c) {
        return this.c != null && this.c.equals(c);
    }

    public boolean is(ClassInfo c) {
        if (this.c != null) {
            return this.c.equals(c.inner());
        }
        return this.t.equals(c.t);
    }

    public boolean isAny(Class<?> ... types) {
        for (Class<?> cc : types) {
            if (!this.is(cc)) continue;
            return true;
        }
        return false;
    }

    public Package getPackage() {
        return this.c == null ? null : this.c.getPackage();
    }

    public boolean hasPackage() {
        return this.getPackage() != null;
    }

    public int getDimensions() {
        if (this.dim == -1) {
            Class<?> ct;
            int d = 0;
            for (ct = this.c; ct != null && ct.isArray(); ct = ct.getComponentType()) {
                ++d;
            }
            this.dim = d;
            this.componentType = ct == this.c ? this : ClassInfo.of(ct);
        }
        return this.dim;
    }

    public ClassInfo getComponentType() {
        if (this.componentType == null) {
            if (this.c == null) {
                this.componentType = this;
            } else {
                this.getDimensions();
            }
        }
        return this.componentType;
    }

    public boolean isEnum() {
        return this.c != null && this.c.isEnum();
    }

    public Object newInstance() throws ExecutableException {
        if (this.c == null) {
            throw new ExecutableException("Type ''{0}'' cannot be instantiated", this.getFullName());
        }
        try {
            return this.c.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new ExecutableException(e);
        }
    }

    public Class<?> getParameterType(int index, Class<?> pt) {
        if (pt == null) {
            throw new FormattedIllegalArgumentException("Parameterized type cannot be null", new Object[0]);
        }
        HashMap<Type, Type> typeMap = new HashMap<Type, Type>();
        Class<?> cc = this.c;
        while (pt != cc.getSuperclass()) {
            ClassInfo.extractTypes(typeMap, cc);
            if ((cc = cc.getSuperclass()) != null) continue;
            throw new FormattedIllegalArgumentException("Class ''{0}'' is not a subclass of parameterized type ''{1}''", this.c.getSimpleName(), pt.getSimpleName());
        }
        Type gsc = cc.getGenericSuperclass();
        if (!(gsc instanceof ParameterizedType)) {
            throw new FormattedIllegalArgumentException("Class ''{0}'' is not a parameterized type", pt.getSimpleName());
        }
        ParameterizedType cpt = (ParameterizedType)gsc;
        Type[] atArgs = cpt.getActualTypeArguments();
        if (index >= atArgs.length) {
            throw new FormattedIllegalArgumentException("Invalid type index. index={0}, argsLength={1}", index, atArgs.length);
        }
        Type actualType = cpt.getActualTypeArguments()[index];
        if (typeMap.containsKey(actualType)) {
            actualType = (Type)typeMap.get(actualType);
        }
        if (actualType instanceof Class) {
            return (Class)actualType;
        }
        if (actualType instanceof GenericArrayType) {
            Type gct = ((GenericArrayType)actualType).getGenericComponentType();
            if (gct instanceof ParameterizedType) {
                return Array.newInstance((Class)((ParameterizedType)gct).getRawType(), 0).getClass();
            }
        } else if (actualType instanceof TypeVariable) {
            TypeVariable typeVariable = (TypeVariable)actualType;
            LinkedList nestedOuterTypes = new LinkedList();
            for (Class<?> ec = cc.getEnclosingClass(); ec != null; ec = ec.getEnclosingClass()) {
                Class<?> outerClass = cc.getClass();
                nestedOuterTypes.add(outerClass);
                HashMap<Type, Type> outerTypeMap = new HashMap<Type, Type>();
                ClassInfo.extractTypes(outerTypeMap, outerClass);
                for (Map.Entry entry : outerTypeMap.entrySet()) {
                    TypeVariable keyType;
                    Type key = (Type)entry.getKey();
                    Type value = (Type)entry.getValue();
                    if (!(key instanceof TypeVariable) || !(keyType = (TypeVariable)key).getName().equals(typeVariable.getName()) || !ClassInfo.isInnerClass(keyType.getGenericDeclaration(), typeVariable.getGenericDeclaration())) continue;
                    if (value instanceof Class) {
                        return (Class)value;
                    }
                    typeVariable = (TypeVariable)entry.getValue();
                }
            }
        } else if (actualType instanceof ParameterizedType) {
            return (Class)((ParameterizedType)actualType).getRawType();
        }
        throw new FormattedIllegalArgumentException("Could not resolve variable ''{0}'' to a type.", actualType.getTypeName());
    }

    private static boolean isInnerClass(GenericDeclaration od, GenericDeclaration id) {
        if (od instanceof Class && id instanceof Class) {
            Class oc = (Class)od;
            Class<?> ic = (Class<?>)id;
            while ((ic = ic.getEnclosingClass()) != null) {
                if (ic != oc) continue;
                return true;
            }
        }
        return false;
    }

    private static void extractTypes(Map<Type, Type> typeMap, Class<?> c) {
        Type gs = c.getGenericSuperclass();
        if (gs instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)gs;
            TypeVariable<Class<T>>[] typeParameters = ((Class)pt.getRawType()).getTypeParameters();
            Type[] actualTypeArguments = pt.getActualTypeArguments();
            for (int i = 0; i < typeParameters.length; ++i) {
                if (typeMap.containsKey(actualTypeArguments[i])) {
                    actualTypeArguments[i] = typeMap.get(actualTypeArguments[i]);
                }
                typeMap.put(typeParameters[i], actualTypeArguments[i]);
            }
        }
    }

    public String toString() {
        return this.t.toString();
    }

    public int hashCode() {
        return this.t.hashCode();
    }

    public boolean equals(Object o) {
        return o == null ? false : ((ClassInfo)o).t.equals(this.t);
    }

    static {
        pmap1.put(Boolean.TYPE, Boolean.class);
        pmap1.put(Byte.TYPE, Byte.class);
        pmap1.put(Short.TYPE, Short.class);
        pmap1.put(Character.TYPE, Character.class);
        pmap1.put(Integer.TYPE, Integer.class);
        pmap1.put(Long.TYPE, Long.class);
        pmap1.put(Float.TYPE, Float.class);
        pmap1.put(Double.TYPE, Double.class);
        pmap2.put(Boolean.class, Boolean.TYPE);
        pmap2.put(Byte.class, Byte.TYPE);
        pmap2.put(Short.class, Short.TYPE);
        pmap2.put(Character.class, Character.TYPE);
        pmap2.put(Integer.class, Integer.TYPE);
        pmap2.put(Long.class, Long.TYPE);
        pmap2.put(Float.class, Float.TYPE);
        pmap2.put(Double.class, Double.TYPE);
        primitiveDefaultMap = Collections.unmodifiableMap(new AMap<Class<Boolean>, Boolean>().append(Boolean.TYPE, false).append(Character.TYPE, (Boolean)((Object)Character.valueOf('\u0000'))).append(Short.TYPE, (Boolean)((Object)Short.valueOf((short)0))).append(Integer.TYPE, (Boolean)((Object)Integer.valueOf(0))).append(Long.TYPE, (Boolean)((Object)Long.valueOf(0L))).append(Float.TYPE, (Boolean)((Object)Float.valueOf(0.0f))).append(Double.TYPE, (Boolean)((Object)Double.valueOf(0.0))).append(Byte.TYPE, (Boolean)((Object)Byte.valueOf((byte)0))).append(Boolean.class, false).append(Character.class, (Boolean)((Object)Character.valueOf('\u0000'))).append(Short.class, (Boolean)((Object)Short.valueOf((short)0))).append(Integer.class, (Boolean)((Object)Integer.valueOf(0))).append(Long.class, (Boolean)((Object)Long.valueOf(0L))).append(Float.class, (Boolean)((Object)Float.valueOf(0.0f))).append(Double.class, (Boolean)((Object)Double.valueOf(0.0))).append(Byte.class, (Boolean)((Object)Byte.valueOf((byte)0))));
    }
}

