/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Objects;
import org.apache.juneau.ConfigApply;
import org.apache.juneau.ExecutableException;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.annotation.PropertyStoreApply;
import org.apache.juneau.internal.ArrayUtils;
import org.apache.juneau.marshall.SimpleJson;
import org.apache.juneau.reflect.ClassInfo;
import org.apache.juneau.reflect.MethodInfo;
import org.apache.juneau.svl.VarResolverSession;

public class AnnotationInfo<T extends Annotation> {
    private ClassInfo c;
    private MethodInfo m;
    private Package p;
    private T a;
    private Constructor<? extends ConfigApply<?>> configApplyConstructor;

    protected AnnotationInfo(ClassInfo c, MethodInfo m, Package p, T a) {
        this.c = c;
        this.m = m;
        this.p = p;
        this.a = a;
    }

    public static <T extends Annotation> AnnotationInfo<T> of(ClassInfo c, T a) {
        return new AnnotationInfo<T>(c, null, null, a);
    }

    public static <T extends Annotation> AnnotationInfo<T> of(MethodInfo m, T a) {
        return new AnnotationInfo<T>(null, m, null, a);
    }

    public static <T extends Annotation> AnnotationInfo<T> of(Package p, T a) {
        return new AnnotationInfo<T>(null, null, p, a);
    }

    public ClassInfo getClassOn() {
        return this.c;
    }

    public MethodInfo getMethodOn() {
        return this.m;
    }

    public Package getPackageOn() {
        return this.p;
    }

    public T getAnnotation() {
        return this.a;
    }

    public ObjectMap toObjectMap() {
        ObjectMap om = new ObjectMap();
        if (this.c != null) {
            om.put("class", this.c.getSimpleName());
        }
        if (this.m != null) {
            om.put("method", this.m.getShortName());
        }
        if (this.p != null) {
            om.put("package", this.p.getName());
        }
        ObjectMap oa = new ObjectMap();
        Class<? extends Annotation> ca = this.a.annotationType();
        for (Method m : ca.getDeclaredMethods()) {
            try {
                Object v = m.invoke(this.a, new Object[0]);
                Object d = m.getDefaultValue();
                if (Objects.equals(v, d) || ArrayUtils.isArray(v) && Array.getLength(v) == 0 && Array.getLength(d) == 0) continue;
                oa.put(m.getName(), v);
            }
            catch (Exception e) {
                oa.put(m.getName(), e.getLocalizedMessage());
            }
        }
        om.put("@" + ca.getSimpleName(), oa);
        return om;
    }

    public ConfigApply<Annotation> getConfigApply(VarResolverSession vrs) throws ExecutableException {
        try {
            if (this.configApplyConstructor == null) {
                PropertyStoreApply psa = this.a.annotationType().getAnnotation(PropertyStoreApply.class);
                if (psa != null) {
                    this.configApplyConstructor = psa.value().getConstructor(Class.class, VarResolverSession.class);
                }
                if (this.configApplyConstructor == null) {
                    throw new NoSuchFieldError("Could not find ConfigApply constructor for annotation:\n" + this.toString());
                }
            }
            ClassInfo ci = this.getClassInfo();
            return this.configApplyConstructor.newInstance(ci == null ? null : ci.inner(), vrs);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new ExecutableException(e);
        }
    }

    public ClassInfo getClassInfo() {
        if (this.c != null) {
            return this.c;
        }
        if (this.m != null) {
            return this.m.getDeclaringClass();
        }
        return null;
    }

    public boolean isType(Class<? extends Annotation> a) {
        Class<? extends Annotation> at = this.a.annotationType();
        return at == a;
    }

    public boolean hasAnnotation(Class<? extends Annotation> a) {
        return this.a.annotationType().getAnnotation(a) != null;
    }

    public String toString() {
        return SimpleJson.DEFAULT_READABLE.toString(this.toObjectMap());
    }
}

