/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.msgpack;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.juneau.BeanMap;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.BeanPropertyValue;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.DefaultFilteringObjectMap;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.internal.IOUtils;
import org.apache.juneau.msgpack.MsgPackOutputStream;
import org.apache.juneau.msgpack.MsgPackSerializer;
import org.apache.juneau.serializer.OutputStreamSerializerSession;
import org.apache.juneau.serializer.SerializeException;
import org.apache.juneau.serializer.SerializerPipe;
import org.apache.juneau.serializer.SerializerSessionArgs;
import org.apache.juneau.transform.PojoSwap;

public final class MsgPackSerializerSession
extends OutputStreamSerializerSession {
    private final MsgPackSerializer ctx;

    protected MsgPackSerializerSession(MsgPackSerializer ctx, SerializerSessionArgs args) {
        super(ctx, args);
        this.ctx = ctx;
    }

    @Override
    protected void doSerialize(SerializerPipe out, Object o) throws IOException, SerializeException {
        this.serializeAnything(MsgPackSerializerSession.getMsgPackOutputStream(out), o, this.getExpectedRootType(o), "root", null);
    }

    private static final MsgPackOutputStream getMsgPackOutputStream(SerializerPipe out) throws IOException {
        Object output = out.getRawOutput();
        if (output instanceof MsgPackOutputStream) {
            return (MsgPackOutputStream)output;
        }
        MsgPackOutputStream os = new MsgPackOutputStream(out.getOutputStream());
        out.setOutputStream(os);
        return os;
    }

    private MsgPackOutputStream serializeAnything(MsgPackOutputStream out, Object o, ClassMeta<?> eType, String attrName, BeanPropertyMeta pMeta) throws IOException, SerializeException {
        ClassMeta<Object> aType;
        boolean isRecursion;
        if (o == null) {
            return out.appendNull();
        }
        if (eType == null) {
            eType = this.object();
        }
        boolean bl = isRecursion = (aType = this.push2(attrName, o, eType)) == null;
        if (aType == null) {
            o = null;
            aType = this.object();
        }
        ClassMeta<Object> sType = aType;
        String typeName = this.getBeanTypeName(eType, aType, pMeta);
        PojoSwap<Object, ?> swap = aType.getPojoSwap(this);
        if (swap != null) {
            o = this.swap(swap, o);
            sType = swap.getSwapClassMeta(this);
            if (sType.isObject()) {
                sType = this.getClassMetaForObject(o);
            }
        }
        if (o == null || sType.isChar() && ((Character)o).charValue() == '\u0000') {
            out.appendNull();
        } else if (sType.isBoolean()) {
            out.appendBoolean((Boolean)o);
        } else if (sType.isNumber()) {
            out.appendNumber((Number)o);
        } else if (sType.isBean()) {
            this.serializeBeanMap(out, this.toBeanMap(o), typeName);
        } else if (sType.isUri() || pMeta != null && pMeta.isUri()) {
            out.appendString(this.resolveUri(o.toString()));
        } else if (sType.isMap()) {
            if (o instanceof BeanMap) {
                this.serializeBeanMap(out, (BeanMap)o, typeName);
            } else {
                this.serializeMap(out, (Map)o, eType);
            }
        } else if (sType.isCollection()) {
            this.serializeCollection(out, (Collection)o, eType);
        } else if (sType.isArray()) {
            this.serializeCollection(out, MsgPackSerializerSession.toList(sType.getInnerClass(), o), eType);
        } else if (sType.isReader() || sType.isInputStream()) {
            IOUtils.pipe(o, out);
        } else {
            out.appendString(this.toString(o));
        }
        if (!isRecursion) {
            this.pop();
        }
        return out;
    }

    private void serializeMap(MsgPackOutputStream out, Map m, ClassMeta<?> type) throws IOException, SerializeException {
        ClassMeta<?> keyType = type.getKeyType();
        ClassMeta<?> valueType = type.getValueType();
        m = this.sort(m);
        ArrayList<SimpleMapEntry> entries = new ArrayList<SimpleMapEntry>(m.size());
        for (Map.Entry entry : m.entrySet()) {
            entries.add(new SimpleMapEntry(entry.getKey(), entry.getValue()));
        }
        out.startMap(entries.size());
        for (SimpleMapEntry simpleMapEntry : entries) {
            Object value = simpleMapEntry.value;
            Object key = this.generalize(simpleMapEntry.key, keyType);
            this.serializeAnything(out, key, keyType, null, null);
            this.serializeAnything(out, value, valueType, null, null);
        }
    }

    private void serializeBeanMap(MsgPackOutputStream out, BeanMap<?> m, String typeName) throws IOException, SerializeException {
        List<BeanPropertyValue> values = m.getValues(this.isTrimNullProperties(), typeName != null ? MsgPackSerializerSession.createBeanTypeNameProperty(m, typeName) : null);
        int size = values.size();
        for (BeanPropertyValue p : values) {
            if (p.getThrown() == null) continue;
            --size;
        }
        out.startMap(size);
        for (BeanPropertyValue p : values) {
            BeanPropertyMeta pMeta = p.getMeta();
            if (!pMeta.canRead()) continue;
            ClassMeta<?> cMeta = p.getClassMeta();
            String key = p.getName();
            Object value = p.getValue();
            Throwable t = p.getThrown();
            if (t != null) {
                this.onBeanGetterException(pMeta, t);
                continue;
            }
            this.serializeAnything(out, key, null, null, null);
            this.serializeAnything(out, value, cMeta, key, pMeta);
        }
    }

    private void serializeCollection(MsgPackOutputStream out, Collection c, ClassMeta<?> type) throws IOException, SerializeException {
        ClassMeta<?> elementType = type.getElementType();
        ArrayList l = new ArrayList(c.size());
        c = this.sort(c);
        l.addAll(c);
        out.startArray(l.size());
        for (Object o : l) {
            this.serializeAnything(out, o, elementType, "<iterator>", null);
        }
    }

    @Override
    protected final boolean isAddBeanTypes() {
        return this.ctx.isAddBeanTypes();
    }

    @Override
    public ObjectMap toMap() {
        return super.toMap().append("MsgPackSerializerSession", new DefaultFilteringObjectMap());
    }

    private static final class SimpleMapEntry {
        final Object key;
        final Object value;

        SimpleMapEntry(Object key, Object value) {
            this.key = key;
            this.value = value;
        }
    }
}

