/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.microservice.resources;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.juneau.annotation.Bean;
import org.apache.juneau.dto.LinkString;
import org.apache.juneau.html.annotation.Html;
import org.apache.juneau.html.annotation.HtmlConfig;
import org.apache.juneau.html.annotation.HtmlDocConfig;
import org.apache.juneau.html.annotation.HtmlFormat;
import org.apache.juneau.http.annotation.Path;
import org.apache.juneau.http.annotation.Query;
import org.apache.juneau.http.annotation.Response;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.jsonschema.annotation.Schema;
import org.apache.juneau.microservice.resources.LogEntryFormatter;
import org.apache.juneau.microservice.resources.LogParser;
import org.apache.juneau.rest.BasicRestServlet;
import org.apache.juneau.rest.RestContextBuilder;
import org.apache.juneau.rest.RestContextProperties;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.rest.RestResponse;
import org.apache.juneau.rest.annotation.HookEvent;
import org.apache.juneau.rest.annotation.MethodSwagger;
import org.apache.juneau.rest.annotation.Property;
import org.apache.juneau.rest.annotation.RestHook;
import org.apache.juneau.rest.annotation.RestMethod;
import org.apache.juneau.rest.annotation.RestResource;
import org.apache.juneau.rest.converters.Queryable;
import org.apache.juneau.rest.exception.Forbidden;
import org.apache.juneau.rest.exception.MethodNotAllowed;
import org.apache.juneau.rest.exception.NotFound;
import org.apache.juneau.rest.helper.SeeOtherRoot;
import org.apache.juneau.rest.util.FinishablePrintWriter;

@RestResource(path="/logs", title={"Log files"}, description={"Log files from this service"}, properties={@Property(name="LogsResource.logDir.s", value="$C{Logging/logDir}"), @Property(name="LogsResource.allowDeletes.b", value="$C{Logging/allowDeletes,true}"), @Property(name="LogsResource.logFormat.s", value="$C{Logging/format}"), @Property(name="LogsResource.dateFormat.s", value="$C{Logging/dateFormat}"), @Property(name="LogsResource.useStackTraceHashes.b", value="$C{Logging/useStackTraceHashes}")}, allowedMethodParams="*")
@HtmlConfig(uriAnchorText="PROPERTY_NAME")
public class LogsResource
extends BasicRestServlet {
    private static final long serialVersionUID = 1L;
    private static final String PREFIX = "LogsResource.";
    public static final String LOGS_RESOURCE_logDir = "LogsResource.logDir.s";
    public static final String LOGS_RESOURCE_allowDeletes = "LogsResource.allowDeletes.b";
    public static final String LOGS_RESOURCE_logFormat = "LogsResource.logFormat.s";
    public static final String LOGS_RESOURCE_dateFormat = "LogsResource.dateFormat.s";
    public static final String LOGS_RESOURCE_useStackTraceHashes = "LogsResource.useStackTraceHashes.b";
    private File logDir;
    private LogEntryFormatter leFormatter;
    boolean allowDeletes;

    @RestHook(value=HookEvent.INIT)
    public void init(RestContextBuilder b) throws Exception {
        RestContextProperties p = b.getProperties();
        this.logDir = new File(p.getString(LOGS_RESOURCE_logDir));
        this.allowDeletes = p.getBoolean(LOGS_RESOURCE_allowDeletes);
        this.leFormatter = new LogEntryFormatter(p.getString(LOGS_RESOURCE_logFormat, "[{date} {level}] {msg}%n"), p.getString(LOGS_RESOURCE_dateFormat, "yyyy.MM.dd hh:mm:ss"), p.getBoolean(LOGS_RESOURCE_useStackTraceHashes, true));
    }

    @RestMethod(name="GET", path="/*", summary="View information on file or directory", description={"Returns information about the specified file or directory."})
    @HtmlDocConfig(nav={"<h5>Folder:  $RA{fullPath}</h5>"})
    public FileResource getFile(RestRequest req, @Path(value="/*") String path) throws NotFound, Exception {
        File dir = this.getFile(path);
        req.setAttribute("fullPath", dir.getAbsolutePath());
        return new FileResource(dir, path, this.allowDeletes, true);
    }

    @RestMethod(name="VIEW", path="/*", summary="View contents of log file", description={"View the contents of a log file."})
    public void viewFile(RestResponse res, @Path(value="/*") String path, @Query(name="highlight", description={"Add severity color highlighting."}, example={"true"}) boolean highlight, @Query(name="start", description={"Start timestamp (ISO8601, full or partial).\nDon't print lines logged before the specified timestamp.\nUse any of the following formats: yyyy, yyyy-MM, yyyy-MM-dd, yyyy-MM-ddThh, yyyy-MM-ddThh:mm, yyyy-MM-ddThh:mm:ss, yyyy-MM-ddThh:mm:ss.SSS"}, example={"2014-01-23T11:25:47"}) String start, @Query(name="end", description={"End timestamp (ISO8601, full or partial).\nDon't print lines logged after the specified timestamp.\nUse any of the following formats: yyyy, yyyy-MM, yyyy-MM-dd, yyyy-MM-ddThh, yyyy-MM-ddThh:mm, yyyy-MM-ddThh:mm:ss, yyyy-MM-ddThh:mm:ss.SSS"}, example={"2014-01-24"}) String end, @Query(name="thread", description={"Thread name filter.\nOnly show log entries with the specified thread name."}, example={"thread-pool-33-thread-1"}) String thread, @Query(name="loggers", description={"Logger filter (simple class name).\nOnly show log entries if they were produced by one of the specified loggers."}, example={"['LinkIndexService','LinkIndexRestService']"}) String[] loggers, @Query(name="severity", description={"Severity filter.\nOnly show log entries with the specified severity."}, example={"['ERROR','WARN']"}) String[] severity) throws NotFound, MethodNotAllowed, IOException {
        File f = this.getFile(path);
        Date startDate = StringUtils.parseIsoDate(start);
        Date endDate = StringUtils.parseIsoDate(end);
        if (!highlight) {
            Object o = this.getReader(f, startDate, endDate, thread, loggers, severity);
            res.setContentType("text/plain");
            if (o instanceof Reader) {
                res.setOutput(o);
            } else {
                try (LogParser p = (LogParser)o;
                     FinishablePrintWriter w = res.getNegotiatedWriter();){
                    p.writeTo(w);
                }
            }
            return;
        }
        res.setContentType("text/html");
        try (FinishablePrintWriter w = res.getNegotiatedWriter();){
            w.println("<html><body style='font-family:monospace;font-size:8pt;white-space:pre;'>");
            try (LogParser lp = this.getLogParser(f, startDate, endDate, thread, loggers, severity);){
                if (!lp.hasNext()) {
                    w.append("<span style='color:gray'>[EMPTY]</span>");
                } else {
                    for (LogParser.Entry le : lp) {
                        char s = le.severity.charAt(0);
                        String color = "black";
                        if (s == 'I') {
                            color = "#006400";
                        } else if (s == 'W') {
                            color = "#CC8400";
                        } else if (s == 'E' || s == 'S') {
                            color = "#DD0000";
                        } else if (s == 'D' || s == 'F' || s == 'T') {
                            color = "#000064";
                        }
                        w.append("<span style='color:").append(color).append("'>");
                        le.appendHtml(w).append("</span>");
                    }
                }
                w.append("</body></html>");
            }
        }
    }

    @RestMethod(name="PARSE", path="/*", converters={Queryable.class}, summary="View parsed contents of file", description={"View the parsed contents of a file."}, swagger=@MethodSwagger(parameters={"{in:'query',name:'s',description:'Search.\nKey/value pairs representing column names and search tokens.\n\\'*\\' and \\'?\\' can be used as meta-characters in string fields.\n\\'>\\', \\'>=\\', \\'<\\', and \\'<=\\' can be used as limits on numeric and date fields.\nDate fields can be matched with partial dates (e.g. \\'2018\\' to match any date in the year 2018).',type:'array',collectionFormat:'csv',x-examples:{example:'?s=Bill*,birthDate>2000'}},{in:'query',name:'v',description:'View.\nColumn names to display.',type:'array',collectionFormat:'csv',x-examples:{example:'?v=name,birthDate'}},{in:'query',name:'o',description:'Order by.\nColumns to sort by.\nColumn names can be suffixed with \\'+\\' or \\'-\\' to indicate ascending or descending order.\nThe default is ascending order.',type:'array',collectionFormat:'csv',x-examples:{example:'?o=name,birthDate-'}},{in:'query',name:'i',description:'Case-insensitive.\nFlag for case-insensitive matching on the search parameters.',type:'boolean',x-examples:{example:'?i=true'}},{in:'query',name:'p',description:'Position.\nOnly return rows starting at the specified index position (zero-indexed).\nDefault is 0',type:'integer',x-examples:{example:'?p=100'}},{in:'query',name:'l',description:'Limit.\nOnly return the specified number of rows.\nDefault is 0 (meaning return all rows).',type:'integer',x-examples:{example:'?l=100'}}"}))
    @HtmlDocConfig(nav={"<h5>Folder:  $RA{fullPath}</h5>"})
    public LogParser viewParsedEntries(RestRequest req, @Path(value="/*") String path, @Query(name="start", description={"Start timestamp (ISO8601, full or partial).\nDon't print lines logged before the specified timestamp.\nUse any of the following formats: yyyy, yyyy-MM, yyyy-MM-dd, yyyy-MM-ddThh, yyyy-MM-ddThh:mm, yyyy-MM-ddThh:mm:ss, yyyy-MM-ddThh:mm:ss.SSS"}, example={"2014-01-23T11:25:47"}) String start, @Query(name="end", description={"End timestamp (ISO8601, full or partial).\nDon't print lines logged after the specified timestamp.\nUse any of the following formats: yyyy, yyyy-MM, yyyy-MM-dd, yyyy-MM-ddThh, yyyy-MM-ddThh:mm, yyyy-MM-ddThh:mm:ss, yyyy-MM-ddThh:mm:ss.SSS"}, example={"2014-01-24"}) String end, @Query(name="thread", description={"Thread name filter.\nOnly show log entries with the specified thread name."}, example={"thread-pool-33-thread-1"}) String thread, @Query(name="loggers", description={"Logger filter (simple class name).\nOnly show log entries if they were produced by one of the specified loggers."}, example={"['LinkIndexService','LinkIndexRestService']"}) String[] loggers, @Query(name="severity", description={"Severity filter.\nOnly show log entries with the specified severity."}, example={"['ERROR','WARN']"}) String[] severity) throws NotFound, IOException {
        File f = this.getFile(path);
        req.setAttribute("fullPath", f.getAbsolutePath());
        Date startDate = StringUtils.parseIsoDate(start);
        Date endDate = StringUtils.parseIsoDate(end);
        return this.getLogParser(f, startDate, endDate, thread, loggers, severity);
    }

    @RestMethod(name="DOWNLOAD", path="/*", summary="Download file", description={"Download the contents of a file.\nContent-Type is set to 'application/octet-stream'."})
    public FileContents downloadFile(RestResponse res, @Path(value="/*") String path) throws NotFound, MethodNotAllowed {
        res.setContentType("application/octet-stream");
        try {
            return new FileContents(this.getFile(path));
        }
        catch (FileNotFoundException e) {
            throw new NotFound("File not found");
        }
    }

    @RestMethod(name="DELETE", path="/*", summary="Delete log file", description={"Delete a log file on the file system."})
    public RedirectToRoot deleteFile(@Path(value="/*") String path) throws MethodNotAllowed {
        this.deleteFile(this.getFile(path));
        return new RedirectToRoot();
    }

    private File getFile(String path) throws NotFound {
        if (path == null) {
            return this.logDir;
        }
        File f = new File(this.logDir.getAbsolutePath() + '/' + path);
        if (f.exists()) {
            return f;
        }
        throw new NotFound("File not found.");
    }

    private void deleteFile(File f) {
        File[] files;
        if (!this.allowDeletes) {
            throw new MethodNotAllowed("DELETE not enabled");
        }
        if (f.isDirectory() && (files = f.listFiles()) != null) {
            for (File fc : files) {
                this.deleteFile(fc);
            }
        }
        if (!f.delete()) {
            throw new Forbidden("Could not delete file {0}", f.getAbsolutePath());
        }
    }

    private static BufferedReader getReader(File f) throws IOException {
        return new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(f), Charset.defaultCharset()));
    }

    private Object getReader(File f, Date start, Date end, String thread, String[] loggers, String[] severity) throws IOException {
        if (start == null && end == null && thread == null && loggers == null) {
            return LogsResource.getReader(f);
        }
        return this.getLogParser(f, start, end, thread, loggers, severity);
    }

    private LogParser getLogParser(File f, Date start, Date end, String thread, String[] loggers, String[] severity) throws IOException {
        return new LogParser(this.leFormatter, f, start, end, thread, loggers, severity);
    }

    @Response(description={"File or directory details"})
    @Bean(properties="type,name,size,lastModified,actions,files")
    public static class FileResource {
        private final File f;
        private final String path;
        private final String uri;
        private final boolean includeChildren;
        private final boolean allowDeletes;
        static final FileFilter FILE_FILTER = new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || f.getName().endsWith(".log");
            }
        };
        static final Comparator<FileResource> FILE_COMPARATOR = new Comparator<FileResource>(){

            @Override
            public int compare(FileResource o1, FileResource o2) {
                int c = o1.getType().compareTo(o2.getType());
                return c != 0 ? c : o1.getName().compareTo(o2.getName());
            }
        };

        public FileResource(File f, String path, boolean allowDeletes, boolean includeChildren) {
            this.f = f;
            this.path = path;
            this.uri = "servlet:/" + (path == null ? "" : path);
            this.includeChildren = includeChildren;
            this.allowDeletes = allowDeletes;
        }

        public String getType() {
            return this.f.isDirectory() ? "dir" : "file";
        }

        public LinkString getName() {
            return new LinkString(this.f.getName(), this.uri, new Object[0]);
        }

        public long getSize() {
            return this.f.isDirectory() ? (long)this.f.listFiles().length : this.f.length();
        }

        public Date getLastModified() {
            return new Date(this.f.lastModified());
        }

        @Html(format=HtmlFormat.HTML_CDC)
        public List<Action> getActions() throws Exception {
            ArrayList<Action> l = new ArrayList<Action>();
            if (this.f.canRead() && !this.f.isDirectory()) {
                l.add(new Action("view", this.uri + "?method=VIEW", new Object[0]));
                l.add(new Action("highlighted", this.uri + "?method=VIEW&highlight=true", new Object[0]));
                l.add(new Action("parsed", this.uri + "?method=PARSE", new Object[0]));
                l.add(new Action("download", this.uri + "?method=DOWNLOAD", new Object[0]));
                if (this.allowDeletes) {
                    l.add(new Action("delete", this.uri + "?method=DELETE", new Object[0]));
                }
            }
            return l;
        }

        public Set<FileResource> getFiles() {
            if (this.f.isFile() || !this.includeChildren) {
                return null;
            }
            TreeSet<FileResource> s = new TreeSet<FileResource>(FILE_COMPARATOR);
            for (File fc : this.f.listFiles(FILE_FILTER)) {
                s.add(new FileResource(fc, (this.path != null ? this.path + '/' : "") + StringUtils.urlEncode(fc.getName()), this.allowDeletes, false));
            }
            return s;
        }
    }

    @Response(description={"File action"})
    public static class Action
    extends LinkString {
        public Action(String name, String uri, Object ... uriArgs) {
            super(name, uri, uriArgs);
        }
    }

    @Response(description={"Redirect to root page on success"})
    static class RedirectToRoot
    extends SeeOtherRoot {
        RedirectToRoot() {
        }
    }

    @Response(schema=@Schema(type="string", format="binary"), description={"Contents of file"})
    static class FileContents
    extends FileInputStream {
        public FileContents(File file) throws FileNotFoundException {
            super(file);
        }
    }
}

