/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.dto.swagger;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.annotation.BeanProperty;
import org.apache.juneau.internal.ObjectUtils;
import org.apache.juneau.json.JsonSerializer;
import org.apache.juneau.utils.ASet;

public abstract class SwaggerElement {
    private boolean strict;
    private Map<String, Object> extra;

    SwaggerElement() {
    }

    SwaggerElement(SwaggerElement copyFrom) {
        this.strict = copyFrom.strict;
        this.extra = copyFrom.extra == null ? null : new LinkedHashMap<String, Object>(copyFrom.extra);
    }

    protected boolean isStrict() {
        return this.strict;
    }

    protected SwaggerElement strict() {
        this.strict = true;
        return this;
    }

    protected SwaggerElement strict(Object value) {
        this.strict = value == null ? false : ObjectUtils.toBoolean(value);
        return this;
    }

    public <T> T get(String property, Class<T> type) {
        if (property == null) {
            return null;
        }
        switch (property) {
            case "strict": {
                return ObjectUtils.toType(this.isStrict(), type);
            }
        }
        return ObjectUtils.toType(this.get(property), type);
    }

    @BeanProperty(value="*")
    public Object get(String property) {
        if (property == null || this.extra == null) {
            return null;
        }
        return this.extra.get(property);
    }

    @BeanProperty(value="*")
    public SwaggerElement set(String property, Object value) {
        if (property == null) {
            return this;
        }
        switch (property) {
            case "strict": {
                return this.strict(value);
            }
        }
        if (this.extra == null) {
            this.extra = new LinkedHashMap<String, Object>();
        }
        this.extra.put(property, value);
        return this;
    }

    @BeanProperty(value="*")
    public Set<String> extraKeys() {
        return this.extra == null ? Collections.emptySet() : this.extra.keySet();
    }

    public Set<String> keySet() {
        ASet<String> s = new ASet<String>().appendIf(this.strict, "strict");
        s.addAll(this.extraKeys());
        return s;
    }

    public ObjectMap asMap() {
        ObjectMap m = new ObjectMap();
        for (String s : this.keySet()) {
            m.put(s, this.get(s, Object.class));
        }
        return m;
    }

    public String toString() {
        return JsonSerializer.DEFAULT.toString(this);
    }
}

