/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.dto.swagger;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.juneau.annotation.Bean;
import org.apache.juneau.dto.swagger.ExternalDocumentation;
import org.apache.juneau.dto.swagger.ParameterInfo;
import org.apache.juneau.dto.swagger.ResponseInfo;
import org.apache.juneau.dto.swagger.SwaggerElement;
import org.apache.juneau.http.MediaType;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.MultiSet;
import org.apache.juneau.internal.ObjectUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.utils.ASet;

@Bean(properties="operationId,summary,description,tags,externalDocs,consumes,produces,parameters,responses,schemes,deprecated,security,*")
public class Operation
extends SwaggerElement {
    private String summary;
    private String description;
    private String operationId;
    private Boolean deprecated;
    private ExternalDocumentation externalDocs;
    private List<String> tags;
    private List<String> schemes;
    private List<MediaType> consumes;
    private List<MediaType> produces;
    private List<ParameterInfo> parameters;
    private List<Map<String, List<String>>> security;
    private Map<String, ResponseInfo> responses;

    public Operation() {
    }

    public Operation(Operation copyFrom) {
        super(copyFrom);
        this.summary = copyFrom.summary;
        this.description = copyFrom.description;
        this.operationId = copyFrom.operationId;
        this.deprecated = copyFrom.deprecated;
        this.externalDocs = copyFrom.externalDocs == null ? null : copyFrom.externalDocs.copy();
        this.tags = CollectionUtils.newList(copyFrom.tags);
        this.schemes = CollectionUtils.newList(copyFrom.schemes);
        this.consumes = CollectionUtils.newList(copyFrom.consumes);
        this.produces = CollectionUtils.newList(copyFrom.produces);
        if (copyFrom.parameters == null) {
            this.parameters = null;
        } else {
            this.parameters = new ArrayList<ParameterInfo>();
            for (ParameterInfo parameterInfo : copyFrom.parameters) {
                this.parameters.add(parameterInfo.copy());
            }
        }
        if (copyFrom.security == null) {
            this.security = null;
        } else {
            this.security = new ArrayList<Map<String, List<String>>>();
            for (Map map : copyFrom.security) {
                LinkedHashMap m2 = new LinkedHashMap();
                for (Map.Entry e : map.entrySet()) {
                    m2.put(e.getKey(), CollectionUtils.newList((Collection)e.getValue()));
                }
                this.security.add(m2);
            }
        }
        if (copyFrom.responses == null) {
            this.responses = null;
        } else {
            this.responses = new LinkedHashMap<String, ResponseInfo>();
            for (Map.Entry entry : copyFrom.responses.entrySet()) {
                this.responses.put((String)entry.getKey(), ((ResponseInfo)entry.getValue()).copy());
            }
        }
    }

    public Operation copy() {
        return new Operation(this);
    }

    public List<String> getTags() {
        return this.tags;
    }

    public Operation setTags(Collection<String> value) {
        this.tags = CollectionUtils.newList(value);
        return this;
    }

    public Operation addTags(Collection<String> value) {
        this.tags = CollectionUtils.addToList(this.tags, value);
        return this;
    }

    public Operation tags(Object ... values) {
        this.tags = CollectionUtils.addToList(this.tags, values, String.class, new Type[0]);
        return this;
    }

    public String getSummary() {
        return this.summary;
    }

    public Operation setSummary(String value) {
        this.summary = value;
        return this;
    }

    public Operation summary(Object value) {
        return this.setSummary(StringUtils.stringify(value));
    }

    public String getDescription() {
        return this.description;
    }

    public Operation setDescription(String value) {
        this.description = value;
        return this;
    }

    public Operation description(Object value) {
        return this.setDescription(StringUtils.stringify(value));
    }

    public ExternalDocumentation getExternalDocs() {
        return this.externalDocs;
    }

    public Operation setExternalDocs(ExternalDocumentation value) {
        this.externalDocs = value;
        return this;
    }

    public Operation externalDocs(Object value) {
        return this.setExternalDocs(ObjectUtils.toType(value, ExternalDocumentation.class));
    }

    public String getOperationId() {
        return this.operationId;
    }

    public Operation setOperationId(String value) {
        this.operationId = value;
        return this;
    }

    public Operation operationId(Object value) {
        return this.setOperationId(StringUtils.stringify(value));
    }

    public List<MediaType> getConsumes() {
        return this.consumes;
    }

    public Operation setConsumes(Collection<MediaType> value) {
        this.consumes = CollectionUtils.newList(value);
        return this;
    }

    public Operation addConsumes(Collection<MediaType> value) {
        this.consumes = CollectionUtils.addToList(this.consumes, value);
        return this;
    }

    public Operation consumes(Object ... values) {
        this.consumes = CollectionUtils.addToList(this.consumes, values, MediaType.class, new Type[0]);
        return this;
    }

    public List<MediaType> getProduces() {
        return this.produces;
    }

    public Operation setProduces(Collection<MediaType> value) {
        this.produces = CollectionUtils.newList(value);
        return this;
    }

    public Operation addProduces(Collection<MediaType> value) {
        this.produces = CollectionUtils.addToList(this.produces, value);
        return this;
    }

    public Operation produces(Object ... values) {
        this.produces = CollectionUtils.addToList(this.produces, values, MediaType.class, new Type[0]);
        return this;
    }

    public List<ParameterInfo> getParameters() {
        return this.parameters;
    }

    public ParameterInfo getParameter(String in, String name) {
        if (this.parameters != null) {
            for (ParameterInfo pi : this.parameters) {
                if (!StringUtils.isEquals(pi.getIn(), in) || !StringUtils.isEquals(pi.getName(), name) && !"body".equals(pi.getIn())) continue;
                return pi;
            }
        }
        return null;
    }

    public Operation setParameters(Collection<ParameterInfo> value) {
        this.parameters = CollectionUtils.newList(value);
        return this;
    }

    public Operation addParameters(Collection<ParameterInfo> value) {
        this.parameters = CollectionUtils.addToList(this.parameters, value);
        return this;
    }

    public Operation parameters(Object ... values) {
        this.parameters = CollectionUtils.addToList(this.parameters, values, ParameterInfo.class, new Type[0]);
        return this;
    }

    public Map<String, ResponseInfo> getResponses() {
        return this.responses;
    }

    public ResponseInfo getResponse(Object status) {
        if (this.responses != null) {
            return this.responses.get(String.valueOf(status));
        }
        return null;
    }

    public Operation setResponses(Map<String, ResponseInfo> value) {
        this.responses = CollectionUtils.newMap(value);
        return this;
    }

    public Operation addResponses(Map<String, ResponseInfo> values) {
        this.responses = CollectionUtils.addToMap(this.responses, values);
        return this;
    }

    public Operation response(String statusCode, ResponseInfo response) {
        return this.addResponses(Collections.singletonMap(statusCode, response));
    }

    public Operation responses(Object ... value) {
        this.responses = CollectionUtils.addToMap(this.responses, value, String.class, ResponseInfo.class, new Type[0]);
        return this;
    }

    public List<String> getSchemes() {
        return this.schemes;
    }

    public Operation setSchemes(Collection<String> value) {
        this.schemes = CollectionUtils.newList(value);
        return this;
    }

    public Operation addSchemes(Collection<String> value) {
        this.schemes = CollectionUtils.addToList(this.schemes, value);
        return this;
    }

    public Operation schemes(Object ... values) {
        this.schemes = CollectionUtils.addToList(this.schemes, values, String.class, new Type[0]);
        return this;
    }

    public Boolean getDeprecated() {
        return this.deprecated;
    }

    public boolean isDeprecated() {
        return this.deprecated != null && this.deprecated == true;
    }

    public Operation setDeprecated(Boolean value) {
        this.deprecated = value;
        return this;
    }

    public Operation deprecated(Object value) {
        return this.setDeprecated(ObjectUtils.toBoolean(value));
    }

    public List<Map<String, List<String>>> getSecurity() {
        return this.security;
    }

    public Operation setSecurity(Collection<Map<String, List<String>>> value) {
        this.security = CollectionUtils.newList(value);
        return this;
    }

    public Operation addSecurity(Collection<Map<String, List<String>>> values) {
        this.security = CollectionUtils.addToList(this.security, values);
        return this;
    }

    public Operation security(String scheme, String ... alternatives) {
        LinkedHashMap<String, List<String>> m = new LinkedHashMap<String, List<String>>();
        m.put(scheme, Arrays.asList(alternatives));
        return this.addSecurity(Collections.singletonList(m));
    }

    public Operation securities(Object ... value) {
        this.security = CollectionUtils.addToList(this.security, value, Map.class, new Type[]{String.class, List.class, String.class});
        return this;
    }

    public boolean hasSummary() {
        return StringUtils.isNotEmpty(this.summary);
    }

    public boolean hasDescription() {
        return StringUtils.isNotEmpty(this.description);
    }

    public boolean hasTag(String name) {
        return this.tags != null && this.tags.contains(name);
    }

    public boolean hasNoTags() {
        return this.tags == null || this.tags.isEmpty();
    }

    public boolean hasParameters() {
        return this.parameters != null && !this.parameters.isEmpty();
    }

    public boolean hasResponses() {
        return this.responses != null && !this.responses.isEmpty();
    }

    @Override
    public <T> T get(String property, Class<T> type) {
        if (property == null) {
            return null;
        }
        switch (property) {
            case "tags": {
                return ObjectUtils.toType(this.getTags(), type);
            }
            case "summary": {
                return ObjectUtils.toType(this.getSummary(), type);
            }
            case "description": {
                return ObjectUtils.toType(this.getDescription(), type);
            }
            case "externalDocs": {
                return ObjectUtils.toType(this.getExternalDocs(), type);
            }
            case "operationId": {
                return ObjectUtils.toType(this.getOperationId(), type);
            }
            case "consumes": {
                return ObjectUtils.toType(this.getConsumes(), type);
            }
            case "produces": {
                return ObjectUtils.toType(this.getProduces(), type);
            }
            case "parameters": {
                return ObjectUtils.toType(this.getParameters(), type);
            }
            case "responses": {
                return ObjectUtils.toType(this.getResponses(), type);
            }
            case "schemes": {
                return ObjectUtils.toType(this.getSchemes(), type);
            }
            case "deprecated": {
                return ObjectUtils.toType(this.getDeprecated(), type);
            }
            case "security": {
                return ObjectUtils.toType(this.getSecurity(), type);
            }
        }
        return super.get(property, type);
    }

    @Override
    public Operation set(String property, Object value) {
        if (property == null) {
            return this;
        }
        switch (property) {
            case "tags": {
                return this.setTags(null).tags(value);
            }
            case "summary": {
                return this.summary(value);
            }
            case "description": {
                return this.description(value);
            }
            case "externalDocs": {
                return this.externalDocs(value);
            }
            case "operationId": {
                return this.operationId(value);
            }
            case "consumes": {
                return this.setConsumes(null).consumes(value);
            }
            case "produces": {
                return this.setProduces(null).produces(value);
            }
            case "parameters": {
                return this.setParameters(null).parameters(value);
            }
            case "responses": {
                return this.setResponses(null).responses(value);
            }
            case "schemes": {
                return this.setSchemes(null).schemes(value);
            }
            case "deprecated": {
                return this.deprecated(value);
            }
            case "security": {
                return this.setSecurity(null).securities(value);
            }
        }
        super.set(property, value);
        return this;
    }

    @Override
    public Set<String> keySet() {
        ASet<String> s = new ASet<String>().appendIf(this.tags != null, "tags").appendIf(this.summary != null, "summary").appendIf(this.description != null, "description").appendIf(this.externalDocs != null, "externalDocs").appendIf(this.operationId != null, "operationId").appendIf(this.consumes != null, "consumes").appendIf(this.produces != null, "produces").appendIf(this.parameters != null, "parameters").appendIf(this.responses != null, "responses").appendIf(this.schemes != null, "schemes").appendIf(this.deprecated != null, "deprecated").appendIf(this.security != null, "security");
        return new MultiSet<String>(s, super.keySet());
    }
}

