/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.dto.swagger;

import java.net.URI;
import java.util.Set;
import org.apache.juneau.annotation.Bean;
import org.apache.juneau.dto.swagger.SwaggerElement;
import org.apache.juneau.internal.MultiSet;
import org.apache.juneau.internal.ObjectUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.utils.ASet;

@Bean(properties="name,url,*")
public class License
extends SwaggerElement {
    private String name;
    private URI url;

    public License() {
    }

    public License(License copyFrom) {
        super(copyFrom);
        this.name = copyFrom.name;
        this.url = copyFrom.url;
    }

    public License copy() {
        return new License(this);
    }

    public String getName() {
        return this.name;
    }

    public License setName(String value) {
        this.name = value;
        return this;
    }

    public License name(Object value) {
        return this.setName(StringUtils.stringify(value));
    }

    public URI getUrl() {
        return this.url;
    }

    public License setUrl(URI value) {
        this.url = value;
        return this;
    }

    public License url(Object value) {
        return this.setUrl(StringUtils.toURI(value));
    }

    public boolean hasName() {
        return StringUtils.isNotEmpty(this.name);
    }

    public boolean hasUrl() {
        return this.url != null;
    }

    @Override
    public <T> T get(String property, Class<T> type) {
        if (property == null) {
            return null;
        }
        switch (property) {
            case "name": {
                return ObjectUtils.toType(this.getName(), type);
            }
            case "url": {
                return ObjectUtils.toType(this.getUrl(), type);
            }
        }
        return super.get(property, type);
    }

    @Override
    public License set(String property, Object value) {
        if (property == null) {
            return this;
        }
        switch (property) {
            case "name": {
                return this.name(value);
            }
            case "url": {
                return this.url(value);
            }
        }
        super.set(property, value);
        return this;
    }

    @Override
    public Set<String> keySet() {
        ASet<String> s = new ASet<String>().appendIf(this.name != null, "name").appendIf(this.url != null, "url");
        return new MultiSet<String>(s, super.keySet());
    }
}

