/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.dto.swagger;

import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.apache.juneau.FormattedRuntimeException;
import org.apache.juneau.ObjectList;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.annotation.Bean;
import org.apache.juneau.annotation.BeanProperty;
import org.apache.juneau.dto.swagger.Swagger;
import org.apache.juneau.dto.swagger.SwaggerElement;
import org.apache.juneau.internal.ArrayUtils;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.MultiSet;
import org.apache.juneau.internal.ObjectUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.json.SimpleJsonSerializer;
import org.apache.juneau.utils.ASet;

@Bean(properties="type,format,items,collectionFormat,default,maximum,exclusiveMaximum,minimum,exclusiveMinimum,maxLength,minLength,pattern,maxItems,minItems,uniqueItems,enum,multipleOf,$ref,*")
public class Items
extends SwaggerElement {
    private static final String[] VALID_TYPES = new String[]{"string", "number", "integer", "boolean", "array"};
    private static final String[] VALID_COLLECTION_FORMATS = new String[]{"csv", "ssv", "tsv", "pipes", "multi"};
    private String type;
    private String format;
    private String collectionFormat;
    private String pattern;
    private String ref;
    private Number maximum;
    private Number minimum;
    private Number multipleOf;
    private Integer maxLength;
    private Integer minLength;
    private Integer maxItems;
    private Integer minItems;
    private Boolean exclusiveMaximum;
    private Boolean exclusiveMinimum;
    private Boolean uniqueItems;
    private Items items;
    private Object _default;
    private List<Object> _enum;

    public Items() {
    }

    public Items(Items copyFrom) {
        super(copyFrom);
        this.type = copyFrom.type;
        this.format = copyFrom.format;
        this.collectionFormat = copyFrom.collectionFormat;
        this.pattern = copyFrom.pattern;
        this.maximum = copyFrom.maximum;
        this.minimum = copyFrom.minimum;
        this.multipleOf = copyFrom.multipleOf;
        this.maxLength = copyFrom.maxLength;
        this.minLength = copyFrom.minLength;
        this.maxItems = copyFrom.maxItems;
        this.minItems = copyFrom.minItems;
        this.exclusiveMaximum = copyFrom.exclusiveMaximum;
        this.exclusiveMinimum = copyFrom.exclusiveMinimum;
        this.uniqueItems = copyFrom.uniqueItems;
        this.items = copyFrom.items == null ? null : copyFrom.items.copy();
        this._default = copyFrom._default;
        this._enum = CollectionUtils.newList(copyFrom._enum);
        this.ref = copyFrom.ref;
    }

    public Items copy() {
        return new Items(this);
    }

    @Override
    protected Items strict() {
        super.strict();
        return this;
    }

    public String getType() {
        return this.type;
    }

    public Items setType(String value) {
        if (this.isStrict() && !ArrayUtils.contains(value, VALID_TYPES)) {
            throw new RuntimeException("Invalid value passed in to setType(String).  Value='" + value + "', valid values=" + SimpleJsonSerializer.DEFAULT.toString(VALID_TYPES));
        }
        this.type = value;
        return this;
    }

    public Items type(Object value) {
        return this.setType(StringUtils.stringify(value));
    }

    public String getFormat() {
        return this.format;
    }

    public Items setFormat(String value) {
        this.format = value;
        return this;
    }

    public Items format(Object value) {
        return this.setFormat(StringUtils.stringify(value));
    }

    public Items getItems() {
        return this.items;
    }

    public Items setItems(Items value) {
        this.items = value;
        return this;
    }

    public Items items(Object value) {
        return this.setItems(ObjectUtils.toType(value, Items.class));
    }

    public String getCollectionFormat() {
        return this.collectionFormat;
    }

    public Items setCollectionFormat(String value) {
        if (this.isStrict() && !ArrayUtils.contains(value, VALID_COLLECTION_FORMATS)) {
            throw new FormattedRuntimeException("Invalid value passed in to setCollectionFormat(String).  Value=''{0}'', valid values={1}", value, VALID_COLLECTION_FORMATS);
        }
        this.collectionFormat = value;
        return this;
    }

    public Items collectionFormat(Object value) {
        return this.setCollectionFormat(StringUtils.stringify(value));
    }

    public Object getDefault() {
        return this._default;
    }

    public Items setDefault(Object value) {
        this._default = value;
        return this;
    }

    public Items _default(Object value) {
        return this.setDefault(value);
    }

    public Number getMaximum() {
        return this.maximum;
    }

    public Items setMaximum(Number value) {
        this.maximum = value;
        return this;
    }

    public Items maximum(Object value) {
        return this.setMaximum(ObjectUtils.toNumber(value));
    }

    public Boolean getExclusiveMaximum() {
        return this.exclusiveMaximum;
    }

    public Items setExclusiveMaximum(Boolean value) {
        this.exclusiveMaximum = value;
        return this;
    }

    public Items exclusiveMaximum(Object value) {
        return this.setExclusiveMaximum(ObjectUtils.toBoolean(value));
    }

    public Number getMinimum() {
        return this.minimum;
    }

    public Items setMinimum(Number value) {
        this.minimum = value;
        return this;
    }

    public Items minimum(Object value) {
        return this.setMinimum(ObjectUtils.toNumber(value));
    }

    public Boolean getExclusiveMinimum() {
        return this.exclusiveMinimum;
    }

    public Items setExclusiveMinimum(Boolean value) {
        this.exclusiveMinimum = value;
        return this;
    }

    public Items exclusiveMinimum(Object value) {
        return this.setExclusiveMinimum(ObjectUtils.toBoolean(value));
    }

    public Integer getMaxLength() {
        return this.maxLength;
    }

    public Items setMaxLength(Integer value) {
        this.maxLength = value;
        return this;
    }

    public Items maxLength(Object value) {
        return this.setMaxLength(ObjectUtils.toInteger(value));
    }

    public Integer getMinLength() {
        return this.minLength;
    }

    public Items setMinLength(Integer value) {
        this.minLength = value;
        return this;
    }

    public Items minLength(Object value) {
        return this.setMinLength(ObjectUtils.toInteger(value));
    }

    public String getPattern() {
        return this.pattern;
    }

    public Items setPattern(String value) {
        this.pattern = value;
        return this;
    }

    public Items pattern(Object value) {
        return this.setPattern(StringUtils.stringify(value));
    }

    public Integer getMaxItems() {
        return this.maxItems;
    }

    public Items setMaxItems(Integer value) {
        this.maxItems = value;
        return this;
    }

    public Items maxItems(Object value) {
        return this.setMaxItems(ObjectUtils.toInteger(value));
    }

    public Integer getMinItems() {
        return this.minItems;
    }

    public Items setMinItems(Integer value) {
        this.minItems = value;
        return this;
    }

    public Items minItems(Object value) {
        return this.setMinItems(ObjectUtils.toInteger(value));
    }

    public Boolean getUniqueItems() {
        return this.uniqueItems;
    }

    public Items setUniqueItems(Boolean value) {
        this.uniqueItems = value;
        return this;
    }

    public Items uniqueItems(Object value) {
        return this.setUniqueItems(ObjectUtils.toBoolean(value));
    }

    public List<Object> getEnum() {
        return this._enum;
    }

    public Items setEnum(Collection<Object> value) {
        this._enum = CollectionUtils.newList(value);
        return this;
    }

    public Items addEnum(Collection<Object> values) {
        this._enum = CollectionUtils.addToList(this._enum, values);
        return this;
    }

    public Items _enum(Object ... values) {
        this._enum = CollectionUtils.addToList(this._enum, values, Object.class, new Type[0]);
        return this;
    }

    public Number getMultipleOf() {
        return this.multipleOf;
    }

    public Items setMultipleOf(Number value) {
        this.multipleOf = value;
        return this;
    }

    public Items multipleOf(Object value) {
        return this.setMultipleOf(ObjectUtils.toNumber(value));
    }

    @BeanProperty(value="$ref")
    public String getRef() {
        return this.ref;
    }

    public boolean hasRef() {
        return this.ref != null;
    }

    @BeanProperty(value="$ref")
    public Items setRef(Object value) {
        this.ref = StringUtils.stringify(value);
        return this;
    }

    public Items ref(Object value) {
        return this.setRef(value);
    }

    @Override
    public <T> T get(String property, Class<T> type) {
        if (property == null) {
            return null;
        }
        switch (property) {
            case "type": {
                return ObjectUtils.toType(this.getType(), type);
            }
            case "format": {
                return ObjectUtils.toType(this.getFormat(), type);
            }
            case "items": {
                return ObjectUtils.toType(this.getItems(), type);
            }
            case "collectionFormat": {
                return ObjectUtils.toType(this.getCollectionFormat(), type);
            }
            case "default": {
                return ObjectUtils.toType(this.getDefault(), type);
            }
            case "maximum": {
                return ObjectUtils.toType(this.getMaximum(), type);
            }
            case "exclusiveMaximum": {
                return ObjectUtils.toType(this.getExclusiveMaximum(), type);
            }
            case "minimum": {
                return ObjectUtils.toType(this.getMinimum(), type);
            }
            case "exclusiveMinimum": {
                return ObjectUtils.toType(this.getExclusiveMinimum(), type);
            }
            case "maxLength": {
                return ObjectUtils.toType(this.getMaxLength(), type);
            }
            case "minLength": {
                return ObjectUtils.toType(this.getMinLength(), type);
            }
            case "pattern": {
                return ObjectUtils.toType(this.getPattern(), type);
            }
            case "maxItems": {
                return ObjectUtils.toType(this.getMaxItems(), type);
            }
            case "minItems": {
                return ObjectUtils.toType(this.getMinItems(), type);
            }
            case "uniqueItems": {
                return ObjectUtils.toType(this.getUniqueItems(), type);
            }
            case "enum": {
                return ObjectUtils.toType(this.getEnum(), type);
            }
            case "multipleOf": {
                return ObjectUtils.toType(this.getMultipleOf(), type);
            }
            case "$ref": {
                return ObjectUtils.toType(this.getRef(), type);
            }
        }
        return super.get(property, type);
    }

    @Override
    public Items set(String property, Object value) {
        if (property == null) {
            return this;
        }
        switch (property) {
            case "type": {
                return this.type(value);
            }
            case "format": {
                return this.format(value);
            }
            case "items": {
                return this.items(value);
            }
            case "collectionFormat": {
                return this.collectionFormat(value);
            }
            case "default": {
                return this._default(value);
            }
            case "maximum": {
                return this.maximum(value);
            }
            case "exclusiveMaximum": {
                return this.exclusiveMaximum(value);
            }
            case "minimum": {
                return this.minimum(value);
            }
            case "exclusiveMinimum": {
                return this.exclusiveMinimum(value);
            }
            case "maxLength": {
                return this.maxLength(value);
            }
            case "minLength": {
                return this.minLength(value);
            }
            case "pattern": {
                return this.pattern(value);
            }
            case "maxItems": {
                return this.maxItems(value);
            }
            case "minItems": {
                return this.minItems(value);
            }
            case "uniqueItems": {
                return this.uniqueItems(value);
            }
            case "enum": {
                return this.setEnum(null)._enum(value);
            }
            case "multipleOf": {
                return this.multipleOf(value);
            }
            case "$ref": {
                return this.ref(value);
            }
        }
        super.set(property, value);
        return this;
    }

    @Override
    public Set<String> keySet() {
        ASet<String> s = new ASet<String>().appendIf(this.type != null, "type").appendIf(this.format != null, "format").appendIf(this.items != null, "items").appendIf(this.collectionFormat != null, "collectionFormat").appendIf(this._default != null, "default").appendIf(this.maximum != null, "maximum").appendIf(this.exclusiveMaximum != null, "exclusiveMaximum").appendIf(this.minimum != null, "minimum").appendIf(this.exclusiveMinimum != null, "exclusiveMinimum").appendIf(this.maxLength != null, "maxLength").appendIf(this.minLength != null, "minLength").appendIf(this.pattern != null, "pattern").appendIf(this.maxItems != null, "maxItems").appendIf(this.minItems != null, "minItems").appendIf(this.uniqueItems != null, "uniqueItems").appendIf(this._enum != null, "enum").appendIf(this.multipleOf != null, "multipleOf").appendIf(this.ref != null, "$ref");
        return new MultiSet<String>(s, super.keySet());
    }

    public Items resolveRefs(Swagger swagger, Deque<String> refStack, int maxDepth) {
        if (this.ref != null) {
            if (refStack.contains(this.ref) || refStack.size() >= maxDepth) {
                return this;
            }
            refStack.addLast(this.ref);
            Items r = swagger.findRef(this.ref, Items.class).resolveRefs(swagger, refStack, maxDepth);
            refStack.removeLast();
            return r;
        }
        this.set("properties", this.resolveRefs(this.get("properties"), swagger, refStack, maxDepth));
        if (this.items != null) {
            this.items = this.items.resolveRefs(swagger, refStack, maxDepth);
        }
        this.set("example", null);
        return this;
    }

    private Object resolveRefs(Object o, Swagger swagger, Deque<String> refStack, int maxDepth) {
        if (o instanceof ObjectMap) {
            ObjectMap om = (ObjectMap)o;
            Object ref = om.get("$ref");
            if (ref instanceof CharSequence) {
                String sref = ref.toString();
                if (refStack.contains(sref) || refStack.size() >= maxDepth) {
                    return o;
                }
                refStack.addLast(sref);
                Object o2 = swagger.findRef(sref, Object.class);
                o2 = this.resolveRefs(o2, swagger, refStack, maxDepth);
                refStack.removeLast();
                return o2;
            }
            for (Map.Entry<String, Object> e : om.entrySet()) {
                e.setValue(this.resolveRefs(e.getValue(), swagger, refStack, maxDepth));
            }
        }
        if (o instanceof ObjectList) {
            ListIterator<Object> li = ((ObjectList)o).listIterator();
            while (li.hasNext()) {
                li.set(this.resolveRefs(li.next(), swagger, refStack, maxDepth));
            }
        }
        return o;
    }
}

