/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.juneau.BeanContext;
import org.apache.juneau.BeanMetaExtended;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.BeanRegistry;
import org.apache.juneau.BeanRuntimeException;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.ExecutableException;
import org.apache.juneau.PropertyNamer;
import org.apache.juneau.Visibility;
import org.apache.juneau.annotation.Bean;
import org.apache.juneau.annotation.BeanConstructor;
import org.apache.juneau.annotation.BeanIgnore;
import org.apache.juneau.annotation.BeanProperty;
import org.apache.juneau.annotation.Name;
import org.apache.juneau.internal.ClassUtils;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.reflect.ClassInfo;
import org.apache.juneau.reflect.ConstructorInfo;
import org.apache.juneau.reflect.FieldInfo;
import org.apache.juneau.reflect.MethodInfo;
import org.apache.juneau.reflect.ParamInfo;
import org.apache.juneau.reflect.ReflectFlags;
import org.apache.juneau.transform.BeanFilter;
import org.apache.juneau.utils.MetadataMap;

public class BeanMeta<T> {
    protected final ClassMeta<T> classMeta;
    protected final Class<T> c;
    protected final Map<String, BeanPropertyMeta> properties;
    protected final Map<Method, String> getterProps;
    protected final Map<Method, String> setterProps;
    protected final BeanContext ctx;
    protected final BeanFilter beanFilter;
    protected final Map<Class<?>, Class<?>[]> typeVarImpls;
    protected final ConstructorInfo constructor;
    protected final String[] constructorArgs;
    private final MetadataMap extMeta;
    final String typePropertyName;
    private final BeanPropertyMeta typeProperty;
    final BeanPropertyMeta dynaProperty;
    private final String dictionaryName;
    final String notABeanReason;
    final BeanRegistry beanRegistry;
    final boolean sortProperties;
    final boolean fluentSetters;

    protected BeanMeta(ClassMeta<T> classMeta, BeanContext ctx, BeanFilter beanFilter, String[] pNames) {
        this.classMeta = classMeta;
        this.ctx = ctx;
        this.c = classMeta.getInnerClass();
        Builder<T> b = new Builder<T>(classMeta, ctx, beanFilter, pNames);
        this.notABeanReason = b.init(this);
        this.beanFilter = beanFilter;
        this.dictionaryName = b.dictionaryName;
        this.properties = CollectionUtils.unmodifiableMap(b.properties);
        this.getterProps = CollectionUtils.unmodifiableMap(b.getterProps);
        this.setterProps = CollectionUtils.unmodifiableMap(b.setterProps);
        this.dynaProperty = b.dynaProperty;
        this.typeVarImpls = CollectionUtils.unmodifiableMap(b.typeVarImpls);
        this.constructor = b.constructor;
        this.constructorArgs = b.constructorArgs;
        this.extMeta = b.extMeta;
        this.beanRegistry = b.beanRegistry;
        this.typePropertyName = b.typePropertyName;
        this.typeProperty = BeanPropertyMeta.builder(this, this.typePropertyName).canRead().canWrite().rawMetaType(ctx.string()).beanRegistry(this.beanRegistry).build();
        this.sortProperties = b.sortProperties;
        this.fluentSetters = b.fluentSetters;
    }

    @BeanIgnore
    public final ClassMeta<T> getClassMeta() {
        return this.classMeta;
    }

    public final String getDictionaryName() {
        return this.dictionaryName;
    }

    public final BeanPropertyMeta getTypeProperty() {
        return this.typeProperty;
    }

    static final List<BeanMethod> findBeanMethods(Class<?> c, Class<?> stopClass, Visibility v, Set<String> fixedBeanProps, Set<String> filterProps, PropertyNamer pn, boolean fluentSetters) {
        LinkedList<BeanMethod> l = new LinkedList<BeanMethod>();
        for (ClassInfo c2 : BeanMeta.findClasses(c, stopClass)) {
            for (MethodInfo m : c2.getDeclaredMethods()) {
                BeanIgnore bi;
                if (m.isStatic() || m.isBridge() || m.getParamCount() > 2 || (bi = m.getAnnotation(BeanIgnore.class)) != null) continue;
                BeanProperty bp = m.getAnnotation(BeanProperty.class);
                Name n2 = m.getAnnotation(Name.class);
                if (!m.isVisible(v) && bp == null && n2 == null) continue;
                String n = m.getSimpleName();
                List<ClassInfo> pt = m.getParamTypes();
                ClassInfo rt = m.getReturnType();
                MethodType methodType = MethodType.UNKNOWN;
                String bpName = BeanMeta.bpName(bp, n2);
                if (!(StringUtils.isEmpty(bpName) || filterProps.isEmpty() || filterProps.contains(bpName))) {
                    throw new BeanRuntimeException(c, "Found @BeanProperty(\"{0}\") but name was not found in @Bean(properties)", bpName);
                }
                if (pt.size() == 0) {
                    if ("*".equals(bpName)) {
                        if (rt.isChildOf(Collection.class)) {
                            methodType = MethodType.EXTRAKEYS;
                        } else if (rt.isChildOf(Map.class)) {
                            methodType = MethodType.GETTER;
                        }
                        n = bpName;
                    } else if (n.startsWith("get") && !rt.is(Void.TYPE)) {
                        methodType = MethodType.GETTER;
                        n = n.substring(3);
                    } else if (n.startsWith("is") && (rt.is(Boolean.TYPE) || rt.is(Boolean.class))) {
                        methodType = MethodType.GETTER;
                        n = n.substring(2);
                    } else if (bpName != null) {
                        methodType = MethodType.GETTER;
                        if (bpName.isEmpty()) {
                            if (n.startsWith("get")) {
                                n = n.substring(3);
                            } else if (n.startsWith("is")) {
                                n = n.substring(2);
                            }
                            bpName = n;
                        } else {
                            n = bpName;
                        }
                    }
                } else if (pt.size() == 1) {
                    if ("*".equals(bpName)) {
                        if (pt.get(0).isChildOf(Map.class)) {
                            methodType = MethodType.SETTER;
                            n = bpName;
                        } else if (pt.get(0).is(String.class)) {
                            methodType = MethodType.GETTER;
                            n = bpName;
                        }
                    } else if (n.startsWith("set") && (rt.isParentOf(c) || rt.is(Void.TYPE))) {
                        methodType = MethodType.SETTER;
                        n = n.substring(3);
                    } else if (bpName != null) {
                        methodType = MethodType.SETTER;
                        if (bpName.isEmpty()) {
                            if (n.startsWith("set")) {
                                n = n.substring(3);
                            }
                            bpName = n;
                        } else {
                            n = bpName;
                        }
                    } else if (fluentSetters && rt.isParentOf(c)) {
                        methodType = MethodType.SETTER;
                    }
                } else if (pt.size() == 2 && "*".equals(bpName) && pt.get(0).is(String.class)) {
                    methodType = n.startsWith("set") && (rt.isParentOf(c) || rt.is(Void.TYPE)) ? MethodType.SETTER : MethodType.GETTER;
                    n = bpName;
                }
                n = pn.getPropertyName(n);
                if ("*".equals(bpName) && methodType == MethodType.UNKNOWN) {
                    throw new BeanRuntimeException(c, "Found @BeanProperty(\"*\") but could not determine method type on method ''{0}''.", m.getSimpleName());
                }
                if (methodType == MethodType.UNKNOWN) continue;
                if (bpName != null && !bpName.isEmpty()) {
                    n = bpName;
                    if (!fixedBeanProps.isEmpty() && !fixedBeanProps.contains(n)) {
                        n = null;
                    }
                }
                if (n == null) continue;
                l.add(new BeanMethod(n, methodType, m.inner()));
            }
        }
        return l;
    }

    static final Collection<Field> findBeanFields(Class<?> c, Class<?> stopClass, Visibility v, Set<String> filterProps) {
        LinkedList<Field> l = new LinkedList<Field>();
        for (ClassInfo c2 : BeanMeta.findClasses(c, stopClass)) {
            for (FieldInfo f : c2.getDeclaredFields()) {
                if (f.isAny(ReflectFlags.STATIC, ReflectFlags.TRANSIENT) || f.hasAnnotation(BeanIgnore.class)) continue;
                BeanProperty bp = f.getAnnotation(BeanProperty.class);
                Name n = f.getAnnotation(Name.class);
                String bpName = BeanMeta.bpName(bp, n);
                if (!v.isVisible(f.inner()) && bp == null) continue;
                if (!(StringUtils.isEmpty(bpName) || filterProps.isEmpty() || filterProps.contains(bpName))) {
                    throw new BeanRuntimeException(c, "Found @BeanProperty(\"{0}\") but name was not found in @Bean(properties)", bpName);
                }
                l.add(f.inner());
            }
        }
        return l;
    }

    static final Field findInnerBeanField(Class<?> c, Class<?> stopClass, String name) {
        for (ClassInfo c2 : BeanMeta.findClasses(c, stopClass)) {
            for (FieldInfo f : c2.getDeclaredFields()) {
                if (f.isAny(ReflectFlags.STATIC, ReflectFlags.TRANSIENT) || f.hasAnnotation(BeanIgnore.class) || !f.hasName(name)) continue;
                return f.inner();
            }
        }
        return null;
    }

    private static List<ClassInfo> findClasses(Class<?> c, Class<?> stopClass) {
        LinkedList<ClassInfo> l = new LinkedList<ClassInfo>();
        BeanMeta.findClasses(c, l, stopClass);
        return l;
    }

    private static void findClasses(Class<?> c, LinkedList<ClassInfo> l, Class<?> stopClass) {
        while (c != null && stopClass != c) {
            l.addFirst(ClassUtils.getClassInfo(c));
            for (Class<?> ci : c.getInterfaces()) {
                BeanMeta.findClasses(ci, l, stopClass);
            }
            c = c.getSuperclass();
        }
    }

    public Collection<BeanPropertyMeta> getPropertyMetas() {
        return this.properties.values();
    }

    public Collection<BeanPropertyMeta> getPropertyMetas(String ... pNames) {
        if (pNames == null) {
            return this.getPropertyMetas();
        }
        ArrayList<BeanPropertyMeta> l = new ArrayList<BeanPropertyMeta>(pNames.length);
        for (int i = 0; i < pNames.length; ++i) {
            l.add(this.getPropertyMeta(pNames[i]));
        }
        return l;
    }

    public <M extends BeanMetaExtended> M getExtendedMeta(Class<M> metaDataClass) {
        return (M)((BeanMetaExtended)this.extMeta.get(metaDataClass, this));
    }

    public BeanPropertyMeta getPropertyMeta(String name) {
        BeanPropertyMeta bpm = this.properties.get(name);
        if (bpm == null) {
            bpm = this.dynaProperty;
        }
        return bpm;
    }

    protected T newBean(Object outer) throws ExecutableException {
        if (this.classMeta.isMemberClass()) {
            if (this.constructor != null) {
                return this.constructor.invoke(outer);
            }
        } else {
            if (this.constructor != null) {
                return this.constructor.invoke(null);
            }
            InvocationHandler h = this.classMeta.getProxyInvocationHandler();
            if (h != null) {
                ClassLoader cl = this.classMeta.innerClass.getClassLoader();
                return (T)Proxy.newProxyInstance(cl, new Class[]{this.classMeta.innerClass, Serializable.class}, h);
            }
        }
        return null;
    }

    static final void findTypeVarImpls(Type t, Map<Class<?>, Class<?>[]> m) {
        ParameterizedType pt;
        Type rt;
        if (t instanceof Class) {
            Class c = (Class)t;
            BeanMeta.findTypeVarImpls(c.getGenericSuperclass(), m);
            for (Type ci : c.getGenericInterfaces()) {
                BeanMeta.findTypeVarImpls(ci, m);
            }
        } else if (t instanceof ParameterizedType && (rt = (pt = (ParameterizedType)t).getRawType()) instanceof Class) {
            Type[] gImpls = pt.getActualTypeArguments();
            Class[] gTypes = new Class[gImpls.length];
            for (int i = 0; i < gImpls.length; ++i) {
                Type gt = gImpls[i];
                if (gt instanceof Class) {
                    gTypes[i] = (Class)gt;
                    continue;
                }
                if (!(gt instanceof TypeVariable)) continue;
                TypeVariable tv = (TypeVariable)gt;
                for (Type upperBound : tv.getBounds()) {
                    if (!(upperBound instanceof Class)) continue;
                    gTypes[i] = (Class)upperBound;
                }
            }
            m.put((Class)rt, gTypes);
            BeanMeta.findTypeVarImpls(pt.getRawType(), m);
        }
    }

    static final String bpName(BeanProperty bp, Name n) {
        if (bp == null && n == null) {
            return null;
        }
        if (n != null) {
            return n.value();
        }
        if (bp == null) {
            return null;
        }
        if (!bp.name().isEmpty()) {
            return bp.name();
        }
        return bp.value();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.c.getName());
        sb.append(" {\n");
        for (BeanPropertyMeta pm : this.properties.values()) {
            sb.append('\t').append(pm.toString()).append(",\n");
        }
        sb.append('}');
        return sb.toString();
    }

    private static final class BeanMethod {
        String propertyName;
        MethodType methodType;
        Method method;
        ClassInfo type;

        BeanMethod(String propertyName, MethodType type, Method method) {
            this.propertyName = propertyName;
            this.methodType = type;
            this.method = method;
            this.type = type == MethodType.SETTER ? ClassUtils.getClassInfo(method.getParameterTypes()[0]) : ClassUtils.getClassInfo(method.getReturnType());
        }

        boolean matchesPropertyType(BeanPropertyMeta.Builder b) {
            if (b == null) {
                return false;
            }
            if ("*".equals(b.name)) {
                return true;
            }
            Class<?> pt = null;
            if (b.getter != null) {
                pt = b.getter.getReturnType();
            } else if (b.field != null) {
                pt = b.field.getType();
            }
            if (pt == null) {
                return true;
            }
            if (!this.type.isParentOf(pt)) {
                return false;
            }
            if (b.setter == null) {
                return true;
            }
            return this.type.isStrictChildOf(b.setter.getParameterTypes()[0]);
        }

        public String toString() {
            return this.method.toString();
        }
    }

    static enum MethodType {
        UNKNOWN,
        GETTER,
        SETTER,
        EXTRAKEYS;

    }

    private static final class Builder<T> {
        ClassMeta<T> classMeta;
        BeanContext ctx;
        BeanFilter beanFilter;
        String[] pNames;
        Map<String, BeanPropertyMeta> properties;
        Map<Method, String> getterProps = new HashMap<Method, String>();
        Map<Method, String> setterProps = new HashMap<Method, String>();
        BeanPropertyMeta dynaProperty;
        Map<Class<?>, Class<?>[]> typeVarImpls;
        ConstructorInfo constructor;
        String[] constructorArgs = new String[0];
        MetadataMap extMeta = new MetadataMap();
        PropertyNamer propertyNamer;
        BeanRegistry beanRegistry;
        String dictionaryName;
        String typePropertyName;
        boolean sortProperties;
        boolean fluentSetters;

        Builder(ClassMeta<T> classMeta, BeanContext ctx, BeanFilter beanFilter, String[] pNames) {
            this.classMeta = classMeta;
            this.ctx = ctx;
            this.beanFilter = beanFilter;
            this.pNames = pNames;
        }

        /*
         * WARNING - void declaration
         */
        String init(BeanMeta<T> beanMeta) {
            Class<T> c = this.classMeta.getInnerClass();
            ClassInfo ci = this.classMeta.getInfo();
            try {
                Object m;
                Class<Object> stopClass;
                Bean bean;
                Visibility conVis = this.ctx.getBeanConstructorVisibility();
                Visibility cVis = this.ctx.getBeanClassVisibility();
                Visibility mVis = this.ctx.getBeanMethodVisibility();
                Visibility fVis = this.ctx.getBeanFieldVisibility();
                ArrayList bdClasses = new ArrayList();
                if (this.beanFilter != null && this.beanFilter.getBeanDictionary() != null) {
                    bdClasses.addAll(Arrays.asList(this.beanFilter.getBeanDictionary()));
                }
                if ((bean = this.classMeta.innerClass.getAnnotation(Bean.class)) != null && !bean.typeName().isEmpty()) {
                    bdClasses.add(this.classMeta.innerClass);
                }
                this.beanRegistry = new BeanRegistry(this.ctx, null, bdClasses.toArray(new Class[bdClasses.size()]));
                for (Bean b : this.classMeta.getInfo().getAnnotationsParentFirst(Bean.class)) {
                    if (b.typePropertyName().isEmpty()) continue;
                    this.typePropertyName = b.typePropertyName();
                }
                if (this.typePropertyName == null) {
                    this.typePropertyName = this.ctx.getBeanTypePropertyName();
                }
                this.fluentSetters = this.ctx.isFluentSetters() || this.beanFilter != null && this.beanFilter.isFluentSetters();
                Class<T> c2 = this.beanFilter != null && this.beanFilter.getInterfaceClass() != null ? this.beanFilter.getInterfaceClass() : c;
                Class clazz = stopClass = this.beanFilter != null ? this.beanFilter.getStopClass() : Object.class;
                if (stopClass == null) {
                    stopClass = Object.class;
                }
                LinkedHashMap<String, BeanPropertyMeta.Builder> normalProps = new LinkedHashMap<String, BeanPropertyMeta.Builder>();
                if (this.ctx.isNotABean(c)) {
                    return "Class matches exclude-class list";
                }
                if (!cVis.isVisible(c.getModifiers()) && !c.isAnonymousClass()) {
                    return "Class is not public";
                }
                if (c.isAnnotationPresent(BeanIgnore.class)) {
                    return "Class is annotated with @BeanIgnore";
                }
                if (this.beanFilter == null && this.ctx.isBeansRequireSerializable() && !ci.isChildOf(Serializable.class)) {
                    return "Class is not serializable";
                }
                for (ConstructorInfo x : ci.getPublicConstructors()) {
                    if (!x.hasAnnotation(BeanConstructor.class)) continue;
                    if (this.constructor != null) {
                        throw new BeanRuntimeException(c, "Multiple instances of '@BeanConstructor' found.", new Object[0]);
                    }
                    this.constructor = x;
                    this.constructorArgs = StringUtils.split(x.getAnnotation(BeanConstructor.class).properties());
                    if (this.constructorArgs.length != x.getParamCount()) {
                        if (this.constructorArgs.length != 0) {
                            throw new BeanRuntimeException(c, "Number of properties defined in '@BeanConstructor' annotation does not match number of parameters in constructor.", new Object[0]);
                        }
                        this.constructorArgs = new String[x.getParamCount()];
                        int i = 0;
                        for (ParamInfo paramInfo : x.getParams()) {
                            String string = paramInfo.getName();
                            if (string == null) {
                                throw new BeanRuntimeException(c, "Could not find name for parameter #{0} of constructor ''{1}''", i, x.getFullName());
                            }
                            this.constructorArgs[i++] = string;
                        }
                    }
                    this.constructor.setAccessible();
                }
                if (this.constructor == null) {
                    this.constructor = this.ctx.getImplClassConstructor(c, conVis);
                }
                if (this.constructor == null) {
                    this.constructor = ci.getNoArgConstructor(conVis);
                }
                if (this.constructor == null && this.beanFilter == null && this.ctx.isBeansRequireDefaultConstructor()) {
                    return "Class does not have the required no-arg constructor";
                }
                if (this.constructor != null) {
                    this.constructor.setAccessible();
                }
                LinkedHashSet<String> fixedBeanProps = new LinkedHashSet<String>();
                String[] includeProperties = this.ctx.getIncludeProperties(c);
                String[] excludeProperties = this.ctx.getExcludeProperties(c);
                HashSet<String> filterProps = new HashSet<String>();
                if (this.beanFilter != null) {
                    if (this.beanFilter.getProperties() != null) {
                        filterProps.addAll(Arrays.asList(this.beanFilter.getProperties()));
                    }
                    if (this.beanFilter.getProperties() != null && includeProperties == null) {
                        for (String string : this.beanFilter.getProperties()) {
                            fixedBeanProps.add(string);
                        }
                    }
                    if (this.beanFilter.getPropertyNamer() != null) {
                        this.propertyNamer = this.beanFilter.getPropertyNamer();
                    }
                }
                if (includeProperties != null) {
                    fixedBeanProps.addAll(Arrays.asList(includeProperties));
                }
                if (this.propertyNamer == null) {
                    this.propertyNamer = this.ctx.getPropertyNamer();
                }
                for (String string : fixedBeanProps) {
                    normalProps.put(string, BeanPropertyMeta.builder(beanMeta, string));
                }
                if (this.ctx.isUseJavaBeanIntrospector()) {
                    void var17_27;
                    Object var17_24 = null;
                    if (!c2.isInterface()) {
                        BeanInfo beanInfo = Introspector.getBeanInfo(c2, stopClass);
                    } else {
                        BeanInfo beanInfo = Introspector.getBeanInfo(c2, null);
                    }
                    if (var17_27 != null) {
                        void var20_68;
                        PropertyDescriptor[] propertyDescriptorArray = var17_27.getPropertyDescriptors();
                        int n = propertyDescriptorArray.length;
                        boolean bl = false;
                        while (var20_68 < n) {
                            PropertyDescriptor pd = propertyDescriptorArray[var20_68];
                            String name = pd.getName();
                            if (!normalProps.containsKey(name)) {
                                normalProps.put(name, BeanPropertyMeta.builder(beanMeta, name));
                            }
                            ((BeanPropertyMeta.Builder)normalProps.get(name)).setGetter(pd.getReadMethod()).setSetter(pd.getWriteMethod());
                            ++var20_68;
                        }
                    }
                } else {
                    for (Field field : BeanMeta.findBeanFields(c2, stopClass, fVis, filterProps)) {
                        String name = this.findPropertyName(field, fixedBeanProps);
                        if (name == null) continue;
                        if (!normalProps.containsKey(name)) {
                            normalProps.put(name, BeanPropertyMeta.builder(beanMeta, name));
                        }
                        ((BeanPropertyMeta.Builder)normalProps.get(name)).setField(field);
                    }
                    List<BeanMethod> list = BeanMeta.findBeanMethods(c2, stopClass, mVis, fixedBeanProps, filterProps, this.propertyNamer, this.fluentSetters);
                    for (BeanMethod bm : list) {
                        String string = bm.propertyName;
                        m = bm.method;
                        if (!normalProps.containsKey(string)) {
                            normalProps.put(string, new BeanPropertyMeta.Builder(beanMeta, string));
                        }
                        BeanPropertyMeta.Builder bpm2 = (BeanPropertyMeta.Builder)normalProps.get(string);
                        if (bm.methodType != MethodType.GETTER) continue;
                        if (bpm2.getter != null) {
                            if (((Method)m).getAnnotation(BeanProperty.class) == null && bpm2.getter.getAnnotation(BeanProperty.class) != null) {
                                m = bpm2.getter;
                            } else if (((Method)m).getName().startsWith("is") && bpm2.getter.getName().startsWith("get")) {
                                m = bpm2.getter;
                            }
                        }
                        bpm2.setGetter((Method)m);
                    }
                    for (BeanMethod bm : list) {
                        BeanPropertyMeta.Builder builder;
                        if (bm.methodType != MethodType.SETTER || !bm.matchesPropertyType(builder = (BeanPropertyMeta.Builder)normalProps.get(bm.propertyName))) continue;
                        builder.setSetter(bm.method);
                    }
                    for (BeanMethod bm : list) {
                        if (bm.methodType != MethodType.EXTRAKEYS) continue;
                        BeanPropertyMeta.Builder builder = (BeanPropertyMeta.Builder)normalProps.get(bm.propertyName);
                        builder.setExtraKeys(bm.method);
                    }
                }
                this.typeVarImpls = new HashMap();
                BeanMeta.findTypeVarImpls(c, this.typeVarImpls);
                if (this.typeVarImpls.isEmpty()) {
                    this.typeVarImpls = null;
                }
                Iterator iterator = normalProps.values().iterator();
                while (iterator.hasNext()) {
                    BeanPropertyMeta.Builder builder = (BeanPropertyMeta.Builder)iterator.next();
                    try {
                        if (builder.field == null) {
                            builder.setInnerField(BeanMeta.findInnerBeanField(c, stopClass, builder.name));
                        }
                        if (builder.validate(this.ctx, this.beanRegistry, this.typeVarImpls)) {
                            if (builder.getter != null) {
                                this.getterProps.put(builder.getter, builder.name);
                            }
                            if (builder.setter == null) continue;
                            this.setterProps.put(builder.setter, builder.name);
                            continue;
                        }
                        iterator.remove();
                    }
                    catch (ClassNotFoundException e) {
                        throw new BeanRuntimeException(c, e.getLocalizedMessage(), new Object[0]);
                    }
                }
                for (String string : fixedBeanProps) {
                    if (normalProps.containsKey(string)) continue;
                    throw new BeanRuntimeException(c, "The property ''{0}'' was defined on the @Bean(properties=X) annotation but was not found on the class definition.", string);
                }
                for (String string : this.constructorArgs) {
                    m = (BeanPropertyMeta.Builder)normalProps.get(string);
                    if (m == null) {
                        throw new BeanRuntimeException(c, "The property ''{0}'' was defined on the @BeanConstructor(properties=X) annotation but was not found on the class definition.", string);
                    }
                    ((BeanPropertyMeta.Builder)m).setAsConstructorArg();
                }
                if (this.beanFilter == null && this.ctx.isBeansRequireSomeProperties() && normalProps.size() == 0) {
                    return "No properties detected on bean class";
                }
                this.sortProperties = (this.ctx.isSortProperties() || this.beanFilter != null && this.beanFilter.isSortProperties()) && fixedBeanProps.isEmpty();
                this.properties = this.sortProperties ? new TreeMap<String, BeanPropertyMeta>() : new LinkedHashMap<String, BeanPropertyMeta>();
                if (this.beanFilter != null && this.beanFilter.getTypeName() != null) {
                    this.dictionaryName = this.beanFilter.getTypeName();
                }
                if (this.dictionaryName == null) {
                    this.dictionaryName = this.findDictionaryName(this.classMeta);
                }
                for (Map.Entry entry : normalProps.entrySet()) {
                    BeanPropertyMeta pMeta = ((BeanPropertyMeta.Builder)entry.getValue()).build();
                    if (pMeta.isDyna()) {
                        this.dynaProperty = pMeta;
                    }
                    this.properties.put((String)entry.getKey(), pMeta);
                }
                if (this.beanFilter != null) {
                    String[] stringArray = this.beanFilter.getProperties();
                    String[] stringArray2 = this.beanFilter.getExcludeProperties();
                    if (stringArray2 != null && excludeProperties == null) {
                        for (String k : stringArray2) {
                            this.properties.remove(k);
                        }
                    } else if (stringArray != null) {
                        LinkedHashMap<String, BeanPropertyMeta> properties2 = new LinkedHashMap<String, BeanPropertyMeta>();
                        for (String k : stringArray) {
                            if (!this.properties.containsKey(k)) continue;
                            properties2.put(k, this.properties.get(k));
                        }
                        this.properties = properties2;
                    }
                }
                if (excludeProperties != null) {
                    for (String string : excludeProperties) {
                        this.properties.remove(string);
                    }
                }
                if (this.pNames != null) {
                    void var20_80;
                    LinkedHashMap<String, BeanPropertyMeta> linkedHashMap = new LinkedHashMap<String, BeanPropertyMeta>();
                    String[] stringArray = this.pNames;
                    int n = stringArray.length;
                    boolean bl = false;
                    while (var20_80 < n) {
                        String k = stringArray[var20_80];
                        if (this.properties.containsKey(k)) {
                            linkedHashMap.put(k, this.properties.get(k));
                        }
                        ++var20_80;
                    }
                    this.properties = linkedHashMap;
                }
            }
            catch (BeanRuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                return "Exception:  " + StringUtils.getStackTrace(e);
            }
            return null;
        }

        private String findDictionaryName(ClassMeta<?> cm) {
            String s;
            String s2;
            BeanRegistry br = cm.getBeanRegistry();
            if (br != null && (s2 = br.getTypeName(this.classMeta)) != null) {
                return s2;
            }
            Class pcm = cm.innerClass.getSuperclass();
            if (pcm != null && (s = this.findDictionaryName(this.ctx.getClassMeta(pcm))) != null) {
                return s;
            }
            for (Class<?> icm : cm.innerClass.getInterfaces()) {
                String s3 = this.findDictionaryName(this.ctx.getClassMeta(icm));
                if (s3 == null) continue;
                return s3;
            }
            return null;
        }

        private String findPropertyName(Field f, Set<String> fixedBeanProps) {
            Name n;
            BeanProperty bp = f.getAnnotation(BeanProperty.class);
            String name = BeanMeta.bpName(bp, n = f.getAnnotation(Name.class));
            if (StringUtils.isNotEmpty(name)) {
                if (fixedBeanProps.isEmpty() || fixedBeanProps.contains(name)) {
                    return name;
                }
                return null;
            }
            name = this.propertyNamer.getPropertyName(f.getName());
            if (fixedBeanProps.isEmpty() || fixedBeanProps.contains(name)) {
                return name;
            }
            return null;
        }
    }
}

